/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.api.GlobalStorage;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.spi.project.ProjectStorageProvider;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ProjectStorageProviderImpl
extends ProjectStorageProvider {
    private static final String ERROR_SAVING_ATTACH_SETTINGS_MESSAGE = NbBundle.getMessage(ProjectStorageProviderImpl.class, (String)"ProjectStorageProviderImpl_ErrorSavingAttachSettingsMessage");
    private static final String ATTACH_SETTINGS_FILENAME = "attach";
    private static final String SETTINGS_FOR_ATTR = "settingsFor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachSettings loadAttachSettings(Lookup.Provider project) throws IOException {
        FileObject folder = this.getSettingsFolder(project, false);
        if (folder == null) {
            return null;
        }
        FileObject attachSettingsFile = folder.getFileObject(ATTACH_SETTINGS_FILENAME, "xml");
        if (attachSettingsFile == null) {
            return null;
        }
        InputStream fis = attachSettingsFile.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(fis);
        try {
            Properties props = new Properties();
            props.loadFromXML(bis);
            AttachSettings as = new AttachSettings();
            as.load((Map)props);
            AttachSettings attachSettings = as;
            return attachSettings;
        }
        finally {
            bis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAttachSettings(Lookup.Provider project, AttachSettings settings) {
        FileLock lock = null;
        try {
            FileObject folder = this.getSettingsFolder(project, true);
            FileObject fo = folder.getFileObject(ATTACH_SETTINGS_FILENAME, "xml");
            if (fo == null) {
                fo = folder.createData(ATTACH_SETTINGS_FILENAME, "xml");
            }
            lock = fo.lock();
            BufferedOutputStream bos = new BufferedOutputStream(fo.getOutputStream(lock));
            Properties globalProps = new Properties();
            try {
                settings.store((Map)globalProps);
                globalProps.storeToXML(bos, "");
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.displayError((String)MessageFormat.format(ERROR_SAVING_ATTACH_SETTINGS_MESSAGE, e.getMessage()));
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public synchronized FileObject getSettingsFolder(Lookup.Provider project, boolean create) throws IOException {
        if (project == null) {
            return GlobalStorage.getSettingsFolder((boolean)create);
        }
        Project p = (Project)project;
        FileObject nbproject = p.getProjectDirectory().getFileObject("nbproject");
        FileObject d = nbproject != null ? (create ? FileUtil.createFolder((FileObject)nbproject, (String)"private/profiler") : nbproject.getFileObject("private/profiler")) : ProjectUtils.getCacheDirectory((Project)p, IDEUtils.class);
        if (d != null) {
            d.setAttribute(SETTINGS_FOR_ATTR, (Object)p.getProjectDirectory().getURL());
        }
        return d;
    }

    public Lookup.Provider getProjectFromSettingsFolder(FileObject settingsFolder) {
        FileObject d;
        Object o = settingsFolder.getAttribute(SETTINGS_FOR_ATTR);
        if (o instanceof URL && (d = URLMapper.findFileObject((URL)((URL)o))) != null && d.isFolder()) {
            try {
                return ProjectManager.getDefault().findProject(d);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Project p = FileOwnerQuery.getOwner((FileObject)settingsFolder);
        try {
            if (p != null && this.getSettingsFolder((Lookup.Provider)p, false) == settingsFolder) {
                return p;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

