/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectStatement
extends AbstractExpression {
    private AbstractExpression fromClause;
    private AbstractExpression groupByClause;
    private boolean hasSpaceAfterFrom;
    private boolean hasSpaceAfterGroupBy;
    private boolean hasSpaceAfterSelect;
    private boolean hasSpaceAfterWhere;
    private AbstractExpression havingClause;
    private AbstractSelectClause selectClause;
    private AbstractExpression whereClause;

    AbstractSelectStatement(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getSelectClause().accept(visitor);
        this.getFromClause().accept(visitor);
        this.getWhereClause().accept(visitor);
        this.getGroupByClause().accept(visitor);
        this.getHavingClause().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getSelectClause());
        children.add(this.getFromClause());
        children.add(this.getWhereClause());
        children.add(this.getGroupByClause());
        children.add(this.getHavingClause());
    }

    public AbstractFromClause addFromClause() {
        AbstractFromClause fromClause = this.buildFromClause();
        this.fromClause = fromClause;
        return fromClause;
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.selectClause != null) {
            children.add(this.selectClause);
        }
        if (this.hasSpaceAfterSelect) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.fromClause != null) {
            children.add(this.fromClause);
        }
        if (this.hasSpaceAfterFrom) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.whereClause != null) {
            children.add(this.whereClause);
        }
        if (this.hasSpaceAfterWhere) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.groupByClause != null) {
            children.add(this.groupByClause);
        }
        if (this.hasSpaceAfterGroupBy) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.havingClause != null) {
            children.add(this.havingClause);
        }
    }

    public final SelectClause addSelectClause() {
        this.selectClause = this.buildSelectClause();
        return (SelectClause)this.selectClause;
    }

    final WhereClause addWhereClause() {
        WhereClause whereClause = new WhereClause(this);
        this.whereClause = whereClause;
        this.hasSpaceAfterFrom = true;
        return whereClause;
    }

    abstract AbstractFromClause buildFromClause();

    abstract AbstractSelectClause buildSelectClause();

    public final Expression getFromClause() {
        if (this.fromClause == null) {
            this.fromClause = this.buildNullExpression();
        }
        return this.fromClause;
    }

    public final Expression getGroupByClause() {
        if (this.groupByClause == null) {
            this.groupByClause = this.buildNullExpression();
        }
        return this.groupByClause;
    }

    public final Expression getHavingClause() {
        if (this.havingClause == null) {
            this.havingClause = this.buildNullExpression();
        }
        return this.havingClause;
    }

    public AbstractSelectClause getSelectClause() {
        if (this.selectClause == null) {
            this.selectClause = this.buildSelectClause();
        }
        return this.selectClause;
    }

    public final Expression getWhereClause() {
        if (this.whereClause == null) {
            this.whereClause = this.buildNullExpression();
        }
        return this.whereClause;
    }

    public final boolean hasFromClause() {
        return this.fromClause != null && !this.fromClause.isNull();
    }

    public final boolean hasGroupByClause() {
        return this.groupByClause != null && !this.groupByClause.isNull();
    }

    public final boolean hasHavingClause() {
        return this.havingClause != null && !this.havingClause.isNull();
    }

    public final boolean hasSpaceAfterFrom() {
        return this.hasSpaceAfterFrom;
    }

    public final boolean hasSpaceAfterGroupBy() {
        return this.hasSpaceAfterGroupBy;
    }

    public final boolean hasSpaceAfterSelect() {
        return this.hasSpaceAfterSelect;
    }

    public final boolean hasSpaceAfterWhere() {
        return this.hasSpaceAfterWhere;
    }

    public final boolean hasWhereClause() {
        return this.whereClause != null && !this.whereClause.isNull();
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        this.selectClause = this.buildSelectClause();
        this.selectClause.parse(wordParser, tolerant);
        boolean bl = this.hasSpaceAfterSelect = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("FROM")) {
            this.fromClause = this.buildFromClause();
            this.fromClause.parse(wordParser, tolerant);
        }
        boolean bl2 = this.hasSpaceAfterFrom = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("WHERE")) {
            this.whereClause = new WhereClause(this);
            this.whereClause.parse(wordParser, tolerant);
        }
        boolean bl3 = this.hasSpaceAfterWhere = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("GROUP BY")) {
            this.groupByClause = new GroupByClause(this);
            this.groupByClause.parse(wordParser, tolerant);
        }
        boolean bl4 = this.hasSpaceAfterGroupBy = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("HAVING")) {
            this.havingClause = new HavingClause(this);
            this.havingClause.parse(wordParser, tolerant);
        }
        if (tolerant && !wordParser.isTail() && !this.shouldManageSpaceAfterClause()) {
            if (this.hasSpaceAfterFrom && this.whereClause == null && this.groupByClause == null && this.havingClause == null) {
                this.hasSpaceAfterFrom = false;
                wordParser.moveBackward(1);
            } else if (this.hasSpaceAfterWhere && this.groupByClause == null && this.havingClause == null) {
                this.hasSpaceAfterWhere = false;
                wordParser.moveBackward(1);
            } else if (this.hasSpaceAfterGroupBy && this.havingClause == null) {
                this.hasSpaceAfterGroupBy = false;
                wordParser.moveBackward(1);
            }
        }
    }

    boolean shouldManageSpaceAfterClause() {
        return true;
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.selectClause != null) {
            this.selectClause.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterSelect) {
            writer.append(' ');
        }
        if (this.hasFromClause()) {
            this.fromClause.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterFrom) {
            writer.append(' ');
        }
        if (this.hasWhereClause()) {
            this.whereClause.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterWhere) {
            writer.append(' ');
        }
        if (this.hasGroupByClause()) {
            this.groupByClause.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterGroupBy) {
            writer.append(' ');
        }
        if (this.hasHavingClause()) {
            this.havingClause.toParsedText(writer, includeVirtual);
        }
    }
}

