/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumericLiteral
extends AbstractExpression {
    NumericLiteral(AbstractExpression parent, String numeric) {
        super(parent, numeric);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return NumericLiteral.queryBNF("numeric_literal");
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        String word;
        String text = this.getText();
        wordParser.moveForward(text);
        if (Character.toUpperCase(text.charAt(text.length() - 1)) == 'E') {
            int endIndex;
            int startIndex = wordParser.position();
            int count = wordParser.length();
            for (endIndex = wordParser.position(); endIndex < count; ++endIndex) {
                char character = wordParser.character(endIndex);
                if ((endIndex != startIndex || character != '-') && !Character.isDigit(character)) break;
            }
            if (endIndex > 0) {
                text = text + wordParser.substring(wordParser.position(), endIndex);
                this.setText(text);
                wordParser.setPosition(endIndex);
            }
        } else if ((text.equals("+") || text.equals("-")) && (word = wordParser.word()).length() > 0 && Character.isDigit(word.charAt(0))) {
            text = text + word;
            wordParser.moveForward(word);
            this.setText(text);
        }
    }

    @Override
    public String toParsedText() {
        return this.getText();
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
    }
}

