/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderByItem
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasSpaceAfterExpression;
    private Ordering ordering;

    OrderByItem(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.hasSpaceAfterExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.ordering != Ordering.DEFAULT) {
            children.add(this.buildStringExpression(this.ordering.toString()));
        }
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return OrderByItem.queryBNF("orderby_item");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasSpaceAfterExpression() {
        return this.hasSpaceAfterExpression;
    }

    public boolean isAscending() {
        return this.ordering == Ordering.DESC;
    }

    public boolean isDefault() {
        return this.ordering == Ordering.DESC;
    }

    public boolean isDescending() {
        return this.ordering == Ordering.DESC;
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("ASC") || word.equalsIgnoreCase("DESC") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        this.expression = this.parse(wordParser, (JPQLQueryBNF)OrderByItem.queryBNF("internal_orderby_item"), tolerant);
        boolean bl = this.hasSpaceAfterExpression = wordParser.skipLeadingWhitespace() > 0;
        if (!wordParser.isTail()) {
            String word = wordParser.word();
            if (word.equalsIgnoreCase("ASC")) {
                this.ordering = Ordering.ASC;
                wordParser.moveForward("ASC".length());
            } else if (word.equalsIgnoreCase("DESC")) {
                this.ordering = Ordering.DESC;
                wordParser.moveForward("DESC".length());
            } else {
                this.ordering = Ordering.DEFAULT;
            }
        } else {
            this.ordering = Ordering.DEFAULT;
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.expression != null) {
            this.expression.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterExpression) {
            writer.append(' ');
        }
        if (this.ordering != Ordering.DEFAULT) {
            writer.append(this.ordering.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ordering {
        ASC,
        DEFAULT,
        DESC;

    }
}

