/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.util;

import org.eclipse.persistence.jpa.internal.jpql.util.CompoundFilter;
import org.eclipse.persistence.jpa.internal.jpql.util.Filter;
import org.eclipse.persistence.jpa.internal.jpql.util.NullFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndFilter<T>
extends CompoundFilter<T> {
    private static final long serialVersionUID = 1L;

    public AndFilter(Filter<T> filter1, Filter<T> filter2) {
        super(filter1, filter2);
    }

    public static <T> Filter<T> and(Filter<T> ... filters) {
        int length = filters.length;
        if (length == 0) {
            return NullFilter.instance();
        }
        if (length == 1) {
            return filters[0];
        }
        AndFilter<T> filter = new AndFilter<T>(filters[0], filters[1]);
        for (int index = 2; index < length; ++index) {
            filter = new AndFilter<T>(filter, filters[index]);
        }
        return filter;
    }

    @Override
    public boolean accept(T value) {
        return this.filter1.accept(value) && this.filter2.accept(value);
    }

    @Override
    public AndFilter<T> clone() {
        return (AndFilter)super.clone();
    }

    @Override
    protected String operatorString() {
        return "AND";
    }
}

