/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.spi.BrandingSupport;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.PropertyUtils;

class SuiteBrandingSupport
extends BrandingSupport {
    private final SuiteProject project;
    private NbPlatform platform;

    SuiteBrandingSupport(SuiteProject project, String brandingPath) throws IOException {
        super((Project)project, brandingPath);
        this.project = project;
    }

    private NbPlatform getActivePlatform() {
        return this.project.getPlatform(true);
    }

    protected BrandingSupport.BrandableModule findBrandableModule(String moduleCodeNameBase) {
        NbPlatform p = this.getActivePlatform();
        if (p == null) {
            return null;
        }
        ModuleEntry me = p.getModule(moduleCodeNameBase);
        return me != null ? new ModuleEntryWrapper(me) : null;
    }

    public Set<File> getBrandableJars() {
        NbPlatform platf = this.getActivePlatform();
        Set<ModuleEntry> modules = platf.getModules();
        HashSet<File> jars = new HashSet<File>(modules.size());
        for (ModuleEntry m : modules) {
            File j = m.getJarLocation();
            if (j == null) continue;
            jars.add(j);
        }
        return jars;
    }

    protected Set<BrandingSupport.BrandableModule> loadModules() {
        NbPlatform newPlatform = this.getActivePlatform();
        if (newPlatform == null) {
            return null;
        }
        if (newPlatform.equals(this.platform)) {
            return null;
        }
        this.platform = newPlatform;
        HashSet<BrandingSupport.BrandableModule> r = new HashSet<BrandingSupport.BrandableModule>();
        for (ModuleEntry me : this.platform.getModules()) {
            r.add(new ModuleEntryWrapper(me));
        }
        return r;
    }

    protected Map<String, String> localizingBundle(BrandingSupport.BrandableModule wrapper) {
        ModuleEntry mEntry = ((ModuleEntryWrapper)wrapper).mEntry;
        return ModuleList.loadBundleInfo(mEntry.getSourceLocation()).toEditableProperties();
    }

    private static class ModuleEntryWrapper
    implements BrandingSupport.BrandableModule {
        private final ModuleEntry mEntry;

        ModuleEntryWrapper(ModuleEntry mEntry) {
            this.mEntry = mEntry;
        }

        public String getCodeNameBase() {
            return this.mEntry.getCodeNameBase();
        }

        public File getJarLocation() {
            return this.mEntry.getJarLocation();
        }

        public String getRelativePath() {
            return PropertyUtils.relativizeFile((File)this.mEntry.getClusterDirectory(), (File)this.mEntry.getJarLocation());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModuleEntryWrapper)) {
                return false;
            }
            return this.mEntry == ((ModuleEntryWrapper)obj).mEntry;
        }

        public int hashCode() {
            return this.mEntry.hashCode();
        }

        public String toString() {
            return this.mEntry.toString();
        }
    }
}

