/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class ModuleProperties {
    public static final String PROPERTIES_REFRESHED = "propertiesRefreshed";
    static final RequestProcessor RP = new RequestProcessor(ModuleProperties.class.getName());
    static boolean runFromTests;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private EditableProperties projectProperties;
    private EditableProperties privateProperties;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private List<LazyStorage> storages = new ArrayList<LazyStorage>();

    ModuleProperties(AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.reloadProperties();
    }

    public void reloadProperties() {
        this.projectProperties = this.helper.getProperties("nbproject/project.properties");
        this.privateProperties = this.helper.getProperties("nbproject/private/private.properties");
    }

    abstract Map<String, String> getDefaultValues();

    AntProjectHelper getHelper() {
        return this.helper;
    }

    PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    EditableProperties getProjectProperties() {
        return this.projectProperties;
    }

    EditableProperties getPrivateProperties() {
        return this.privateProperties;
    }

    public final String getProperty(String key) {
        String value = this.getProjectProperties().getProperty(key);
        return value != null ? value : this.getDefaultValues().get(key);
    }

    final boolean getBooleanProperty(String key) {
        String bValue = this.getProperty(key);
        return bValue != null && (bValue.equalsIgnoreCase("true") || bValue.equalsIgnoreCase("yes"));
    }

    public final String removeProperty(String key) {
        return (String)this.getProjectProperties().remove((Object)key);
    }

    final String removePrivateProperty(String key) {
        return (String)this.getPrivateProperties().remove((Object)key);
    }

    public final void setProperty(String key, String value) {
        String def = this.getDefaultValues().get(key);
        if (def == null) {
            def = "";
        }
        if (value == null || def.equals(value)) {
            this.getProjectProperties().remove((Object)key);
        } else {
            this.getProjectProperties().setProperty(key, value);
        }
        this.firePropertyChange(key, null, value);
    }

    final void setPrivateProperty(String key, String value) {
        String def = this.getDefaultValues().get(key);
        if (def == null) {
            def = "";
        }
        if (def.equals(value)) {
            this.getPrivateProperties().remove((Object)key);
        } else {
            this.getPrivateProperties().setProperty(key, value);
        }
        this.firePropertyChange(key, null, value);
    }

    void setProperty(String key, String[] value) {
        this.getProjectProperties().setProperty(key, value);
        this.firePropertyChange(key, null, null);
    }

    final void setBooleanProperty(String key, boolean bProp) {
        this.setProperty(key, Boolean.toString(bProp));
    }

    public String getProjectDisplayName() {
        return ApisupportAntUtils.getDisplayName(this.getHelper().getProjectDirectory());
    }

    public final File getProjectDirectoryFile() {
        return FileUtil.toFile((FileObject)this.getHelper().getProjectDirectory());
    }

    final String getProjectDirectory() {
        return this.getProjectDirectoryFile().getAbsolutePath();
    }

    void storeProperties() throws IOException {
        File ppf = new File(this.getProjectDirectoryFile(), "nbproject/project.properties");
        if (this.getProjectProperties().size() > 0 || ppf.exists()) {
            this.getHelper().putProperties("nbproject/project.properties", this.getProjectProperties());
        }
        ppf = new File(this.getProjectDirectoryFile(), "nbproject/private/private.properties");
        if (this.getPrivateProperties().size() > 0 || ppf.exists()) {
            this.getHelper().putProperties("nbproject/private/private.properties", this.getPrivateProperties());
        }
    }

    static void storePlatform(AntProjectHelper helper, NbPlatform platform) {
        if (platform != null && platform.getID() != null) {
            EditableProperties props = helper.getProperties("nbproject/platform.properties");
            props.put("nbplatform.active", platform.getID());
            helper.putProperties("nbproject/platform.properties", props);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pchl) {
        this.changeSupport.addPropertyChangeListener(pchl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pchl) {
        this.changeSupport.removePropertyChangeListener(pchl);
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propName, oldValue, newValue);
    }

    protected void firePropertiesRefreshed() {
        this.firePropertyChange(PROPERTIES_REFRESHED, null, null);
    }

    protected static void reportLostPlatform(NbPlatform lostPlatform) {
        String plafText = lostPlatform != null ? '\"' + lostPlatform.getLabel() + '\"' : NbBundle.getMessage(ModuleProperties.class, (String)"MSG_PreviouslySet");
        String message = NbBundle.getMessage(ModuleProperties.class, (String)"MSG_PlatformNotFound", (Object)plafText);
        if (!runFromTests) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
        } else {
            System.err.println(message);
        }
        Logger.getLogger(ModuleProperties.class.getName()).log(Level.WARNING, message);
    }

    static String getPlatformID(JavaPlatform platform) {
        String id = (String)platform.getProperties().get("platform.ant.name");
        return id != null ? id : "default";
    }

    static JavaPlatform findJavaPlatformByID(String id) {
        if (id == null || id.equals("default")) {
            return JavaPlatform.getDefault();
        }
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            if (!id.equals(ModuleProperties.getPlatformID(platforms[i]))) continue;
            return platforms[i];
        }
        return null;
    }

    static void storeJavaPlatform(AntProjectHelper helper, PropertyEvaluator eval, JavaPlatform platform, boolean isNetBeansOrg) throws IOException {
        if (isNetBeansOrg) {
            FileObject nbbuild;
            File home;
            final boolean isDefault = platform == null || platform == JavaPlatform.getDefault();
            File file = home = isDefault ? null : ModuleProperties.getPlatformLocation(platform);
            if ((home != null || isDefault) && (nbbuild = helper.resolveFileObject(eval.evaluate("${nb_all}/nbbuild"))) != null) {
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws IOException {
                            FileObject userBuildProperties = nbbuild.getFileObject("user.build.properties");
                            if (userBuildProperties == null) {
                                userBuildProperties = nbbuild.createData("user.build.properties");
                            }
                            EditableProperties ep = Util.loadProperties((FileObject)userBuildProperties);
                            if (isDefault) {
                                ep.remove((Object)"nbjdk.home");
                            } else {
                                ep.setProperty("nbjdk.home", home.getAbsolutePath());
                            }
                            Util.storeProperties((FileObject)userBuildProperties, (EditableProperties)ep);
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    throw (IOException)e.getException();
                }
            }
        } else {
            EditableProperties props = helper.getProperties("nbproject/platform.properties");
            if (platform == null || platform == JavaPlatform.getDefault()) {
                if (props.containsKey((Object)"nbjdk.active")) {
                    props.put("nbjdk.active", "default");
                }
            } else {
                props.put("nbjdk.active", ModuleProperties.getPlatformID(platform));
            }
            helper.putProperties("nbproject/platform.properties", props);
        }
    }

    private static File getPlatformLocation(JavaPlatform platform) {
        Collection installs = platform.getInstallFolders();
        if (installs.size() == 1) {
            return FileUtil.toFile((FileObject)((FileObject)installs.iterator().next()));
        }
        return null;
    }

    public static JavaPlatform findJavaPlatformByLocation(String home) {
        if (home == null) {
            return JavaPlatform.getDefault();
        }
        for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!new File(home).equals(ModuleProperties.getPlatformLocation(platform))) continue;
            return platform;
        }
        return null;
    }

    void addLazyStorage(LazyStorage st) {
        this.storages.add(st);
    }

    void triggerLazyStorages() {
        for (LazyStorage stor : this.storages) {
            stor.store();
        }
    }

    static interface LazyStorage {
        public void store();
    }
}

