/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.w3c.dom.Element;

public final class SingleModuleProperties
extends ModuleProperties {
    private static final String[] IDE_TOKENS = new String[]{"org.openide.modules.os.Windows", "org.openide.modules.os.Unix", "org.openide.modules.os.MacOSX", "org.openide.modules.os.PlainUnix", "org.openide.modules.os.OS2"};
    public static final String BUILD_COMPILER_DEBUG = "build.compiler.debug";
    public static final String BUILD_COMPILER_DEPRECATION = "build.compiler.deprecation";
    public static final String IS_AUTOLOAD = "is.autoload";
    public static final String IS_EAGER = "is.eager";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVADOC_TITLE = "javadoc.title";
    public static final String LICENSE_FILE = "license.file";
    public static final String NBM_HOMEPAGE = "nbm.homepage";
    public static final String NBM_MODULE_AUTHOR = "nbm.module.author";
    public static final String NBM_NEEDS_RESTART = "nbm.needs.restart";
    public static final String SPEC_VERSION_BASE = "spec.version.base";
    public static final String JAVAC_COMPILERARGS = "javac.compilerargs";
    static final String[] SOURCE_LEVELS = new String[]{"1.4", "1.5", "1.6", "1.7"};
    private static final Map<String, String> DEFAULTS;
    private static final Logger LOG;
    private boolean majorReleaseVersionChanged;
    private boolean specificationVersionChanged;
    private boolean implementationVersionChange;
    private boolean providedTokensChanged;
    private boolean autoUpdateShowInClientChanged;
    private NbModuleType moduleType;
    private SuiteProvider suiteProvider;
    private ProjectXMLManager projectXMLManager;
    private final LocalizedBundleInfo.Provider bundleInfoProvider;
    private LocalizedBundleInfo bundleInfo;
    private String majorReleaseVersion;
    private String specificationVersion;
    private String implementationVersion;
    private String provTokensString;
    private SortedSet<String> requiredTokens;
    private Boolean autoUpdateShowInClient;
    private NbPlatform activePlatform;
    private NbPlatform originalPlatform;
    private JavaPlatform activeJavaPlatform;
    private boolean javaPlatformChanged;
    private SortedSet<String> availablePublicPackages;
    private String[] allTokens;
    private SortedSet<String> modCategories;
    private Set<ModuleDependency> universeDependencies;
    private CustomizerComponentFactory.PublicPackagesTableModel publicPackagesModel;
    private CustomizerComponentFactory.DependencyListModel dependencyListModel;
    private CustomizerComponentFactory.FriendListModel friendListModel;
    private CustomizerComponentFactory.RequiredTokenListModel requiredTokensListModel;
    private DefaultListModel wrappedJarsListModel;
    private boolean wrappedJarsChanged;
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    public static final String JAVA_PLATFORM_PROPERTY = "nbjdk.active";
    public static final String DEPENDENCIES_PROPERTY = "moduleDependencies";
    private ReferenceHelper refHelper;
    private UpdateHelper updHelper;
    private ClassPathSupport cps;
    private final String CPEXT = "CPEXT";
    static final Logger UI_LOG;

    public static SingleModuleProperties getInstance(NbModuleProject project) {
        SuiteProvider sp = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        return new SingleModuleProperties(project.getHelper(), project.evaluator(), sp, project.getModuleType(), (LocalizedBundleInfo.Provider)project.getLookup().lookup(LocalizedBundleInfo.Provider.class));
    }

    SingleModuleProperties(AntProjectHelper helper, PropertyEvaluator evaluator, SuiteProvider sp, NbModuleType moduleType, LocalizedBundleInfo.Provider bundleInfoProvider) {
        super(helper, evaluator);
        this.bundleInfoProvider = bundleInfoProvider;
        this.refresh(moduleType, sp);
    }

    protected void refresh(NbModuleType moduleType, SuiteProvider suiteProvider) {
        String activeJdk;
        this.reloadProperties();
        this.suiteProvider = suiteProvider;
        this.moduleType = moduleType;
        this.universeDependencies = null;
        this.modCategories = null;
        this.availablePublicPackages = null;
        this.dependencyListModel = null;
        this.friendListModel = null;
        this.requiredTokensListModel = null;
        this.wrappedJarsListModel = null;
        this.wrappedJarsChanged = false;
        this.projectXMLManager = null;
        if (this.isSuiteComponent()) {
            if (this.getSuiteDirectory() != null) {
                ModuleList.refreshModuleListForRoot(this.getSuiteDirectory());
            }
        } else if (this.isStandalone()) {
            ModuleList.refreshModuleListForRoot(this.getProjectDirectoryFile());
        }
        ManifestManager manifestManager = ManifestManager.getInstance((File)this.getManifestFile(), (boolean)false);
        this.majorReleaseVersion = manifestManager.getReleaseVersion();
        this.specificationVersion = manifestManager.getSpecificationVersion();
        this.implementationVersion = manifestManager.getImplementationVersion();
        this.provTokensString = manifestManager.getProvidedTokensString();
        this.autoUpdateShowInClient = manifestManager.getAutoUpdateShowInClient();
        String nbDestDirS = this.getEvaluator().getProperty("netbeans.dest.dir");
        LOG.log(Level.FINE, "Setting NBPlatform for module. '" + this.getCodeNameBase() + "' in dir '" + nbDestDirS + "'");
        if (nbDestDirS != null) {
            NbPlatform def;
            String harnessDir = this.getEvaluator().getProperty("harness.dir");
            NbPlatform plaf = NbPlatform.getPlatformByDestDir(this.getHelper().resolveFile(nbDestDirS), harnessDir != null ? this.getHelper().resolveFile(harnessDir) : null);
            if (!plaf.isValid() && (def = NbPlatform.getDefaultPlatform()) != null) {
                LOG.log(Level.FINE, "Platform not found, switching to default ({0})", def.getDestDir());
                plaf = def;
            }
            this.originalPlatform = this.activePlatform = plaf;
        }
        if ((activeJdk = this.getEvaluator().getProperty(JAVA_PLATFORM_PROPERTY)) != null) {
            this.activeJavaPlatform = ModuleProperties.findJavaPlatformByID(activeJdk);
        } else {
            String activeJdkHome = this.getEvaluator().getProperty("nbjdk.home");
            this.activeJavaPlatform = ModuleProperties.findJavaPlatformByLocation(activeJdkHome);
        }
        this.javaPlatformChanged = false;
        this.getPublicPackagesModel().reloadData(this.loadPublicPackages());
        this.requiredTokens = Collections.unmodifiableSortedSet(new TreeSet<String>(Arrays.asList(manifestManager.getRequiredTokens())));
        this.bundleInfo = this.bundleInfoProvider.getLocalizedBundleInfo();
        if (this.bundleInfo != null) {
            try {
                this.bundleInfo.reload();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        this.firePropertiesRefreshed();
    }

    void resetUniverseDependencies() {
        this.universeDependencies = null;
    }

    @Override
    Map<String, String> getDefaultValues() {
        return DEFAULTS;
    }

    LocalizedBundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    String getCodeNameBase() {
        return this.getProjectXMLManager().getCodeNameBase();
    }

    String getJarFile() {
        return this.getHelper().resolveFile(this.getEvaluator().evaluate("${cluster}/${module.jar}")).getAbsolutePath();
    }

    @CheckForNull
    String getSuiteDirectoryPath() {
        File d = this.getSuiteDirectory();
        return d != null ? d.getPath() : null;
    }

    @CheckForNull
    File getSuiteDirectory() {
        return this.suiteProvider != null ? this.suiteProvider.getSuiteDirectory() : null;
    }

    @CheckForNull
    SuiteProject getSuite() {
        assert (this.isSuiteComponent());
        SuiteProject suite = null;
        try {
            FileObject suiteDir;
            File dir = this.getSuiteDirectory();
            if (dir != null && (suiteDir = FileUtil.toFileObject((File)dir)) != null) {
                suite = (SuiteProject)ProjectManager.getDefault().findProject(suiteDir);
            }
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        return suite;
    }

    boolean isActivePlatformValid() {
        NbPlatform plaf = this.getActivePlatform();
        return plaf == null || plaf.isValid();
    }

    NbPlatform getActivePlatform() {
        if (this.moduleType != NbModuleType.NETBEANS_ORG && this.activePlatform == null) {
            ModuleProperties.reportLostPlatform(this.activePlatform);
            this.activePlatform = NbPlatform.getDefaultPlatform();
        }
        return this.activePlatform;
    }

    void setActivePlatform(NbPlatform newPlaf) {
        if (this.activePlatform != newPlaf) {
            NbPlatform oldPlaf = this.activePlatform;
            this.activePlatform = newPlaf;
            this.dependencyListModel = null;
            this.universeDependencies = null;
            this.modCategories = null;
            this.firePropertyChange(NB_PLATFORM_PROPERTY, oldPlaf, newPlaf);
        }
    }

    JavaPlatform getActiveJavaPlatform() {
        return this.activeJavaPlatform;
    }

    void setActiveJavaPlatform(JavaPlatform nue) {
        JavaPlatform old = this.activeJavaPlatform;
        if (nue != old) {
            this.activeJavaPlatform = nue;
            this.firePropertyChange(JAVA_PLATFORM_PROPERTY, old, nue);
            this.javaPlatformChanged = true;
        }
    }

    String getMajorReleaseVersion() {
        return this.majorReleaseVersion;
    }

    void setMajorReleaseVersion(String ver) {
        if (!Utilities.compareObjects((Object)this.majorReleaseVersion, (Object)ver)) {
            this.majorReleaseVersion = ver;
            this.majorReleaseVersionChanged = true;
        }
    }

    String getSpecificationVersion() {
        return this.specificationVersion;
    }

    void setSpecificationVersion(String ver) {
        if (!Utilities.compareObjects((Object)this.specificationVersion, (Object)ver)) {
            this.specificationVersion = ver;
            this.specificationVersionChanged = true;
        }
    }

    String getImplementationVersion() {
        return this.implementationVersion;
    }

    void setImplementationVersion(String ver) {
        if (!Utilities.compareObjects((Object)this.implementationVersion, (Object)ver)) {
            this.implementationVersion = ver;
            this.implementationVersionChange = true;
        }
    }

    String getProvidedTokens() {
        return this.provTokensString;
    }

    void setProvidedTokens(String tokens) {
        if (!Utilities.compareObjects((Object)this.provTokensString, (Object)tokens)) {
            this.provTokensString = tokens;
            this.providedTokensChanged = true;
        }
    }

    public Boolean getAutoUpdateShowInClient() {
        return this.autoUpdateShowInClient;
    }

    public void setAutoUpdateShowInClient(Boolean autoUpdateShowInClient) {
        if (!Utilities.compareObjects((Object)this.autoUpdateShowInClient, (Object)autoUpdateShowInClient)) {
            this.autoUpdateShowInClient = autoUpdateShowInClient;
            this.autoUpdateShowInClientChanged = true;
        }
    }

    boolean isStandalone() {
        return this.moduleType == NbModuleType.STANDALONE;
    }

    boolean isNetBeansOrg() {
        return this.moduleType == NbModuleType.NETBEANS_ORG;
    }

    boolean isSuiteComponent() {
        return this.moduleType == NbModuleType.SUITE_COMPONENT;
    }

    boolean dependingOnImplDependency() {
        CustomizerComponentFactory.DependencyListModel depsModel = this.getDependenciesListModel();
        if (depsModel == CustomizerComponentFactory.INVALID_DEP_LIST_MODEL) {
            return false;
        }
        Set<ModuleDependency> deps = depsModel.getDependencies();
        for (ModuleDependency dep : deps) {
            if (!dep.hasImplementationDependency()) continue;
            return true;
        }
        return false;
    }

    private ProjectXMLManager getProjectXMLManager() {
        block3: {
            if (this.projectXMLManager == null) {
                try {
                    this.projectXMLManager = ProjectXMLManager.getInstance(this.getProjectDirectoryFile());
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return this.projectXMLManager;
    }

    ReferenceHelper getRefHelper() {
        if (this.refHelper == null) {
            Project p = this.getProject();
            AuxiliaryConfiguration aux = p != null ? ProjectUtils.getAuxiliaryConfiguration((Project)p) : new AuxiliaryConfiguration(){

                public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
                    return null;
                }

                public void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
                }

                public boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
                    return false;
                }
            };
            this.refHelper = new ReferenceHelper(this.getHelper(), aux, this.getEvaluator());
        }
        return this.refHelper;
    }

    UpdateHelper getUpdateHelper() {
        if (this.updHelper == null) {
            this.updHelper = new UpdateHelper(new UpdateImplementation(){

                public boolean isCurrent() {
                    return true;
                }

                public boolean canUpdate() {
                    assert (false) : "Should not get called";
                    return false;
                }

                public void saveUpdate(EditableProperties props) throws IOException {
                    assert (false) : "Should not get called";
                }

                public Element getUpdatedSharedConfigurationData() {
                    assert (false) : "Should not get called";
                    return null;
                }

                public EditableProperties getUpdatedProjectProperties() {
                    assert (false) : "Should not get called";
                    return null;
                }
            }, this.getHelper());
        }
        return this.updHelper;
    }

    CustomizerComponentFactory.DependencyListModel getDependenciesListModelInBg(final Runnable runAfterPopulated) {
        if (this.dependencyListModel == null) {
            if (this.isActivePlatformValid()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        Runnable r;
                        try {
                            final SortedSet<ModuleDependency> deps = SingleModuleProperties.this.getProjectXMLManager().getDirectDependencies(SingleModuleProperties.this.getActivePlatform());
                            r = new Runnable(){

                                @Override
                                public void run() {
                                    SingleModuleProperties.this.dependencyListModel.setDependencies(deps);
                                    if (runAfterPopulated != null) {
                                        runAfterPopulated.run();
                                    }
                                }
                            };
                        }
                        catch (IOException ioe) {
                            r = new Runnable(){

                                @Override
                                public void run() {
                                    SingleModuleProperties.this.dependencyListModel.setInvalid();
                                    if (runAfterPopulated != null) {
                                        runAfterPopulated.run();
                                    }
                                }
                            };
                        }
                        EventQueue.invokeLater(r);
                    }
                });
                this.dependencyListModel = CustomizerComponentFactory.DependencyListModel.createBgWaitModel(true);
                this.dependencyListModel.addListDataListener(new ListDataListener(){

                    @Override
                    public void contentsChanged(ListDataEvent e) {
                        SingleModuleProperties.this.firePropertyChange(SingleModuleProperties.DEPENDENCIES_PROPERTY, null, SingleModuleProperties.this.getDependenciesListModel());
                    }

                    @Override
                    public void intervalAdded(ListDataEvent e) {
                        this.contentsChanged(null);
                    }

                    @Override
                    public void intervalRemoved(ListDataEvent e) {
                        this.contentsChanged(null);
                    }
                });
            } else {
                this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
                if (runAfterPopulated != null) {
                    runAfterPopulated.run();
                }
            }
        } else if (runAfterPopulated != null) {
            runAfterPopulated.run();
        }
        return this.dependencyListModel;
    }

    CustomizerComponentFactory.DependencyListModel getDependenciesListModel() {
        if (this.dependencyListModel == null) {
            if (this.isActivePlatformValid()) {
                try {
                    this.dependencyListModel = new CustomizerComponentFactory.DependencyListModel(this.getProjectXMLManager().getDirectDependencies(this.getActivePlatform()), true);
                    this.dependencyListModel.addListDataListener(new ListDataListener(){

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            SingleModuleProperties.this.firePropertyChange(SingleModuleProperties.DEPENDENCIES_PROPERTY, null, SingleModuleProperties.this.getDependenciesListModel());
                        }

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                            this.contentsChanged(null);
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            this.contentsChanged(null);
                        }
                    });
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                    this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
                }
            } else {
                this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
            }
        }
        return this.dependencyListModel;
    }

    Set<ModuleDependency> getUniverseDependencies(boolean filterExcludedModules, boolean apiProvidersOnly) {
        assert (!SwingUtilities.isEventDispatchThread()) : "SingleModuleProperties.getUniverseDependencies() cannot be called from EDT";
        if (this.universeDependencies == null) {
            this.reloadModuleListInfo();
        }
        if (this.universeDependencies == null) {
            return Collections.emptySet();
        }
        HashSet<ModuleDependency> result = new HashSet<ModuleDependency>(this.universeDependencies);
        if (filterExcludedModules && this.isSuiteComponent()) {
            SuiteProject suite = this.getSuite();
            if (suite == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SingleModuleProperties.class, (String)"SingleModuleProperties.incorrectSuite", (Object)this.getSuiteDirectoryPath(), (Object)this.getProjectDisplayName()), 2));
                return Collections.emptySet();
            }
            String[] disabledModules = SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.modules");
            String[] enabledClusters = SuiteProperties.getArrayProperty(suite.getEvaluator(), "enabled.clusters");
            String[] disabledClusters = SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.clusters");
            String suiteClusterProp = this.getEvaluator().getProperty("cluster");
            File suiteClusterDir = suiteClusterProp != null ? this.getHelper().resolveFile(suiteClusterProp) : null;
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ModuleDependency dep = (ModuleDependency)it.next();
                ModuleEntry me = dep.getModuleEntry();
                if (me.getClusterDirectory().equals(suiteClusterDir) || !SingleModuleProperties.isExcluded(me, Arrays.asList(disabledModules), Arrays.asList(enabledClusters), Arrays.asList(disabledClusters))) continue;
                it.remove();
            }
        }
        if (apiProvidersOnly) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ModuleDependency dep = (ModuleDependency)it.next();
                ModuleEntry me = dep.getModuleEntry();
                if (me.getPublicPackages().length != 0 && me.isDeclaredAsFriend(this.getCodeNameBase())) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableSet(result);
    }

    Set<ModuleDependency> getUniverseDependencies(boolean filterExcludedModules) {
        return this.getUniverseDependencies(filterExcludedModules, false);
    }

    public static boolean isExcluded(ModuleEntry me, Collection<String> disabledModules, Collection<String> enabledClusters, Collection<String> disabledClusters) {
        if (disabledModules.contains(me.getCodeNameBase())) {
            return true;
        }
        String clusterName = me.getClusterDirectory().getName();
        if (!enabledClusters.isEmpty() && !SingleModuleProperties.clusterMatch(enabledClusters, clusterName)) {
            return true;
        }
        return enabledClusters.isEmpty() && disabledClusters.contains(clusterName);
    }

    static boolean clusterMatch(Collection<String> enabledClusters, String clusterName) {
        String baseName = SingleModuleProperties.clusterBaseName(clusterName);
        for (String c : enabledClusters) {
            if (!SingleModuleProperties.clusterBaseName(c).equals(baseName)) continue;
            return true;
        }
        return false;
    }

    static String clusterBaseName(String clusterName) {
        return clusterName.replaceFirst("[0-9.]+$", "");
    }

    String[] getAvailableFriends() {
        TreeSet<String> set;
        block3: {
            block2: {
                set = new TreeSet<String>();
                if (!this.isSuiteComponent()) break block2;
                for (Project project : SuiteUtils.getSubProjects(this.getSuite())) {
                    String cnb = ProjectUtils.getInformation((Project)project).getName();
                    if (this.getCodeNameBase().equals(cnb)) continue;
                    set.add(cnb);
                }
                break block3;
            }
            if (!this.isNetBeansOrg()) break block3;
            Set<ModuleDependency> deps = this.getUniverseDependencies(false);
            for (ModuleDependency dep : deps) {
                set.add(dep.getModuleEntry().getCodeNameBase());
            }
        }
        return set.toArray(new String[set.size()]);
    }

    CustomizerComponentFactory.FriendListModel getFriendListModel() {
        if (this.friendListModel == null) {
            this.friendListModel = new CustomizerComponentFactory.FriendListModel(this.getProjectXMLManager().getFriends());
        }
        return this.friendListModel;
    }

    CustomizerComponentFactory.RequiredTokenListModel getRequiredTokenListModel() {
        if (this.requiredTokensListModel == null) {
            this.requiredTokensListModel = new CustomizerComponentFactory.RequiredTokenListModel(this.requiredTokens);
        }
        return this.requiredTokensListModel;
    }

    private ClassPathSupport getClassPathSupport() {
        if (this.cps == null) {
            ClassPathSupport.Callback cback = new ClassPathSupport.Callback(){

                public void readAdditionalProperties(List<ClassPathSupport.Item> items, String projectXMLElement) {
                    if (SingleModuleProperties.this.wrappedJarsChanged && "CPEXT".equals(projectXMLElement)) {
                        for (ClassPathSupport.Item item : items) {
                            String ref = SingleModuleProperties.this.getRefHelper().createForeignFileReferenceAsIs(item.getFilePath(), null);
                            item.setReference(ref);
                            item.initSourceAndJavadoc(SingleModuleProperties.this.getHelper());
                        }
                    }
                }

                public void storeAdditionalProperties(List<ClassPathSupport.Item> items, String projectXMLElement) {
                    if (SingleModuleProperties.this.wrappedJarsChanged && "CPEXT".equals(projectXMLElement)) {
                        for (ClassPathSupport.Item item : items) {
                            if (item.getReference() == null) continue;
                            SingleModuleProperties.this.getRefHelper().destroyReference(item.getReference());
                        }
                    }
                }
            };
            this.cps = new ClassPathSupport(this.getEvaluator(), this.getRefHelper(), this.getHelper(), this.getUpdateHelper(), cback);
        }
        return this.cps;
    }

    private Iterator<ClassPathSupport.Item> getCPExtIterator() {
        String[] cpExt;
        StringBuilder sb = new StringBuilder();
        for (String s : cpExt = SuiteUtils.getAntProperty(Arrays.asList(this.getProjectXMLManager().getBinaryOrigins()))) {
            sb.append(s);
        }
        return this.getClassPathSupport().itemsIterator(sb.toString(), "CPEXT");
    }

    DefaultListModel getWrappedJarsListModel() {
        if (this.wrappedJarsListModel == null) {
            this.wrappedJarsListModel = ClassPathUiSupport.createListModel(this.getCPExtIterator());
            this.wrappedJarsListModel.addListDataListener(new ListDataListener(){

                private void process(ListDataEvent e) {
                    SingleModuleProperties.this.wrappedJarsChanged = true;
                    SingleModuleProperties.this.availablePublicPackages = null;
                    if (SingleModuleProperties.this.publicPackagesModel != null) {
                        SingleModuleProperties.this.publicPackagesModel.reloadData(SingleModuleProperties.this.loadPublicPackages(SingleModuleProperties.this.publicPackagesModel.getSelectedPackages()));
                    }
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.process(e);
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.process(e);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.process(e);
                }
            });
        }
        return this.wrappedJarsListModel;
    }

    String[] getAllTokens() {
        if (this.allTokens == null) {
            try {
                TreeSet<String> provTokens = new TreeSet<String>();
                provTokens.addAll(Arrays.asList(IDE_TOKENS));
                for (ModuleEntry me : this.getModuleList().getAllEntries()) {
                    provTokens.addAll(Arrays.asList(me.getProvidedTokens()));
                }
                String[] result = new String[provTokens.size()];
                return provTokens.toArray(result);
            }
            catch (IOException e) {
                this.allTokens = new String[0];
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return this.allTokens;
    }

    CustomizerComponentFactory.PublicPackagesTableModel getPublicPackagesModel() {
        if (this.publicPackagesModel == null) {
            this.publicPackagesModel = new CustomizerComponentFactory.PublicPackagesTableModel(this.loadPublicPackages());
        }
        return this.publicPackagesModel;
    }

    private Map<String, Boolean> loadPublicPackages() {
        return this.loadPublicPackages(this.getSelectedPackages());
    }

    private Map<String, Boolean> loadPublicPackages(Collection<String> selectedPackages) {
        TreeMap<String, Boolean> publicPackages = new TreeMap<String, Boolean>();
        for (String pkg : this.getAvailablePublicPackages()) {
            publicPackages.put(pkg, selectedPackages.contains(pkg));
        }
        return publicPackages;
    }

    private Collection<String> getSelectedPackages() {
        HashSet<String> sPackages = new HashSet<String>();
        ManifestManager.PackageExport[] pexports = this.getProjectXMLManager().getPublicPackages();
        for (int i = 0; i < pexports.length; ++i) {
            ManifestManager.PackageExport pexport = pexports[i];
            if (pexport.isRecursive()) {
                for (String p : this.getAvailablePublicPackages()) {
                    if (!p.startsWith(pexport.getPackage())) continue;
                    sPackages.add(p);
                }
                continue;
            }
            sPackages.add(pexport.getPackage());
        }
        return sPackages;
    }

    Set<String> getAvailablePublicPackages() {
        if (this.availablePublicPackages == null) {
            this.availablePublicPackages = ApisupportAntUtils.scanProjectForPackageNames(this.getProjectDirectoryFile(), false);
            Iterator it = ClassPathUiSupport.getIterator((DefaultListModel)this.getWrappedJarsListModel());
            while (it.hasNext()) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)it.next();
                ApisupportAntUtils.scanJarForPackageNames(this.availablePublicPackages, item.getResolvedFile());
            }
        }
        return this.availablePublicPackages;
    }

    @Override
    void storeProperties() throws IOException {
        super.storeProperties();
        this.storeManifestChanges();
        if (this.bundleInfo != null && this.bundleInfo.isModified()) {
            this.bundleInfo.store();
        }
        ProjectXMLManager pxm = this.getProjectXMLManager();
        CustomizerComponentFactory.DependencyListModel dependencyModel = this.getDependenciesListModel();
        if (dependencyModel.isChanged()) {
            TreeSet<ModuleDependency> depsToSave = new TreeSet<ModuleDependency>(dependencyModel.getDependencies());
            SingleModuleProperties.logNetBeansAPIUsage("DEPENDENCIES", dependencyModel.getDependencies());
            try {
                pxm.replaceDependencies(depsToSave);
            }
            catch (ProjectXMLManager.CyclicDependencyException ex) {
                throw new IOException(ex);
            }
        }
        Set<String> friends = this.getFriendListModel().getFriends();
        Set<String> publicPkgs = this.getPublicPackagesModel().getSelectedPackages();
        boolean refreshModuleList = false;
        if (this.getPublicPackagesModel().isChanged() || this.getFriendListModel().isChanged()) {
            if (friends.size() > 0) {
                pxm.replaceFriends(friends, publicPkgs);
            } else {
                pxm.replacePublicPackages(publicPkgs);
            }
            refreshModuleList = true;
        }
        if (this.cps != null && this.wrappedJarsListModel != null && this.wrappedJarsChanged) {
            List cpExtList = ClassPathUiSupport.getList((DefaultListModel)this.wrappedJarsListModel);
            HashMap<String, String> newCpExt = new HashMap<String, String>();
            for (ClassPathSupport.Item item : cpExtList) {
                String binPath = item.getFilePath();
                if (binPath == null) continue;
                FileObject fo = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)this.getProjectDirectoryFile(), (String)binPath));
                String runtimePath = "ext/" + fo.getNameExt();
                newCpExt.put(runtimePath, binPath);
            }
            Iterator<ClassPathSupport.Item> it = this.getCPExtIterator();
            HashSet jarsSet = new HashSet(newCpExt.values());
            while (it.hasNext()) {
                ClassPathSupport.Item item = it.next();
                if (jarsSet.contains(item.getFilePath())) continue;
                assert (item.getReference() != null) : "getCPExtIterator() initializes references to wrapped JARs";
                item.removeSourceAndJavadoc(this.getUpdateHelper());
                this.getRefHelper().destroyReference(item.getReference());
            }
            this.cps.encodeToStrings(cpExtList, "CPEXT");
            pxm.replaceClassPathExtensions(newCpExt);
            this.wrappedJarsChanged = false;
        }
        if (this.isStandalone()) {
            ModuleProperties.storePlatform(this.getHelper(), this.getActivePlatform());
            if (this.javaPlatformChanged) {
                ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), false);
            }
            if (refreshModuleList) {
                ModuleList.refreshModuleListForRoot(this.getProjectDirectoryFile());
            }
        } else if (this.isSuiteComponent() && refreshModuleList) {
            ModuleList.refreshModuleListForRoot(this.getSuiteDirectory());
        } else if (this.isNetBeansOrg()) {
            if (this.javaPlatformChanged) {
                ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), true);
            }
            if (refreshModuleList) {
                ModuleList.refreshModuleListForRoot(ModuleList.findNetBeansOrg(this.getProjectDirectoryFile()));
            }
        }
    }

    private static void logNetBeansAPIUsage(String msg, Collection<ModuleDependency> deps) {
        ArrayList<String> cnbs = new ArrayList<String>();
        for (ModuleDependency moduleDependency : deps) {
            String cnb = moduleDependency.getModuleEntry().getCodeNameBase();
            if (!cnb.startsWith("org.openide") && !cnb.startsWith("org.netbeans")) continue;
            cnbs.add(cnb);
        }
        if (cnbs.isEmpty()) {
            return;
        }
        LogRecord rec = new LogRecord(Level.CONFIG, msg);
        rec.setParameters(cnbs.toArray(new String[0]));
        rec.setResourceBundleName(SingleModuleProperties.class.getPackage().getName() + ".Bundle");
        rec.setResourceBundle(NbBundle.getBundle(SingleModuleProperties.class));
        rec.setLoggerName(UI_LOG.getName());
        UI_LOG.log(rec);
    }

    private void storeManifestChanges() throws IOException {
        EditableManifest em;
        FileObject manifestFO = FileUtil.toFileObject((File)this.getManifestFile());
        if (manifestFO != null) {
            em = Util.loadManifest((FileObject)manifestFO);
        } else {
            em = new EditableManifest();
            manifestFO = FileUtil.createData((FileObject)this.getHelper().getProjectDirectory(), (String)"manifest.mf");
        }
        boolean changed = false;
        if (this.majorReleaseVersionChanged) {
            String module = "".equals(this.getMajorReleaseVersion()) ? this.getCodeNameBase() : this.getCodeNameBase() + '/' + this.getMajorReleaseVersion();
            this.setManifestAttribute(em, "OpenIDE-Module", module);
            changed = true;
        }
        if (this.specificationVersionChanged) {
            this.setManifestAttribute(em, "OpenIDE-Module-Specification-Version", this.getSpecificationVersion());
            changed = true;
        }
        if (this.implementationVersionChange) {
            this.setManifestAttribute(em, "OpenIDE-Module-Implementation-Version", this.getImplementationVersion());
            changed = true;
        }
        if (this.providedTokensChanged) {
            this.setManifestAttribute(em, "OpenIDE-Module-Provides", this.getProvidedTokens());
            changed = true;
        }
        if (this.getRequiredTokenListModel().isChanged()) {
            String[] reqTokens = this.getRequiredTokenListModel().getTokens();
            StringBuilder result = new StringBuilder(reqTokens.length > 1 ? "\n  " : "");
            for (int i = 0; i < reqTokens.length; ++i) {
                if (i != 0) {
                    result.append(",\n  ");
                }
                result.append(reqTokens[i]);
            }
            this.setManifestAttribute(em, "OpenIDE-Module-Requires", result.toString());
            changed = true;
        }
        if (this.autoUpdateShowInClientChanged) {
            this.setManifestAttribute(em, "AutoUpdate-Show-In-Client", this.autoUpdateShowInClient != null ? this.autoUpdateShowInClient.toString() : "");
            changed = true;
        }
        if (changed) {
            Util.storeManifest((FileObject)manifestFO, (EditableManifest)em);
        }
    }

    private void setManifestAttribute(EditableManifest em, String key, String value) {
        boolean isOSGi;
        boolean bl = isOSGi = em.getAttribute("Bundle-SymbolicName", null) != null;
        if (isOSGi) {
            if ("OpenIDE-Module".equals(key)) {
                key = "Bundle-SymbolicName";
            }
            if ("OpenIDE-Module-Specification-Version".equals(key)) {
                key = "Bundle-Version";
            }
        }
        assert (value != null);
        if ("".equals(value)) {
            if (em.getAttribute(key, null) != null) {
                em.removeAttribute(key, null);
            }
        } else {
            em.setAttribute(key, value, null);
        }
    }

    File getManifestFile() {
        return this.getHelper().resolveFile(this.getEvaluator().getProperty("manifest.mf"));
    }

    SortedSet<String> getModuleCategories() {
        assert (!SwingUtilities.isEventDispatchThread()) : "SingleModuleProperties.getModuleCategories() cannot be called from EDT";
        if (this.modCategories == null && !this.reloadModuleListInfo()) {
            return new TreeSet<String>();
        }
        return this.modCategories;
    }

    boolean reloadModuleListInfo() {
        assert (!SwingUtilities.isEventDispatchThread()) : "SingleModuleProperties.reloadModuleListInfo() cannot be called from EDT";
        if (this.isActivePlatformValid()) {
            try {
                TreeSet<Object> allCategories = new TreeSet<Object>(Collator.getInstance());
                HashSet<ModuleDependency> allDependencies = new HashSet<ModuleDependency>();
                for (ModuleEntry me : this.getModuleList().getAllEntries()) {
                    String cat;
                    if (!me.getCodeNameBase().equals(this.getCodeNameBase())) {
                        allDependencies.add(new ModuleDependency(me));
                    }
                    if ((cat = me.getCategory()) == null) continue;
                    allCategories.add(cat);
                }
                this.modCategories = Collections.unmodifiableSortedSet(allCategories);
                this.universeDependencies = Collections.unmodifiableSet(allDependencies);
                return true;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return false;
    }

    ModuleList getModuleList() throws IOException {
        if (this.getActivePlatform() != this.originalPlatform) {
            try {
                return ModuleList.getModuleList(this.getProjectDirectoryFile(), this.getActivePlatform().getDestDir());
            }
            catch (IOException x) {
                LOG.log(Level.FINE, null, x);
                NbPlatform p = NbPlatform.getDefaultPlatform();
                return ModuleList.getModuleList(this.getProjectDirectoryFile(), p != null ? p.getDestDir() : null);
            }
        }
        return ModuleList.getModuleList(this.getProjectDirectoryFile());
    }

    File evaluateFile(String currentLicence) {
        String evaluated = this.getEvaluator().evaluate(currentLicence);
        return evaluated == null ? null : this.getHelper().resolveFile(evaluated);
    }

    @CheckForNull
    Project getProject() {
        try {
            return ProjectManager.getDefault().findProject(this.getHelper().getProjectDirectory());
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
            return null;
        }
    }

    int exportPackagesFromJars(List<File> jars) {
        CustomizerComponentFactory.PublicPackagesTableModel model = this.getPublicPackagesModel();
        HashSet<String> pkgs = new HashSet<String>(model.getSelectedPackages());
        int origC = pkgs.size();
        for (File jar : jars) {
            ApisupportAntUtils.scanJarForPackageNames(pkgs, jar);
        }
        model.reloadData(this.loadPublicPackages(pkgs));
        return pkgs.size() - origC;
    }

    static {
        LOG = Logger.getLogger(SingleModuleProperties.class.getName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(BUILD_COMPILER_DEBUG, "true");
        map.put(BUILD_COMPILER_DEPRECATION, "true");
        map.put(IS_AUTOLOAD, "false");
        map.put(IS_EAGER, "false");
        map.put(JAVAC_SOURCE, "1.4");
        map.put(NBM_NEEDS_RESTART, "false");
        DEFAULTS = Collections.unmodifiableMap(map);
        UI_LOG = Logger.getLogger("org.netbeans.ui.apisupport");
    }
}

