/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.ui.wizard.NewTemplateVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.TypeChooserPanelImpl;
import org.netbeans.modules.apisupport.project.ui.wizard.spi.ModuleTypePanel;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class BasicInfoVisualPanel
extends NewTemplateVisualPanel
implements PropertyChangeListener {
    private boolean locationUpdated;
    private boolean nameUpdated;
    private boolean mainProjectTouched;
    private static int validityCounter = 0;
    private int validityId = ++validityCounter;
    private boolean internalUpdate = false;
    private JButton browseButton;
    private JLabel filler;
    private JLabel folderLbl;
    private JTextField folderValue;
    private JPanel infoPanel;
    private JLabel locationLbl;
    private JTextField locationValue;
    private JCheckBox mainProject;
    private JButton manageSuitePlatform;
    private ButtonGroup moduleTypeGroup;
    private JLabel nameLbl;
    JTextField nameValue;
    private JPanel pnlThouShaltBeholdLayout;
    private JSeparator separator3;
    private JLabel suitePlatform;
    private JComboBox suitePlatformValue;
    private JPanel typeChooserPanelContainer;
    private TypeChooserPanelImpl typeChooserPanel;

    BasicInfoVisualPanel(NewModuleProjectData data) {
        super(data);
        this.initComponents();
        BasicInfoVisualPanel.initPlatformCombo(this.suitePlatformValue);
        this.initPanels();
        this.setComponentsVisibility();
        this.mainProject.setSelected(!this.isLibraryWizard() && ModuleUISettings.getDefault().getSetAsMain());
        switch (data.getWizardType()) {
            case SUITE: 
            case APPLICATION: 
            case LIBRARY_MODULE: {
                break;
            }
            case MODULE: 
            case SUITE_COMPONENT: {
                if (TypeChooserPanelImpl.getDefaultSuitesComboBox().getItemCount() <= 0) break;
                this.mainProject.setSelected(false);
                break;
            }
            default: {
                assert (false) : "Unknown wizard type = " + (Object)((Object)data.getWizardType());
                break;
            }
        }
        this.attachDocumentListeners();
        this.setInitialLocation();
        this.setInitialProjectName();
        this.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
    }

    protected static boolean isNetBeansOrgFolder(File folder) {
        return ModuleList.findNetBeansOrg(folder) != null;
    }

    protected static void initPlatformCombo(JComboBox combo) {
        if (combo == null) {
            return;
        }
        if (combo.getItemCount() <= 0) {
            return;
        }
        boolean set = false;
        String idToSelect = ModuleUISettings.getDefault().getLastUsedPlatformID();
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!((NbPlatform)combo.getItemAt(i)).getID().equals(idToSelect)) continue;
            combo.setSelectedIndex(i);
            set = true;
            break;
        }
        if (!set) {
            NbPlatform defPlaf = NbPlatform.getDefaultPlatform();
            combo.setSelectedItem(defPlaf == null ? combo.getItemAt(0) : defPlaf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (ModuleTypePanel.isPanelUpdated(evt) && !this.internalUpdate && validityCounter == this.validityId) {
            try {
                this.internalUpdate = true;
                boolean isStandAlone = ModuleTypePanel.isStandalone(this.getSettings());
                boolean isSuiteComponent = ModuleTypePanel.isSuiteComponent(this.getSettings());
                if (!isStandAlone && !isSuiteComponent) {
                    return;
                }
                if (!this.mainProjectTouched) {
                    this.mainProject.setSelected(isStandAlone);
                }
                if (!this.locationUpdated) {
                    this.setInitialLocation();
                }
                if (!this.nameUpdated) {
                    this.setInitialProjectName();
                }
            }
            finally {
                this.internalUpdate = false;
            }
            this.updateAndCheck();
        }
    }

    private void setInitialLocation() {
        if (ModuleTypePanel.isSuiteComponent(this.getSettings())) {
            this.computeAndSetLocation(ModuleTypePanel.getSuiteRoot(this.getSettings()), true);
        } else {
            String location = this.computeLocationValue(ProjectChooser.getProjectsFolder().getAbsolutePath());
            File locationF = new File(location);
            if (SuiteUtils.isSuite(locationF)) {
                this.computeAndSetLocation(locationF.getParent(), true);
            } else {
                this.setLocation(location, true);
            }
        }
    }

    private void initPanels() {
        if (this.typeChooserPanel != null) {
            this.typeChooserPanelContainer.remove(this.typeChooserPanel);
            this.typeChooserPanel = null;
        }
        this.typeChooserPanel = new TypeChooserPanelImpl(this.getSettings(), this.getData().getWizardType());
        this.typeChooserPanelContainer.add(this.typeChooserPanel);
        this.typeChooserPanelContainer.validate();
        this.validate();
    }

    private void setComponentsVisibility() {
        boolean isSuiteWizard = this.isSuiteWizard();
        boolean isSuiteComponentWizard = this.isSuiteComponentWizard();
        boolean isLibraryWizard = this.isLibraryWizard();
        this.typeChooserPanel.setVisible(!isSuiteWizard);
        this.suitePlatform.setVisible(isSuiteWizard);
        this.suitePlatformValue.setVisible(isSuiteWizard);
        this.manageSuitePlatform.setVisible(isSuiteWizard);
        this.mainProject.setVisible(!isLibraryWizard);
        if (this.typeChooserPanel != null) {
            this.typeChooserPanel.setComponentsVisibility(isSuiteComponentWizard, isLibraryWizard);
        }
    }

    private String getNameValue() {
        return this.nameValue.getText().trim();
    }

    private String getLocationValue() {
        return this.locationValue.getText().trim();
    }

    private File getLocationFile() {
        return new File(this.getLocationValue());
    }

    void updateAndCheck() {
        this.updateGUI();
        if ("".equals(this.getNameValue())) {
            this.setInfo(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_NameCannotBeEmpty"), false);
        } else if ("".equals(this.getLocationValue())) {
            this.setInfo(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_LocationCannotBeEmpty"), false);
        } else if (this.isLibraryWizard() && this.isNetBeansOrgFolder()) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_LibraryWrapperForNBOrgUnsupported"));
        } else if (!ModuleTypePanel.validate(this.getSettings())) {
            this.setError((String)this.getSettings().getProperty("WizardPanel_errorMessage"));
        } else if (this.isSuiteWizard() && (this.suitePlatformValue.getSelectedItem() == null || !((NbPlatform)this.suitePlatformValue.getSelectedItem()).isValid())) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_ChosenPlatformIsInvalid"));
        } else if (this.getFolder().exists()) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_ProjectFolderExists"));
        } else if (!this.getLocationFile().exists()) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_LocationMustExist"));
        } else if (!this.getLocationFile().canWrite()) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_LocationNotWritable"));
        } else {
            this.markValid();
        }
    }

    private void updateGUI() {
        if (this.internalUpdate) {
            return;
        }
        this.folderValue.setText(this.getFolder().getPath());
        Logger.getLogger(BasicInfoVisualPanel.class.getName()).log(Level.FINE, "(" + this.validityId + ") Setting project folder to '" + this.getFolder().getPath() + "'");
        ModuleTypePanel.setProjectFolder(this.getSettings(), this.getFolder());
    }

    private void setProjectName(String formater, int counter) {
        String name;
        while ((name = this.validFreeModuleName(formater, counter)) == null) {
            ++counter;
        }
        this.nameValue.setText(name);
    }

    private String validFreeModuleName(String formater, int index) {
        String name = MessageFormat.format(formater, new Integer(index));
        File file = new File(this.getLocationValue(), name);
        return file.exists() ? null : name;
    }

    void storeData() {
        this.getData().setProjectName(this.getNameValue());
        this.getData().setProjectLocation(this.getLocationValue());
        this.getData().setProjectFolder(this.folderValue.getText());
        this.getData().setMainProject(this.mainProject.isSelected());
        ModuleUISettings.getDefault().setSetAsMain(this.mainProject.isSelected());
        this.getData().setNetBeansOrg(this.isNetBeansOrgFolder());
        this.getData().setStandalone(ModuleTypePanel.isStandalone(this.getSettings()));
        this.getData().setSuiteRoot(ModuleTypePanel.getSuiteRoot(this.getSettings()));
        if (this.isSuiteWizard() && this.suitePlatformValue.getSelectedItem() != null) {
            this.getData().setPlatformID(((NbPlatform)this.suitePlatformValue.getSelectedItem()).getID());
        } else if (ModuleTypePanel.getActivePlatformId(this.getSettings()) != null) {
            this.getData().setPlatformID(ModuleTypePanel.getActivePlatformId(this.getSettings()));
        }
    }

    void refreshData() {
        if (this.getData().getProjectName() != null) {
            this.nameValue.setText(this.getData().getProjectName());
        } else {
            this.setInitialProjectName();
        }
    }

    private void setInitialProjectName() {
        String bundlekey = null;
        int counter = 0;
        switch (this.getData().getWizardType()) {
            case SUITE: 
            case APPLICATION: {
                counter = ModuleUISettings.getDefault().getNewSuiteCounter() + 1;
                bundlekey = "TXT_Suite";
                this.getData().setSuiteCounter(counter);
                break;
            }
            case MODULE: 
            case SUITE_COMPONENT: {
                counter = ModuleUISettings.getDefault().getNewModuleCounter() + 1;
                bundlekey = "TXT_Module";
                this.getData().setModuleCounter(counter);
                break;
            }
            case LIBRARY_MODULE: {
                counter = ModuleUISettings.getDefault().getNewModuleCounter() + 1;
                bundlekey = "TXT_Library";
                this.getData().setModuleCounter(counter);
                break;
            }
            default: {
                assert (false) : "Unknown wizard type = " + (Object)((Object)this.getData().getWizardType());
                break;
            }
        }
        this.setProjectName(NbBundle.getMessage(BasicInfoVisualPanel.class, bundlekey), counter);
        this.nameValue.select(0, this.nameValue.getText().length());
        this.nameUpdated = false;
    }

    private void attachDocumentListeners() {
        UIUtil.DocumentAdapter fieldsDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                BasicInfoVisualPanel.this.updateAndCheck();
            }
        };
        this.nameValue.getDocument().addDocumentListener((DocumentListener)fieldsDL);
        this.nameValue.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                BasicInfoVisualPanel.this.nameUpdated = true;
            }
        });
        this.locationValue.getDocument().addDocumentListener((DocumentListener)fieldsDL);
        this.locationValue.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                BasicInfoVisualPanel.this.locationUpdated = true;
            }
        });
        ActionListener plafAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicInfoVisualPanel.this.updateAndCheck();
            }
        };
        this.suitePlatformValue.addActionListener(plafAL);
        this.getSettings().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.getSettings()));
    }

    private File getFolder() {
        StringBuilder destFolder = new StringBuilder(this.getLocationValue());
        if (destFolder.length() != 0) {
            destFolder.append(File.separator);
        }
        destFolder.append(this.getNameValue());
        return FileUtil.normalizeFile((File)new File(destFolder.toString()));
    }

    private boolean isNetBeansOrgFolder() {
        return BasicInfoVisualPanel.isNetBeansOrgFolder(this.getFolder());
    }

    private void setLocation(String location, boolean silently) {
        boolean revert = silently && !this.locationUpdated;
        this.locationValue.setText(location);
        this.locationUpdated = revert ^ true;
    }

    private void computeAndSetLocation(String value, boolean silently) {
        this.setLocation(this.computeLocationValue(value), silently);
    }

    private String computeLocationValue(String value) {
        File file;
        if (value == null) {
            value = System.getProperty("user.home");
        }
        if (!(file = new File(value)).exists() && file.getParent() != null) {
            return this.computeLocationValue(file.getParent());
        }
        return file.exists() ? value : System.getProperty("user.home");
    }

    private void initComponents() {
        this.moduleTypeGroup = new ButtonGroup();
        this.infoPanel = new JPanel();
        this.nameLbl = new JLabel();
        this.locationLbl = new JLabel();
        this.folderLbl = new JLabel();
        this.nameValue = new JTextField();
        this.locationValue = new JTextField();
        this.browseButton = new JButton();
        this.filler = new JLabel();
        this.folderValue = new JTextField();
        this.suitePlatform = new JLabel();
        this.suitePlatformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.manageSuitePlatform = new JButton();
        this.separator3 = new JSeparator();
        this.mainProject = new JCheckBox();
        this.pnlThouShaltBeholdLayout = new JPanel();
        this.typeChooserPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.infoPanel.setLayout(new GridBagLayout());
        this.nameLbl.setLabelFor(this.nameValue);
        Mnemonics.setLocalizedText((JLabel)this.nameLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.nameLbl, gridBagConstraints);
        this.locationLbl.setLabelFor(this.locationValue);
        Mnemonics.setLocalizedText((JLabel)this.locationLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.locationLbl, gridBagConstraints);
        this.folderLbl.setLabelFor(this.folderValue);
        Mnemonics.setLocalizedText((JLabel)this.folderLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.folderLbl, gridBagConstraints);
        this.nameValue.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)this.nameValue, gridBagConstraints);
        this.nameValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_NameValue"));
        this.nameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_NameValue"));
        this.locationValue.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.locationValue, gridBagConstraints);
        this.locationValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_LocationValue"));
        this.locationValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_LocationValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_BrowseButton_o"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.browseLocation(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_BrowseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_BrowseButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        this.infoPanel.add((Component)this.filler, gridBagConstraints);
        this.folderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.infoPanel.add((Component)this.folderValue, gridBagConstraints);
        this.folderValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_FolderValue"));
        this.folderValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_FolderValue"));
        this.suitePlatform.setLabelFor(this.suitePlatformValue);
        Mnemonics.setLocalizedText((JLabel)this.suitePlatform, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.suitePlatform, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.suitePlatformValue, gridBagConstraints);
        this.suitePlatformValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_SuitePlatformValue"));
        this.suitePlatformValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_SuitePlatformValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageSuitePlatform, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_ManagePlatforms_g"));
        this.manageSuitePlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.manageSuitePlatformActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.manageSuitePlatform, gridBagConstraints);
        this.manageSuitePlatform.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_ManageSuitePlatform"));
        this.manageSuitePlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_ManageSuitePlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.infoPanel.add((Component)this.separator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.infoPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProject, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_SetAsMainProject"));
        this.mainProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicInfoVisualPanel.this.mainProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add(this.mainProject, gridBagConstraints);
        this.mainProject.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_MainProject"));
        this.mainProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_MainProject"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.pnlThouShaltBeholdLayout, gridBagConstraints);
        this.typeChooserPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.typeChooserPanelContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_BasicInfoVisualPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_BasicInfoVisualPanel"));
    }

    private void manageSuitePlatformActionPerformed(ActionEvent evt) {
        this.managePlatform(this.suitePlatformValue);
    }

    private void mainProjectActionPerformed(ActionEvent evt) {
        this.mainProjectTouched = true;
    }

    private void managePlatform(JComboBox platformCombo) {
        NbPlatformCustomizer.showCustomizer();
        platformCombo.setModel(new PlatformComponentFactory.NbPlatformListModel());
        platformCombo.requestFocus();
        this.updateAndCheck();
    }

    private void browseLocation(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.getLocationValue());
        chooser.setFileSelectionMode(1);
        int ret = chooser.showOpenDialog((Component)((Object)this));
        if (ret == 0) {
            this.computeAndSetLocation(chooser.getSelectedFile().getAbsolutePath(), false);
        }
    }
}

