/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.ui.wizard.NewTemplateVisualPanel;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class LibraryStartVisualPanel
extends NewTemplateVisualPanel {
    static final String PROP_LIBRARY_PATH = "LIBRARY_PATH_VALUE";
    static final String PROP_LICENSE_PATH = "LICENSE_PATH_VALUE";
    private boolean listenersAttached;
    private final DocumentListener libraryDL;
    private final DocumentListener licenseDL;
    private JButton browseLibraryButton;
    private JButton browseLicenceButton;
    private JPanel confPanel;
    private JPanel filler;
    private JLabel lblLibrary;
    private JLabel lblLicense;
    private JTextField txtLibrary;
    private JTextField txtLicense;

    public LibraryStartVisualPanel(NewModuleProjectData data) {
        super(data);
        this.initComponents();
        this.initAccessibility();
        this.libraryDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                LibraryStartVisualPanel.this.checkLibraryAndLicense();
            }
        };
        this.licenseDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                LibraryStartVisualPanel.this.checkLibraryAndLicense();
            }
        };
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_LibraryStartVisualPanel"));
        this.browseLibraryButton.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_BrowseLibraries"));
        this.browseLicenceButton.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_BrowseLicense"));
        this.txtLibrary.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_Library"));
        this.txtLicense.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_License"));
    }

    private void checkLibraryAndLicense() {
        File fil;
        String text = this.txtLibrary.getText().trim();
        if (text.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(text, File.pathSeparator);
            while (tokens.hasMoreTokens()) {
                String one = tokens.nextToken();
                File fil2 = new File(one);
                if (!fil2.exists()) {
                    this.setError(LibraryStartVisualPanel.getMessage("MSG_Invalid_Library_Path"));
                    return;
                }
                try {
                    new JarFile(fil2);
                }
                catch (IOException exc) {
                    this.setError(LibraryStartVisualPanel.getMessage("MSG_Invalid_Library_Path"));
                    return;
                }
                String badOnes = LibraryStartVisualPanel.populateProjectData(this.getData(), text, false);
                if (badOnes == null) continue;
                this.setWarning(NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"MSG_ClassInDefaultPackage", (Object)badOnes));
                return;
            }
        } else {
            this.setWarning(LibraryStartVisualPanel.getMessage("MSG_Library_Path_Not_Defined"), false);
            return;
        }
        text = this.txtLicense.getText().trim();
        if (text.length() > 0 && !(fil = new File(text)).exists()) {
            this.setError(LibraryStartVisualPanel.getMessage("MSG_Invalid_License_Path"));
            return;
        }
        this.markValid();
    }

    void refreshData() {
    }

    void storeData() {
        String jars = this.txtLibrary.getText().trim();
        this.getSettings().putProperty(PROP_LIBRARY_PATH, (Object)jars);
        this.getSettings().putProperty(PROP_LICENSE_PATH, (Object)this.txtLicense.getText().trim());
        LibraryStartVisualPanel.populateProjectData(this.getData(), jars, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String populateProjectData(NewModuleProjectData data, String paths, boolean assignValues) {
        if (data.getProjectName() != null && data.getCodeNameBase() != null && assignValues) {
            return null;
        }
        String wrongOnes = null;
        StringTokenizer tokens = new StringTokenizer(paths, File.pathSeparator);
        boolean cutShortestPath = false;
        boolean fileAlreadyMarked = false;
        if (tokens.hasMoreTokens()) {
            fileAlreadyMarked = false;
            File fil = new File(tokens.nextToken());
            if (!fil.exists()) {
                return wrongOnes;
            }
            String name = fil.getName();
            int inddd = name.lastIndexOf(46);
            if (inddd > -1) {
                name = name.substring(0, inddd);
            }
            name = name.replaceAll("[0-9._-]+$", "");
            if (assignValues) {
                data.setProjectName(name);
            }
            JarFile jf = null;
            String shortestPath = null;
            try {
                jf = new JarFile(fil);
                Enumeration<JarEntry> en = jf.entries();
                while (en.hasMoreElements()) {
                    String nm;
                    JarEntry entry = en.nextElement();
                    if (entry.isDirectory() || !entry.getName().endsWith(".class") || !ApisupportAntUtils.isValidJavaFQN((nm = entry.getName()).substring(0, nm.length() - 6).replace('/', '.'))) continue;
                    int index = nm.lastIndexOf(47);
                    if (index > -1) {
                        String path = nm.substring(0, index);
                        if (shortestPath != null && path.length() == shortestPath.length() && !path.equals(shortestPath)) {
                            cutShortestPath = true;
                        }
                        if (shortestPath != null && path.length() >= shortestPath.length()) continue;
                        shortestPath = path;
                        cutShortestPath = false;
                        continue;
                    }
                    if (fileAlreadyMarked) continue;
                    wrongOnes = wrongOnes == null ? fil.getName() : wrongOnes + "," + fil.getName();
                    fileAlreadyMarked = true;
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
            finally {
                if (jf != null) {
                    try {
                        jf.close();
                    }
                    catch (IOException e) {
                        Util.err.notify(1, (Throwable)e);
                    }
                }
            }
            if (shortestPath != null && assignValues) {
                shortestPath = shortestPath.replace('/', '.');
                if (cutShortestPath && shortestPath.indexOf(46) != shortestPath.lastIndexOf(46)) {
                    int ind = shortestPath.lastIndexOf(46);
                    shortestPath = shortestPath.substring(0, ind);
                }
                data.setCodeNameBase(shortestPath);
            }
        }
        return wrongOnes;
    }

    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
        this.checkLibraryAndLicense();
    }

    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.txtLibrary.getDocument().addDocumentListener(this.libraryDL);
            this.txtLicense.getDocument().addDocumentListener(this.licenseDL);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.txtLibrary.getDocument().removeDocumentListener(this.libraryDL);
            this.txtLicense.getDocument().removeDocumentListener(this.licenseDL);
            this.listenersAttached = false;
        }
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(LibraryStartVisualPanel.class, (String)key);
    }

    private void initComponents() {
        this.confPanel = new JPanel();
        this.lblLibrary = new JLabel();
        this.txtLibrary = new JTextField();
        this.lblLicense = new JLabel();
        this.txtLicense = new JTextField();
        this.browseLibraryButton = new JButton();
        this.browseLicenceButton = new JButton();
        this.filler = new JPanel();
        this.setLayout(new GridBagLayout());
        this.confPanel.setLayout(new GridBagLayout());
        this.lblLibrary.setLabelFor(this.txtLibrary);
        Mnemonics.setLocalizedText((JLabel)this.lblLibrary, (String)NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"LBL_Library_path"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.confPanel.add((Component)this.lblLibrary, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.confPanel.add((Component)this.txtLibrary, gridBagConstraints);
        this.lblLicense.setLabelFor(this.txtLicense);
        Mnemonics.setLocalizedText((JLabel)this.lblLicense, (String)NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"LBL_License_Path"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.confPanel.add((Component)this.lblLicense, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.confPanel.add((Component)this.txtLicense, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseLibraryButton, (String)NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"CTL_BrowseButton_o"));
        this.browseLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryStartVisualPanel.this.browseLibraryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.confPanel.add((Component)this.browseLibraryButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseLicenceButton, (String)NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"CTL_BrowseButton_w"));
        this.browseLicenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryStartVisualPanel.this.browseLicenceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.confPanel.add((Component)this.browseLicenceButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.confPanel.add((Component)this.filler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add(this.confPanel, gridBagConstraints);
    }

    private void browseLicenceButtonActionPerformed(ActionEvent evt) {
        int ret;
        JFileChooser chooser = new JFileChooser(ModuleUISettings.getDefault().getLastChosenLibraryLocation());
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        if (this.txtLicense.getText().trim().length() > 0) {
            chooser.setSelectedFile(new File(this.txtLicense.getText().trim()));
        }
        if ((ret = chooser.showDialog((Component)((Object)this), LibraryStartVisualPanel.getMessage("LBL_Select"))) == 0) {
            this.txtLicense.setText(chooser.getSelectedFile().getAbsolutePath());
            ModuleUISettings.getDefault().setLastChosenLibraryLocation(this.txtLicense.getText());
        }
    }

    private void browseLibraryButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(ModuleUISettings.getDefault().getLastChosenLibraryLocation());
        File[] olds = LibraryStartVisualPanel.convertStringToFiles(this.txtLibrary.getText().trim());
        chooser.setSelectedFiles(olds);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.addChoosableFileFilter(new JarZipFilter());
        int ret = chooser.showDialog((Component)((Object)this), LibraryStartVisualPanel.getMessage("LBL_Select"));
        if (ret == 0) {
            File[] files = chooser.getSelectedFiles();
            String path = "";
            for (int i = 0; i < files.length; ++i) {
                path = path + files[i] + (i == files.length - 1 ? "" : File.pathSeparator);
            }
            this.txtLibrary.setText(path);
            ModuleUISettings.getDefault().setLastChosenLibraryLocation(files[0].getParentFile().getAbsolutePath());
        }
    }

    static File[] convertStringToFiles(String path) {
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        File[] olds = new File[tok.countTokens()];
        for (int i = 0; i < olds.length; ++i) {
            olds[i] = new File(tok.nextToken());
        }
        return olds;
    }

    private static final class JarZipFilter
    extends FileFilter {
        private JarZipFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith("zip") || pathname.getName().endsWith("jar");
        }

        @Override
        public String getDescription() {
            return LibraryStartVisualPanel.getMessage("LibraryStartVisualPanel_jar_zip_filter");
        }
    }
}

