/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.SourceRootsProvider;
import org.openide.util.Parameters;

public final class SourceRootsSupport
implements SourceRootsProvider {
    private URL[] sourceRoots;
    private SourceRootsProvider delegate;
    private PropertyChangeSupport pcs;
    private List<ModuleList> listsForSources;

    public SourceRootsSupport(URL[] sourceRoots, SourceRootsProvider delegate) {
        if (sourceRoots == null) {
            throw new NullPointerException("sourceRoots must not be null.");
        }
        this.sourceRoots = sourceRoots;
        this.pcs = new PropertyChangeSupport(this);
        this.delegate = delegate;
    }

    private void maybeUpdateDefaultSources() {
        URL[] defaults;
        if (this.sourceRoots.length == 0 && (defaults = this.getDefaultSourceRoots()) != null) {
            this.sourceRoots = defaults;
            this.pcs.firePropertyChange("sourceRoots", null, null);
        }
    }

    @Override
    public URL[] getDefaultSourceRoots() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getDefaultSourceRoots();
    }

    @Override
    public void addSourceRoot(URL root) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"root", (Object)root);
        if (SourceRootsSupport.containsRoot(this, root)) {
            throw new IllegalArgumentException("Root '" + root + "' already present in sources.");
        }
        this.maybeUpdateDefaultSources();
        URL[] newSourceRoots = new URL[this.sourceRoots.length + 1];
        System.arraycopy(this.sourceRoots, 0, newSourceRoots, 0, this.sourceRoots.length);
        newSourceRoots[this.sourceRoots.length] = root;
        this.setSourceRootsInternal(newSourceRoots);
    }

    @Override
    public File getSourceLocationOfModule(File jar) {
        if (this.listsForSources == null) {
            ArrayList<ModuleList> _listsForSources = new ArrayList<ModuleList>();
            for (URL u : this.getSourceRoots()) {
                File dir;
                if (!u.getProtocol().equals("file") || !(dir = new File(URI.create(u.toExternalForm()))).isDirectory()) continue;
                try {
                    if (ModuleList.isNetBeansOrg(dir)) {
                        _listsForSources.add(ModuleList.findOrCreateModuleListFromNetBeansOrgSources(dir));
                        continue;
                    }
                    _listsForSources.add(ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(dir));
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                }
            }
            this.listsForSources = _listsForSources;
        }
        for (ModuleList l : this.listsForSources) {
            File src;
            String name = jar.getName();
            if (name.endsWith(".jar")) {
                String cnb = name.substring(0, name.length() - ".jar".length()).replace('-', '.');
                if (cnb.equals("boot")) {
                    cnb = "org.netbeans.bootstrap";
                } else if (cnb.equals("core")) {
                    cnb = "org.netbeans.core.startup";
                }
                ModuleEntry entry = l.getEntry(cnb);
                if (entry != null && (src = entry.getSourceLocation()) != null && src.isDirectory()) {
                    return src;
                }
            }
            for (ModuleEntry entry : l.getAllEntries()) {
                if (!entry.getJarLocation().getName().equals(jar.getName()) || (src = entry.getSourceLocation()) == null || !src.isDirectory()) continue;
                return src;
            }
        }
        return null;
    }

    @Override
    public URL[] getSourceRoots() {
        URL[] defaults;
        if (this.sourceRoots.length == 0 && (defaults = this.getDefaultSourceRoots()) != null) {
            return defaults;
        }
        return this.sourceRoots;
    }

    @Override
    public void removeSourceRoots(URL[] urlsToRemove) throws IOException {
        this.maybeUpdateDefaultSources();
        ArrayList<URL> newSources = new ArrayList<URL>(Arrays.asList(this.sourceRoots));
        newSources.removeAll(Arrays.asList(urlsToRemove));
        assert (newSources.size() + urlsToRemove.length >= this.sourceRoots.length) : "Too many roots removed, one of " + Arrays.toString(urlsToRemove) + " was contained more than once";
        URL[] sources = new URL[newSources.size()];
        this.setSourceRootsInternal(newSources.toArray(sources));
    }

    private void setSourceRootsInternal(URL[] roots) throws IOException {
        if (this.delegate != null) {
            this.delegate.setSourceRoots(roots);
        } else {
            this.setSourceRoots(roots);
        }
    }

    @Override
    public void setSourceRoots(URL[] roots) throws IOException {
        this.sourceRoots = roots;
        this.pcs.firePropertyChange("sourceRoots", null, null);
        this.listsForSources = null;
    }

    @Override
    public void moveSourceRootUp(int indexToUp) throws IOException {
        this.maybeUpdateDefaultSources();
        if (indexToUp <= 0) {
            return;
        }
        URL[] newSourceRoots = new URL[this.sourceRoots.length];
        System.arraycopy(this.sourceRoots, 0, newSourceRoots, 0, this.sourceRoots.length);
        newSourceRoots[indexToUp - 1] = this.sourceRoots[indexToUp];
        newSourceRoots[indexToUp] = this.sourceRoots[indexToUp - 1];
        this.setSourceRootsInternal(newSourceRoots);
    }

    @Override
    public void moveSourceRootDown(int indexToDown) throws IOException {
        this.maybeUpdateDefaultSources();
        if (indexToDown >= this.sourceRoots.length - 1) {
            return;
        }
        URL[] newSourceRoots = new URL[this.sourceRoots.length];
        System.arraycopy(this.sourceRoots, 0, newSourceRoots, 0, this.sourceRoots.length);
        newSourceRoots[indexToDown + 1] = this.sourceRoots[indexToDown];
        newSourceRoots[indexToDown] = this.sourceRoots[indexToDown + 1];
        this.setSourceRootsInternal(newSourceRoots);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static boolean containsRoot(SourceRootsProvider provider, URL root) {
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        Parameters.notNull((CharSequence)"root", (Object)root);
        for (URL r2 : provider.getSourceRoots()) {
            if (!root.equals(r2)) continue;
            return true;
        }
        return false;
    }
}

