/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.netbeans.spi.jumpto.file.FileProvider;
import org.netbeans.spi.jumpto.file.FileProviderFactory;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.CharSequences;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class MakeProjectFileProviderFactory
implements FileProviderFactory {
    private static final ConcurrentMap<Lookup.Provider, Map<Folder, List<CharSequence>>> searchBase = new ConcurrentHashMap<Lookup.Provider, Map<Folder, List<CharSequence>>>();
    private static final ConcurrentMap<Lookup.Provider, ConcurrentMap<CharSequence, List<CharSequence>>> fileNameSearchBase = new ConcurrentHashMap<Lookup.Provider, ConcurrentMap<CharSequence, List<CharSequence>>>();
    private static final Collection<? extends UserOptionsProvider> packageSearch = Lookup.getDefault().lookupAll(UserOptionsProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSearchBase(Project project, Folder folder, List<CharSequence> list) {
        Map old;
        Map<Folder, List<Object>> projectSearchBase = (ConcurrentHashMap<Folder, List<Object>>)searchBase.get(project);
        if (projectSearchBase == null && (old = (Map)searchBase.putIfAbsent((Lookup.Provider)project, projectSearchBase = new ConcurrentHashMap<Folder, List<Object>>())) != null) {
            projectSearchBase = old;
        }
        ConcurrentHashMap<Folder, List<Object>> concurrentHashMap = projectSearchBase;
        synchronized (concurrentHashMap) {
            if (list == null) {
                projectSearchBase.remove(folder);
            } else if (list.isEmpty()) {
                projectSearchBase.put(folder, new ArrayList(0));
            } else {
                projectSearchBase.put(folder, list);
            }
        }
    }

    public static void removeSearchBase(Project project) {
        searchBase.remove(project);
    }

    public static void removeFromSearchBase(Project project, Folder folder, CharSequence item) {
        MakeProjectFileProviderFactory.updateSearchBaseImpl(project, folder, item, true);
    }

    public static void addToSearchBase(Project project, Folder folder, CharSequence item) {
        MakeProjectFileProviderFactory.updateSearchBaseImpl(project, folder, item, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSearchBaseImpl(Project project, Folder folder, CharSequence item, boolean remove) {
        ConcurrentMap projectFileNames;
        Map projectSearchBase = (Map)searchBase.get(project);
        if (projectSearchBase != null) {
            Map map = projectSearchBase;
            synchronized (map) {
                List folderItems = (List)projectSearchBase.get(folder);
                if (folderItems != null) {
                    if (remove) {
                        folderItems.remove(item);
                    } else {
                        folderItems.add(item);
                    }
                }
            }
        }
        if ((projectFileNames = (ConcurrentMap)fileNameSearchBase.get(project)) != null) {
            Collection res;
            String fileName = ((Object)item).toString();
            int i = fileName.lastIndexOf(47);
            String name = fileName;
            if (i >= 0) {
                name = fileName.substring(i + 1);
            }
            if ((res = (Collection)projectFileNames.get(CharSequences.create((CharSequence)name))) != null) {
                Collection collection = res;
                synchronized (collection) {
                    if (remove) {
                        res.remove(item);
                    } else {
                        res.add(item);
                    }
                }
            }
        }
    }

    public String name() {
        return "CND FileProviderFactory";
    }

    public String getDisplayName() {
        return this.name();
    }

    public FileProvider createFileProvider() {
        return new FileProviderImpl();
    }

    private static final class OtherFD
    extends FDImpl {
        private final String name;
        private final Folder folder;
        private final String baseDir;

        public OtherFD(String name, Project project, String baseDir, Folder folder) {
            super(name, project);
            this.name = name;
            this.folder = folder;
            this.baseDir = baseDir;
        }

        public String getOwnerPath() {
            return this.folder.getPath();
        }

        @Override
        protected DataObject getDataObject() {
            try {
                FileObject fo = this.getFileObject();
                if (fo != null && fo.isValid()) {
                    return DataObject.find((FileObject)fo);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            return null;
        }

        public FileObject getFileObject() {
            FileObject fileObject = RemoteFileUtil.getFileObject((FileObject)this.folder.getConfigurationDescriptor().getBaseDirFileObject(), (String)(this.folder.getRootPath() + "/" + this.name));
            if (fileObject != null && fileObject.isValid()) {
                return fileObject;
            }
            return null;
        }
    }

    private static final class ItemFD
    extends FDImpl {
        private final Item item;

        public ItemFD(Item item, Project project) {
            super(item.getName(), project);
            this.item = item;
        }

        public String getOwnerPath() {
            StringBuilder out = new StringBuilder();
            for (Folder parent = this.item.getFolder(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
                if (out.length() > 0) {
                    out.insert(0, "/");
                }
                out.insert(0, parent.getDisplayName());
            }
            return out.toString();
        }

        public FileObject getFileObject() {
            return this.item.getFileObject();
        }

        @Override
        protected DataObject getDataObject() {
            return this.item.getDataObject();
        }
    }

    private static abstract class FDImpl
    extends FileDescriptor {
        private final String fileName;
        private final Project project;

        public FDImpl(String fileName, Project project) {
            this.fileName = fileName;
            this.project = project;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final String getProjectName() {
            MakeProject.InfoInterface info = (MakeProject.InfoInterface)this.project.getLookup().lookup(ProjectInformation.class);
            return info.getName();
        }

        public final Icon getProjectIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)true);
        }

        public final void open() {
            DataObject od = this.getDataObject();
            if (od != null) {
                Editable ec = (Editable)od.getLookup().lookup(Editable.class);
                if (ec != null) {
                    ec.edit();
                } else {
                    Openable oc = (Openable)od.getLookup().lookup(Openable.class);
                    if (oc != null) {
                        oc.open();
                    }
                }
            }
        }

        public final Icon getIcon() {
            DataObject od = this.getDataObject();
            if (od != null) {
                Image i = od.getNodeDelegate().getIcon(1);
                return new ImageIcon(i);
            }
            return null;
        }

        protected abstract DataObject getDataObject();
    }

    private static final class FileProviderImpl
    implements FileProvider,
    NativeFileSearch {
        private final AtomicBoolean cancel = new AtomicBoolean();
        private final Set<SearchContext> searchedProjects = new HashSet<SearchContext>();
        private FileProvider.Context lastContext = null;

        public boolean computeFiles(FileProvider.Context context, FileProvider.Result result) {
            if (!MakeOptions.getInstance().isFullFileIndexer()) {
                this.cancel.set(false);
                Project project = context.getProject();
                SearchContext searchContext = new SearchContext(context.getText(), context.getSearchType(), project);
                if (project != null) {
                    if (context != this.lastContext) {
                        this.lastContext = context;
                        this.searchedProjects.clear();
                    }
                    if (this.searchedProjects.add(searchContext)) {
                        ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                        if (provider != null && provider.gotDescriptor()) {
                            MakeConfigurationDescriptor descriptor = provider.getConfigurationDescriptor();
                            Sources srcs = (Sources)project.getLookup().lookup(Sources.class);
                            SourceGroup[] genericSG = srcs.getSourceGroups("generic");
                            if (genericSG != null && genericSG.length > 0) {
                                for (SourceGroup group : genericSG) {
                                    if (!group.getRootFolder().equals(context.getRoot())) continue;
                                    NameMatcher matcher = NameMatcherFactory.createNameMatcher((String)context.getText(), (SearchType)context.getSearchType());
                                    this.computeFiles(project, descriptor, matcher, result);
                                    break;
                                }
                            }
                            return false;
                        }
                    } else {
                        System.err.println("MakeProjectFileProviderFactory.FileProviderImpl.computeFiles: skip already searched context " + searchContext);
                    }
                } else {
                    System.err.println("MakeProjectFileProviderFactory.FileProviderImpl.computeFiles: no project for source root " + context.getRoot());
                }
            }
            return false;
        }

        public Collection<CharSequence> searchFile(NativeProject project, String fileName) {
            if (MakeOptions.getInstance().isFixUnresolvedInclude()) {
                for (NativeProject np : NativeProjectRegistry.getDefault().getOpenProjects()) {
                    Collection res;
                    Lookup.Provider p;
                    if (np != project || !((p = np.getProject()) instanceof Project)) continue;
                    ConcurrentMap<CharSequence, List<CharSequence>> projectSearchBase = (ConcurrentMap<CharSequence, List<CharSequence>>)fileNameSearchBase.get(p);
                    if (projectSearchBase == null) {
                        projectSearchBase = this.computeProjectFiles(p);
                        fileNameSearchBase.put(p, projectSearchBase);
                    }
                    int i = fileName.lastIndexOf(47);
                    String name = fileName;
                    if (i >= 0) {
                        name = fileName.substring(i + 1);
                    }
                    if ((res = (Collection)projectSearchBase.get(CharSequences.create((CharSequence)name))) != null && res.size() > 0) {
                        return res;
                    }
                    boolean isLocalHost = true;
                    MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Project)p);
                    if (conf != null) {
                        isLocalHost = conf.getDevelopmentHost().isLocalhost();
                    }
                    boolean runPackagesSearchInRemote = Boolean.valueOf(System.getProperty("cnd.pkg.search.enabled", "false"));
                    if (!packageSearch.isEmpty() && (isLocalHost || runPackagesSearchInRemote)) {
                        UserOptionsProvider userOptionsProvider;
                        NativeFileSearch search;
                        Iterator i$ = packageSearch.iterator();
                        while (i$.hasNext() && ((search = (userOptionsProvider = (UserOptionsProvider)i$.next()).getPackageFileSearch((Project)p)) == null || (res = search.searchFile(project, fileName)) == null)) {
                        }
                    }
                    if (res == null || res.size() <= 0) continue;
                    return res;
                }
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ConcurrentMap<CharSequence, List<CharSequence>> computeProjectFiles(Lookup.Provider project) {
            ConcurrentHashMap<CharSequence, List<CharSequence>> result = new ConcurrentHashMap<CharSequence, List<CharSequence>>();
            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (provider != null && provider.gotDescriptor()) {
                HashMap projectSearchBase;
                MakeConfigurationDescriptor descriptor = provider.getConfigurationDescriptor();
                for (Item item : descriptor.getProjectItems()) {
                    List prev;
                    CharSequence name = CharSequences.create((CharSequence)item.getName());
                    List<CharSequence> list = (ArrayList<CharSequence>)result.get(name);
                    if (list == null && (prev = (List)result.putIfAbsent(name, list = new ArrayList<CharSequence>(1))) != null) {
                        list = prev;
                    }
                    list.add(CharSequences.create((CharSequence)item.getAbsPath()));
                }
                if (!MakeOptions.getInstance().isFullFileIndexer() && (projectSearchBase = (HashMap)searchBase.get(project)) != null) {
                    HashMap len$ = projectSearchBase;
                    synchronized (len$) {
                        projectSearchBase = new HashMap(projectSearchBase);
                    }
                    for (List files : projectSearchBase.values()) {
                        if (files == null) continue;
                        for (CharSequence path : files) {
                            List prev;
                            String absPath = ((Object)path).toString();
                            int i = absPath.lastIndexOf(47);
                            if (i < 0) {
                                i = absPath.lastIndexOf(92);
                            }
                            if (i < 0) continue;
                            CharSequence name = CharSequences.create((CharSequence)absPath.substring(i + 1));
                            List<CharSequence> list = (ArrayList<CharSequence>)result.get(name);
                            if (list == null && (prev = (List)result.putIfAbsent(name, list = new ArrayList<CharSequence>(1))) != null) {
                                list = prev;
                            }
                            list.add(path);
                        }
                    }
                }
            }
            return result;
        }

        public void cancel() {
            this.cancel.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeFiles(Project project, MakeConfigurationDescriptor descriptor, NameMatcher matcher, FileProvider.Result result) {
            FileObject projectDirectoryFO = project.getProjectDirectory();
            if (projectDirectoryFO != null) {
                FileObject nbFO = projectDirectoryFO.getFileObject("nbproject");
                this.computeFOs(nbFO, matcher, result);
            }
            for (Item item : descriptor.getExternalFileItemsAsArray()) {
                if (this.cancel.get()) {
                    return;
                }
                if (!matcher.accept(item.getName())) continue;
                result.addFileDescriptor((FileDescriptor)new ItemFD(item, project));
            }
            for (Item item : descriptor.getProjectItems()) {
                if (this.cancel.get()) {
                    return;
                }
                if (!matcher.accept(item.getName())) continue;
                result.addFileDescriptor((FileDescriptor)new ItemFD(item, project));
            }
            HashMap projectSearchBase = (HashMap)searchBase.get(project);
            if (projectSearchBase != null) {
                HashMap len$ = projectSearchBase;
                synchronized (len$) {
                    projectSearchBase = new HashMap(projectSearchBase);
                }
                String baseDir = descriptor.getBaseDir();
                for (Map.Entry entry : projectSearchBase.entrySet()) {
                    if (this.cancel.get()) {
                        return;
                    }
                    Folder folder = (Folder)entry.getKey();
                    List files = (List)entry.getValue();
                    if (files == null) continue;
                    for (CharSequence name : files) {
                        if (this.cancel.get()) {
                            return;
                        }
                        if (!matcher.accept(((Object)name).toString())) continue;
                        result.addFileDescriptor((FileDescriptor)new OtherFD(((Object)name).toString(), project, baseDir, folder));
                    }
                }
            }
        }

        private void computeFOs(FileObject nbFO, NameMatcher matcher, FileProvider.Result result) {
            if (nbFO != null) {
                assert (nbFO.isFolder());
                for (FileObject fileObject : nbFO.getChildren()) {
                    if (fileObject.isFolder()) {
                        this.computeFOs(fileObject, matcher, result);
                        continue;
                    }
                    if (!matcher.accept(fileObject.getNameExt())) continue;
                    result.addFile(fileObject);
                }
            }
        }

        private static final class SearchContext {
            private final String searchText;
            private final SearchType searchType;
            private final Project project;

            public SearchContext(String searchText, SearchType searchType, Project project) {
                this.searchText = searchText;
                this.searchType = searchType;
                this.project = project;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SearchContext other = (SearchContext)obj;
                if (this.searchText == null ? other.searchText != null : !this.searchText.equals(other.searchText)) {
                    return false;
                }
                if (this.searchType != other.searchType) {
                    return false;
                }
                return this.project == other.project || this.project != null && this.project.equals(other.project);
            }

            public int hashCode() {
                int hash = 7;
                hash = 43 * hash + (this.searchText != null ? this.searchText.hashCode() : 0);
                hash = 43 * hash + (this.searchType != null ? this.searchType.hashCode() : 0);
                hash = 43 * hash + (this.project != null ? this.project.hashCode() : 0);
                return hash;
            }

            public String toString() {
                return "SearchContext{searchText=" + this.searchText + ", searchType=" + this.searchType + ", project=" + this.project + '}';
            }
        }
    }
}

