/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class NewTestActionFactory {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");

    private NewTestActionFactory() {
    }

    public static Action[] getTestCreationActions(Project project) {
        ArrayList<NewTestAction> actions = new ArrayList<NewTestAction>();
        FileObject testFiles = FileUtil.getConfigFile((String)"Templates/testFiles");
        if (testFiles != null && testFiles.isFolder()) {
            for (FileObject test : testFiles.getChildren()) {
                if ("hidden".equals(test.getAttribute("templateCategory"))) continue;
                actions.add(new NewTestAction(test, project, null, false));
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public static Action createNewTestsSubmenu() {
        return SystemAction.get(CreateTestSubmenuAction.class);
    }

    public static Action emptyTestFolderAction() {
        return SystemAction.get(NewEmptyTestAction.class);
    }

    private static final class LazyPopupMenu
    extends JMenu {
        private final Collection<Action> items;

        public LazyPopupMenu(String name, Collection<Action> items) {
            super(name);
            assert (items != null) : "array must be inited";
            this.items = items;
        }

        @Override
        public synchronized JPopupMenu getPopupMenu() {
            super.removeAll();
            for (Action action : this.items) {
                JMenuItem item;
                if (action instanceof Presenter.Popup) {
                    item = ((Presenter.Popup)action).getPopupPresenter();
                    this.add(item);
                    continue;
                }
                if (action instanceof Presenter.Menu) {
                    item = ((Presenter.Menu)action).getMenuPresenter();
                    this.add(item);
                    continue;
                }
                this.add(action);
            }
            return super.getPopupMenu();
        }
    }

    private static final class CreateTestSubmenuAction
    extends NodeAction {
        private LazyPopupMenu popupMenu;
        private final Collection<Action> items = new ArrayList<Action>(5);

        private CreateTestSubmenuAction() {
        }

        public JMenuItem getPopupPresenter() {
            this.createSubMenu();
            return this.popupMenu;
        }

        public JMenuItem getMenuPresenter() {
            this.createSubMenu();
            return this.popupMenu;
        }

        private void createSubMenu() {
            Project project;
            FileObject fo;
            if (this.popupMenu == null) {
                this.popupMenu = new LazyPopupMenu(NbBundle.getMessage(CreateTestSubmenuAction.class, (String)"CTL_TestAction"), this.items);
            }
            this.items.clear();
            Node[] nodes = this.getActivatedNodes();
            if (nodes != null && nodes.length == 1 && (fo = (FileObject)nodes[0].getLookup().lookup(FileObject.class)) != null && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null) {
                this.items.addAll(this.createActions(project, fo));
            }
            this.popupMenu.setEnabled(!this.items.isEmpty());
        }

        protected void performAction(Node[] activatedNodes) {
        }

        protected boolean enable(Node[] activatedNodes) {
            NativeFileItemSet set;
            if (activatedNodes.length == 1 && (set = (NativeFileItemSet)activatedNodes[0].getLookup().lookup(NativeFileItemSet.class)) != null && !set.isEmpty()) {
                for (NativeFileItem nativeFileItem : set.getItems()) {
                    Item item;
                    Folder folder;
                    if (!(nativeFileItem instanceof Item) || (folder = (item = (Item)nativeFileItem).getFolder()) == null || !folder.isTest()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String getName() {
            return NbBundle.getMessage(CreateTestSubmenuAction.class, (String)"CTL_TestAction");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        private Collection<Action> createActions(Project project, FileObject fo) {
            ArrayList<Action> actions = new ArrayList<Action>();
            FileObject testFiles = FileUtil.getConfigFile((String)"Templates/testFiles");
            if (testFiles != null && testFiles.isFolder()) {
                for (FileObject test : testFiles.getChildren()) {
                    String mimeTypes;
                    if (!Boolean.TRUE.equals(test.getAttribute("templateGenerator")) || !this.checkMimeType(mimeTypes = (String)test.getAttribute("supportedMimeTypes"), fo.getMIMEType())) continue;
                    actions.add(new NewTestAction(test, project, Utilities.actionsGlobalContext(), true));
                }
            }
            return actions;
        }

        private boolean checkMimeType(String mimeTypes, String mimeType) {
            String[] split;
            if (mimeTypes == null) {
                return true;
            }
            for (String string : split = mimeTypes.split(";")) {
                if (!mimeType.contentEquals(string)) continue;
                return true;
            }
            return false;
        }
    }

    public static class NewEmptyTestAction
    extends NodeAction {
        public String getName() {
            return this.getString("NewEmptyTestActionName");
        }

        public void performAction(Node[] activatedNodes) {
            Node n = activatedNodes[0];
            Folder folder = (Folder)n.getValue("Folder");
            assert (folder != null);
            Node thisNode = (Node)n.getValue("This");
            assert (thisNode != null);
            Project project = (Project)n.getValue("Project");
            assert (project != null);
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
            if (!makeConfigurationDescriptor.okToChange()) {
                return;
            }
            NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(this.getString("TestName"), this.getString("NewTest"));
            dlg.setInputText(folder.suggestedNewTestFolderName());
            String newname = null;
            if (!NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg))) {
                return;
            }
            newname = dlg.getInputText();
            Folder newFolder = folder.addNewFolder(true, Folder.Kind.TEST);
            newFolder.setDisplayName(newname);
            this.setOptions(project, newFolder);
            MakeLogicalViewProvider.setVisible(project, newFolder);
        }

        private void setOptions(Project project, Folder testFolder) {
            ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor projectDescriptor = cdp.getConfigurationDescriptor();
            FolderConfiguration folderConfiguration = testFolder.getFolderConfiguration(projectDescriptor.getActiveConfiguration());
            LinkerConfiguration linkerConfiguration = folderConfiguration.getLinkerConfiguration();
            linkerConfiguration.getOutput().setValue("${TESTDIR}/" + testFolder.getPath());
            CCompilerConfiguration cCompilerConfiguration = folderConfiguration.getCCompilerConfiguration();
            CCCompilerConfiguration ccCompilerConfiguration = folderConfiguration.getCCCompilerConfiguration();
            cCompilerConfiguration.getIncludeDirectories().add(".");
            ccCompilerConfiguration.getIncludeDirectories().add(".");
        }

        public boolean enable(Node[] activatedNodes) {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        private String getString(String s) {
            return NbBundle.getBundle(NewTestActionFactory.class).getString(s);
        }
    }

    private static class NewTestAction
    extends AbstractAction {
        private final FileObject test;
        private final Project project;
        private final Lookup context;
        private final boolean generateCode;

        public NewTestAction(FileObject test, Project project, Lookup context, boolean generateCode) {
            MakeConfiguration activeConfiguration;
            super.putValue("Name", NbBundle.getMessage(CreateTestSubmenuAction.class, (String)"NewTestNameWrapper", (Object)this.getName(test)));
            super.putValue("SmallIcon", this.getIcon(test));
            this.test = test;
            this.project = project;
            this.context = context;
            this.generateCode = generateCode;
            MakeConfigurationDescriptor mcd = MakeConfigurationDescriptor.getMakeConfigurationDescriptor(project);
            if (mcd != null && (activeConfiguration = mcd.getActiveConfiguration()) != null && activeConfiguration.getConfigurationType().getValue() == 0) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TemplateWizard templateWizard = new TemplateWizard();
                Project aProject = this.project;
                templateWizard.putProperty("UnitTestContextLookup", (Object)this.context);
                templateWizard.putProperty("UnitTestCodeGeneration", (Object)this.generateCode);
                if (aProject == null) {
                    FileObject fo;
                    assert (this.context != null);
                    Node node = (Node)this.context.lookup(Node.class);
                    if (node != null && (fo = (FileObject)node.getLookup().lookup(FileObject.class)) != null) {
                        aProject = FileOwnerQuery.getOwner((FileObject)fo);
                    }
                }
                templateWizard.putProperty("project", (Object)aProject);
                DataObject dob = DataObject.find((FileObject)FileUtil.getConfigFile((String)this.test.getPath()));
                String title = templateWizard.getTitleFormat().format(new Object[]{dob.getNodeDelegate().getDisplayName()});
                templateWizard.setTitle(title);
                Set files = templateWizard.instantiate(dob);
                if (files != null && !files.isEmpty()) {
                    MakeConfigurationDescriptor mkd = this.getMakeConfigurationDescriptor(this.project);
                    if (mkd != null) {
                        String path = ((DataObject)files.iterator().next()).getPrimaryFile().getPath();
                        Item item = mkd.findProjectItemByPath(path);
                        if (item != null) {
                            MakeLogicalViewProvider.setVisible(this.project, item.getFolder());
                        } else {
                            LOGGER.log(Level.WARNING, "Can not find project item for {0}", path);
                        }
                    } else {
                        LOGGER.warning("Can not get make configuration descriptor");
                    }
                    for (DataObject file : files) {
                        Openable open = (Openable)file.getLookup().lookup(Openable.class);
                        if (open == null) continue;
                        open.open();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private MakeConfigurationDescriptor getMakeConfigurationDescriptor(Project p) {
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)p.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (pdp == null) {
                return null;
            }
            return pdp.getConfigurationDescriptor();
        }

        private String getName(FileObject test) {
            return NbBundle.getBundle((String)((String)test.getAttribute("SystemFileSystem.localizingBundle"))).getString(test.getPath());
        }

        private Icon getIcon(FileObject test) {
            URL url = (URL)test.getAttribute("SystemFileSystem.icon");
            return ImageUtilities.loadImageIcon((String)url.getPath().substring(1), (boolean)true);
        }
    }
}

