/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.actions;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class NewFolderAction
extends NodeAction {
    public String getName() {
        return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("CTL_NewFolderAction");
    }

    public void performAction(Node[] activatedNodes) {
        Node n = activatedNodes[0];
        Folder folder = (Folder)n.getValue("Folder");
        assert (folder != null);
        Node thisNode = (Node)n.getValue("This");
        assert (thisNode != null);
        Project project = (Project)n.getValue("Project");
        assert (project != null);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        if (!makeConfigurationDescriptor.okToChange()) {
            return;
        }
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(this.getString("FolderNameTxt"), this.getString("NewFolderName"));
        dlg.setInputText(folder.suggestedNewFolderName());
        String newname = null;
        if (!NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg))) {
            return;
        }
        newname = dlg.getInputText();
        Folder newFolder = folder.addNewFolder(true);
        newFolder.setDisplayName(newname);
        MakeLogicalViewProvider.setVisible(project, newFolder);
    }

    public boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Folder folder = (Folder)activatedNodes[0].getValue("Folder");
        return folder != null;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getString(String s) {
        return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(s);
    }
}

