/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.CompileOptionsProvider;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class CCompilerConfiguration
extends CCCCompilerConfiguration {
    public CCompilerConfiguration(String baseDir, CCompilerConfiguration master, MakeConfiguration owner) {
        super(baseDir, master, owner);
    }

    public void assign(CCompilerConfiguration conf) {
        super.assign(conf);
    }

    public CCompilerConfiguration clone() {
        CCompilerConfiguration clone = new CCompilerConfiguration(this.getBaseDir(), (CCompilerConfiguration)this.getMaster(), this.getOwner());
        clone.setDevelopmentMode(this.getDevelopmentMode().clone());
        clone.setWarningLevel(this.getWarningLevel().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setSixtyfourBits(this.getSixtyfourBits().clone());
        clone.setStrip(this.getStrip().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setTool(this.getTool().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setLibraryLevel(this.getLibraryLevel().clone());
        clone.setStandardsEvolution(this.getStandardsEvolution().clone());
        clone.setLanguageExt(this.getLanguageExt().clone());
        clone.setIncludeDirectories((VectorConfiguration<String>)this.getIncludeDirectories().clone());
        clone.setInheritIncludes(this.getInheritIncludes().clone());
        clone.setPreprocessorConfiguration((VectorConfiguration<String>)this.getPreprocessorConfiguration().clone());
        clone.setInheritPreprocessor(this.getInheritPreprocessor().clone());
        clone.setUseLinkerLibraries(this.getUseLinkerLibraries().clone());
        return clone;
    }

    @Override
    public String getOptions(AbstractCompiler compiler) {
        String options = "$(COMPILE.c) ";
        options = options + this.getAllOptions2(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    public String getCFlagsBasic(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getMTLevelOptions(this.getMTLevel().getValue()) + " ";
        options = options + compiler.getStandardEvaluationOptions(this.getStandardsEvolution().getValue()) + " ";
        options = options + compiler.getLanguageExtOptions(this.getLanguageExt().getValue()) + " ";
        options = options + compiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            options = options + compiler.getDevelopmentModeOptions(3);
        }
        return CppUtils.reformatWhitespaces(options);
    }

    public String getCFlags(AbstractCompiler compiler) {
        String options = this.getCFlagsBasic(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        if (!(tool instanceof AbstractCompiler)) {
            return "";
        }
        AbstractCompiler compiler = (AbstractCompiler)tool;
        StringBuilder options = new StringBuilder();
        options.append(this.getCFlagsBasic(compiler));
        options.append(" ");
        for (CCompilerConfiguration master = this; master != null; master = (CCompilerConfiguration)master.getMaster()) {
            options.append(master.getCommandLineConfiguration().getValue());
            options.append(" ");
        }
        options.append(this.getAllOptions2(compiler));
        options.append(" ");
        return CppUtils.reformatWhitespaces(options.toString());
    }

    public String getAllOptions2(AbstractCompiler compiler) {
        String options = "";
        if (this.getDevelopmentMode().getValue() != 3) {
            options = options + compiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        }
        options = options + compiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        options = options + compiler.getStripOption(this.getStrip().getValue()) + " ";
        options = options + this.getPreprocessorOptions(compiler.getCompilerSet());
        options = options + this.getIncludeDirectoriesOptions(compiler.getCompilerSet());
        options = options + this.getLibrariesFlags();
        return CppUtils.reformatWhitespaces(options);
    }

    public String getPreprocessorOptions(CompilerSet cs) {
        CCompilerConfiguration master = (CCompilerConfiguration)this.getMaster();
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(null, this.getUserMacroFlag(cs));
        StringBuilder options = new StringBuilder(this.getPreprocessorConfiguration().toString(visitor));
        options.append(' ');
        while (master != null && this.getInheritPreprocessor().getValue()) {
            options.append(master.getPreprocessorConfiguration().toString(visitor));
            options.append(' ');
            if (master.getInheritPreprocessor().getValue()) {
                master = (CCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        return options.toString();
    }

    public String getIncludeDirectoriesOptions(CompilerSet cs) {
        CCompilerConfiguration master = (CCompilerConfiguration)this.getMaster();
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(cs, this.getUserIncludeFlag(cs));
        StringBuilder options = new StringBuilder(this.getIncludeDirectories().toString(visitor));
        options.append(' ');
        while (master != null && this.getInheritIncludes().getValue()) {
            options.append(master.getIncludeDirectories().toString(visitor));
            options.append(' ');
            if (master.getInheritIncludes().getValue()) {
                master = (CCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        return options.toString();
    }

    @Override
    protected String getUserIncludeFlag(CompilerSet cs) {
        return cs.getCompilerFlavor().getToolchainDescriptor().getC().getUserIncludeFlag();
    }

    @Override
    protected String getUserMacroFlag(CompilerSet cs) {
        return cs.getCompilerFlavor().getToolchainDescriptor().getC().getUserMacroFlag();
    }

    public Sheet getGeneralSheet(MakeConfiguration conf, Folder folder, Item item) {
        String compileLine;
        AllOptionsProvider options;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler cCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
        Sheet.Set set0 = this.getSet();
        sheet.put(set0);
        if (conf.isCompileConfiguration() && folder == null) {
            sheet.put(this.getBasicSet());
            if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
                Sheet.Set set2 = new Sheet.Set();
                set2.setName("OtherOptions");
                set2.setDisplayName(CCompilerConfiguration.getString("OtherOptionsTxt"));
                set2.setShortDescription(CCompilerConfiguration.getString("OtherOptionsHint"));
                set2.put((Node.Property)new IntNodeProp(this.getMTLevel(), this.getMaster() == null, "MultithreadingLevel", CCompilerConfiguration.getString("MultithreadingLevelTxt"), CCompilerConfiguration.getString("MultithreadingLevelHint")));
                set2.put((Node.Property)new IntNodeProp(this.getStandardsEvolution(), this.getMaster() == null, "StandardsEvolution", CCompilerConfiguration.getString("StandardsEvolutionTxt"), CCompilerConfiguration.getString("StandardsEvolutionHint")));
                set2.put((Node.Property)new IntNodeProp(this.getLanguageExt(), this.getMaster() == null, "LanguageExtensions", CCompilerConfiguration.getString("LanguageExtensionsTxt"), CCompilerConfiguration.getString("LanguageExtensionsHint")));
                sheet.put(set2);
            }
            if (this.getMaster() != null) {
                sheet.put(this.getInputSet());
            }
            Sheet.Set set4 = new Sheet.Set();
            set4.setName("Tool");
            set4.setDisplayName(CCompilerConfiguration.getString("ToolTxt1"));
            set4.setShortDescription(CCompilerConfiguration.getString("ToolHint1"));
            if (cCompiler != null) {
                set4.put((Node.Property)new StringNodeProp(this.getTool(), cCompiler.getName(), false, "Tool", CCompilerConfiguration.getString("ToolTxt2"), CCompilerConfiguration.getString("ToolHint2")));
            }
            sheet.put(set4);
            String[] texts = new String[]{CCompilerConfiguration.getString("AdditionalOptionsTxt1"), CCompilerConfiguration.getString("AdditionalOptionsHint"), CCompilerConfiguration.getString("AdditionalOptionsTxt2"), CCompilerConfiguration.getString("AllOptionsTxt")};
            Sheet.Set set2 = new Sheet.Set();
            set2.setName("CommandLine");
            set2.setDisplayName(CCompilerConfiguration.getString("CommandLineTxt"));
            set2.setShortDescription(CCompilerConfiguration.getString("CommandLineHint"));
            if (cCompiler != null) {
                set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, cCompiler, null, texts));
            }
            sheet.put(set2);
        } else if (conf.getConfigurationType().getValue() == 0 && item != null && cCompiler != null && (options = CompileOptionsProvider.getDefault().getOptions(item)) != null && (compileLine = options.getAllOptions((Tool)cCompiler)) != null) {
            int hasPath = compileLine.indexOf(35);
            if (hasPath >= 0) {
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCompilerConfiguration.getString("CommandLineTxt"), CCompilerConfiguration.getString("CommandLineHint"), compileLine.substring(hasPath + 1)));
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCompilerConfiguration.getString("CompileFolderTxt"), CCompilerConfiguration.getString("CompileFolderHint"), compileLine.substring(0, hasPath)));
            } else {
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCompilerConfiguration.getString("CommandLineTxt"), CCompilerConfiguration.getString("CommandLineHint"), compileLine.substring(hasPath)));
            }
        }
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCompilerConfiguration.class, (String)s);
    }
}

