/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.List;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;

public class OptionsConfiguration {
    private String preDefined = "";
    private boolean dirty = false;
    private String commandLine;
    private boolean commandLineModified;

    public OptionsConfiguration() {
        this.optionsReset();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setValue(String commandLine) {
        this.commandLine = commandLine;
        this.setModified(!commandLine.equals(this.getDefault()));
    }

    public String getValue() {
        return this.commandLine;
    }

    public void setModified(boolean b) {
        this.commandLineModified = b;
    }

    public boolean getModified() {
        return this.commandLineModified;
    }

    public String getDefault() {
        return "";
    }

    public final void optionsReset() {
        this.commandLine = this.getDefault();
        this.commandLineModified = false;
    }

    public String getOptions(String prepend) {
        return CppUtils.reformatWhitespaces(this.getValue(), prepend);
    }

    public String[] getValues() {
        List<String> list = this.getValuesAsList();
        String[] values = new String[list.size()];
        int i = 0;
        for (String s : list) {
            values[i++] = s;
        }
        return values;
    }

    public List<String> getValuesAsList() {
        return CppUtils.tokenizeString(this.getValue());
    }

    public void setPreDefined(String preDefined) {
        this.preDefined = preDefined;
    }

    public String getPreDefined() {
        return this.preDefined;
    }

    public void assign(OptionsConfiguration conf) {
        this.setDirty(!conf.getValue().equals(this.getValue()));
        this.setValue(conf.getValue());
        this.setModified(conf.getModified());
        this.setPreDefined(conf.getPreDefined());
    }

    public OptionsConfiguration clone() {
        OptionsConfiguration clone = new OptionsConfiguration();
        clone.setValue(this.getValue());
        clone.setModified(this.getModified());
        clone.setDirty(this.getDirty());
        clone.setPreDefined(this.getPreDefined());
        return clone;
    }

    public String toString() {
        return "{commandLine=" + this.commandLine + "] dirty=" + this.dirty + " commandLineModified=" + this.commandLineModified + '}';
    }
}

