/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.LibrariesPanel;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertySupport;

public class LibrariesNodeProp
extends PropertySupport<List> {
    private final LibrariesConfiguration configuration;
    private final Project project;
    private final MakeConfiguration conf;
    private final FSPath baseDir;
    private final String[] texts;

    public LibrariesNodeProp(LibrariesConfiguration configuration, Project project, MakeConfiguration conf, FSPath baseDir, String[] texts) {
        super(texts[0], List.class, texts[1], texts[2], true, true);
        this.configuration = configuration;
        this.project = project;
        this.conf = conf;
        this.baseDir = baseDir;
        this.texts = texts;
    }

    public String getHtmlDisplayName() {
        if (this.configuration.getModified()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public List getValue() {
        return this.configuration.getValue();
    }

    public void setValue(List v) {
        this.configuration.setValue(v);
    }

    public void restoreDefaultValue() {
        this.configuration.reset();
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.configuration.getValue().isEmpty();
    }

    public PropertyEditor getPropertyEditor() {
        ArrayList<LibraryItem> clone = new ArrayList<LibraryItem>();
        clone.addAll(this.configuration.getValue());
        return new DirectoriesEditor(clone);
    }

    public Object getValue(String attributeName) {
        if (attributeName.equals("canEditAsText")) {
            return Boolean.FALSE;
        }
        return super.getValue(attributeName);
    }

    private class DirectoriesEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private List<LibraryItem> value;
        private PropertyEnv env;

        public DirectoriesEditor(List<LibraryItem> value) {
            this.value = value;
        }

        @Override
        public void setAsText(String text) {
        }

        @Override
        public String getAsText() {
            boolean addSep = false;
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < this.value.size(); ++i) {
                if (addSep) {
                    ret.append(", ");
                }
                ret.append(this.value.get(i).toString());
                addSep = true;
            }
            return ret.toString();
        }

        @Override
        public Component getCustomEditor() {
            return new LibrariesPanel(LibrariesNodeProp.this.project, LibrariesNodeProp.this.conf, LibrariesNodeProp.this.baseDir, this.value, this, this.env);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }
}

