/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.utils.DirectoryChooserPanel;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;

public class VectorNodeProp
extends PropertySupport<List> {
    private VectorConfiguration<String> vectorConfiguration;
    private BooleanConfiguration inheritValues;
    private FSPath baseDir;
    private String[] texts;
    boolean addPathPanel;
    private HelpCtx helpCtx;

    public VectorNodeProp(VectorConfiguration<String> vectorConfiguration, BooleanConfiguration inheritValues, FSPath baseDir, String[] texts, boolean addPathPanel, HelpCtx helpCtx) {
        super(texts[0], List.class, texts[1], texts[2], true, true);
        this.vectorConfiguration = vectorConfiguration;
        this.inheritValues = inheritValues;
        this.baseDir = baseDir;
        this.texts = texts;
        this.addPathPanel = addPathPanel;
        this.helpCtx = helpCtx;
    }

    public String getHtmlDisplayName() {
        if (this.vectorConfiguration.getModified()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public List getValue() {
        return this.vectorConfiguration.getValue();
    }

    public void setValue(List v) {
        this.vectorConfiguration.setValue(v);
    }

    public void restoreDefaultValue() {
        this.vectorConfiguration.reset();
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.vectorConfiguration.getValue().isEmpty();
    }

    public PropertyEditor getPropertyEditor() {
        ArrayList<String> clone = new ArrayList<String>();
        clone.addAll(this.vectorConfiguration.getValue());
        return new DirectoriesEditor(clone);
    }

    private class DirectoriesEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private List<String> value;
        private PropertyEnv env;

        public DirectoriesEditor(List<String> value) {
            this.value = value;
        }

        @Override
        public void setAsText(String text) {
            ArrayList<String> newList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(text, File.pathSeparator);
            while (st.hasMoreTokens()) {
                newList.add(st.nextToken());
            }
            super.setValue(newList);
        }

        @Override
        public String getAsText() {
            boolean addSep = false;
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < this.value.size(); ++i) {
                if (addSep) {
                    ret.append(File.pathSeparator);
                }
                ret.append(this.value.get(i));
                addSep = true;
            }
            return ret.toString();
        }

        @Override
        public Component getCustomEditor() {
            String text = null;
            if (VectorNodeProp.this.inheritValues != null) {
                text = VectorNodeProp.this.texts[3];
            }
            return new DirectoryChooserPanel(VectorNodeProp.this.baseDir, this.value, VectorNodeProp.this.addPathPanel, VectorNodeProp.this.inheritValues, text, this, this.env, VectorNodeProp.this.helpCtx);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }
}

