/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.LoadingNode;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.RefreshableItemsContainer;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

abstract class BaseMakeViewChildren
extends Children.Keys<Object>
implements ChangeListener,
RefreshableItemsContainer {
    private static final RequestProcessor LOAD_NODES_RP = new RequestProcessor("MakeLogicalViewProvider.LoadingNodes", 10);
    private static final int WAIT_DELAY = 50;
    private Folder folder;
    protected final MakeLogicalViewProvider provider;

    public BaseMakeViewChildren(Folder folder, MakeLogicalViewProvider provider) {
        this.folder = folder;
        this.provider = provider;
    }

    protected final MakeProject getProject() {
        return this.provider.getProject();
    }

    protected boolean isRoot() {
        return false;
    }

    protected void onFolderChange(Folder folder) {
    }

    protected void addNotify() {
        if (this.provider.isFindPathMode()) {
            super.addNotify();
            this.getAddNotifyRunnable().run();
        } else if (SwingUtilities.isEventDispatchThread()) {
            super.addNotify();
            this.resetKeys(Collections.singleton(this.getWaitNode()));
            LOAD_NODES_RP.post(this.getAddNotifyRunnable(), 50);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseMakeViewChildren.this.addNotify();
                }
            });
        }
    }

    private synchronized void resetKeys(Collection<?> keysSet) {
        this.setKeys(keysSet);
    }

    private Runnable getAddNotifyRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                MakeConfigurationDescriptor mcd;
                if (BaseMakeViewChildren.this.isRoot() && BaseMakeViewChildren.this.folder == null && (mcd = BaseMakeViewChildren.this.provider.getMakeConfigurationDescriptor()) != null) {
                    BaseMakeViewChildren.this.folder = mcd.getLogicalFolders();
                    BaseMakeViewChildren.this.onFolderChange(BaseMakeViewChildren.this.folder);
                }
                if (BaseMakeViewChildren.this.folder != null) {
                    BaseMakeViewChildren.this.folder.addChangeListener(BaseMakeViewChildren.this);
                    if (BaseMakeViewChildren.this.getProject().getProjectDirectory() != null && BaseMakeViewChildren.this.getProject().getProjectDirectory().isValid()) {
                        BaseMakeViewChildren.this.resetKeys(BaseMakeViewChildren.this.getKeys());
                    }
                }
            }
        };
    }

    private Node getWaitNode() {
        return new LoadingNode();
    }

    @Override
    public void refreshItem(Item item) {
        this.refreshKey(item);
    }

    protected void removeNotify() {
        this.resetKeys(Collections.EMPTY_SET);
        if (this.folder != null) {
            this.folder.removeChangeListener(this);
        }
        super.removeNotify();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Runnable todo = null;
        if (e.getSource() instanceof Item) {
            Item[] items;
            for (final Item item : items = this.getFolder().getItemsAsArray()) {
                if (e.getSource() != item) continue;
                todo = new Runnable(){

                    @Override
                    public void run() {
                        BaseMakeViewChildren.this.refreshItem(item);
                    }
                };
                break;
            }
        } else {
            final Collection<Object> keys = this.getKeys();
            todo = new Runnable(){

                @Override
                public void run() {
                    BaseMakeViewChildren.this.resetKeys(keys);
                }
            };
        }
        if (todo != null) {
            LOAD_NODES_RP.post(todo);
        }
    }

    protected abstract Collection<Object> getKeys();

    public Folder getFolder() {
        return this.folder;
    }
}

