/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.handlers;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.components.general.ClassSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class EventHandlerSupport {
    private static final InfoPresenter.Resolver SWITCH_DISPLAYABLE_EVENT_HANDLER_INFO_RESOLVER = new SwitchDisplayableResolver();

    public static InfoPresenter.Resolver getSwitchDisplayableEventHandlerInfoResolver() {
        return SWITCH_DISPLAYABLE_EVENT_HANDLER_INFO_RESOLVER;
    }

    private static class SwitchDisplayableResolver
    implements InfoPresenter.Resolver {
        private SwitchDisplayableResolver() {
        }

        public DesignEventFilter getEventFilter(DesignComponent component) {
            return new DesignEventFilter(new DesignEventFilter[0]).addDescentFilter(component, "displayable").addDescentFilter(component, "alert");
        }

        public String getDisplayName(DesignComponent component, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    String alertName;
                    DesignComponent displayable = component.readProperty("displayable").getComponent();
                    DesignComponent alert = component.readProperty("alert").getComponent();
                    if (displayable == null) {
                        return NbBundle.getMessage(EventHandlerSupport.class, (String)"DISP_Handler_Clear_Display");
                    }
                    String displayableName = ClassSupport.resolveDisplayName(displayable);
                    String string = alertName = alert != null ? ClassSupport.resolveDisplayName(alert) : null;
                    if (alertName != null) {
                        return NbBundle.getMessage(EventHandlerSupport.class, (String)"DISP_Handler_Go_to_displayable_alert", (Object)displayableName, (Object)alertName);
                    }
                    return NbBundle.getMessage(EventHandlerSupport.class, (String)"DISP_Handler_Go_to_displayable", (Object)displayableName);
                }
                case SECONDARY: {
                    return NbBundle.getMessage(EventHandlerSupport.class, (String)"TYPE_Action");
                }
                case TERTIARY: {
                    return null;
                }
            }
            throw Debug.illegalState((Object[])new Object[0]);
        }

        public boolean isEditable(DesignComponent component) {
            return false;
        }

        public String getEditableName(DesignComponent component) {
            return null;
        }

        public void setEditableName(DesignComponent component, String enteredName) {
        }

        public Image getIcon(DesignComponent component, InfoPresenter.IconType iconType) {
            switch (iconType) {
                case COLOR_16x16: {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/components/displayable_16.png");
                }
                case COLOR_32x32: {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/components/displayable_32.png");
                }
            }
            return null;
        }
    }
}

