/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.DatabindingCategoryCD;
import org.netbeans.modules.vmd.midp.components.databinding.DataSetAbstractCD;
import org.netbeans.modules.vmd.midp.components.databinding.DataSetConnectorCD;
import org.netbeans.modules.vmd.midp.components.databinding.IndexableDataAbstractSetCD;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.components.sources.CommandEventSourceCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.openide.util.NbBundle;

public class DatabindingElementUI
extends JPanel
implements CleanUp {
    private static String NOT_DEFINED = NbBundle.getMessage(DatabindingElementUI.class, (String)"LBL_NOT_DEFINED");
    private DesignPropertyEditor propertyEditor;
    private JRadioButton radioButton;
    private static String INDEXABLE = NbBundle.getMessage(DatabindingElementUI.class, (String)"LBL_INDEXABLE");
    private static String DATASET = NbBundle.getMessage(DatabindingElementUI.class, (String)"LBL_DATASET");
    private static String CREATE_INDEX = NbBundle.getMessage(DatabindingElementUI.class, (String)"LBL_CREATE_INDEX");
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxCommandUpdate;
    private JComboBox jComboBoxCommandsIndexablePrevious;
    private JComboBox jComboBoxDatasets;
    private JComboBox jComboBoxIndexNames;
    private JComboBox jComboBoxIndexableNext;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelReadOnly;
    private JLabel jLabelWarning;
    private JLabel jLabelWarning1;
    private JLabel jLabelWarning2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldExpressionRead;
    private JTextField jTextFieldExpressionWrite;

    DatabindingElementUI(DesignPropertyEditor propertyEditor, final JRadioButton radioButton) {
        this.propertyEditor = propertyEditor;
        this.radioButton = radioButton;
        this.initComponents();
        this.jComboBoxDatasets.addActionListener(new UpdateUIListener());
        this.updateDataSetRelatedUI();
        ComponentFocusAdapter focusListener = new ComponentFocusAdapter();
        this.jTextFieldExpressionRead.addFocusListener(focusListener);
        this.jComboBoxCommandUpdate.addFocusListener(focusListener);
        this.jComboBoxDatasets.addFocusListener(focusListener);
        this.jComboBoxIndexNames.addFocusListener(focusListener);
        this.jComboBoxIndexNames.addActionListener(new UpdateUIListener());
        this.jComboBoxCommandsIndexablePrevious.addFocusListener(focusListener);
        this.jComboBoxIndexableNext.addFocusListener(focusListener);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatabindingElementUI.this.jCheckBox1.isSelected()) {
                    DatabindingElementUI.this.jTextFieldExpressionWrite.setEnabled(false);
                    DatabindingElementUI.this.jTextFieldExpressionWrite.setText(DatabindingElementUI.this.jTextFieldExpressionRead.getText());
                } else {
                    DatabindingElementUI.this.jTextFieldExpressionWrite.setEnabled(true);
                    DatabindingElementUI.this.jTextFieldExpressionWrite.setText(null);
                }
            }
        });
        this.jTextFieldExpressionRead.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DatabindingElementUI.this.updateWarning();
                if (DatabindingElementUI.this.jCheckBox1.isSelected()) {
                    DatabindingElementUI.this.jTextFieldExpressionWrite.setText(DatabindingElementUI.this.jTextFieldExpressionRead.getText());
                }
            }
        });
        TextFieldFocusListener fl = new TextFieldFocusListener();
        this.jTextFieldExpressionRead.addFocusListener(fl);
        this.jTextFieldExpressionWrite.addFocusListener(fl);
        radioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!radioButton.isSelected()) {
                    DatabindingElementUI.this.jLabelWarning.setText(null);
                    DatabindingElementUI.this.jLabelWarning2.setText(null);
                } else {
                    DatabindingElementUI.this.updateWarning();
                }
            }
        });
        this.updateIndexableUIComponents();
    }

    private boolean updateWarning() {
        if (this.radioButton.isSelected()) {
            StringBuffer warning = new StringBuffer();
            if (this.jComboBoxDatasets.getSelectedItem() == null || this.jComboBoxDatasets.getSelectedItem() == NOT_DEFINED) {
                warning.append(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_Dataset_not_Selected"));
            }
            if (this.jTextFieldExpressionRead.getText() == null || this.jTextFieldExpressionRead.getText().length() == 0) {
                if (warning.length() != 0) {
                    warning.append(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_WARNING_and_"));
                }
                warning.append(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_WARNING_Empty_expression"));
            }
            if (warning.length() != 0) {
                this.jLabelWarning.setText(warning.toString());
                this.jLabelWarning1.setText(warning.toString());
                this.jLabelWarning2.setText(warning.toString());
                return false;
            }
            this.jLabelWarning.setText(null);
            this.jLabelWarning1.setText(null);
            this.jLabelWarning2.setText(null);
        } else {
            this.jLabelWarning.setText(null);
            this.jLabelWarning1.setText(null);
            this.jLabelWarning2.setText(null);
        }
        return true;
    }

    private void updateDataSetRelatedUI() {
        if (this.jComboBoxDatasets.getSelectedItem() != null && this.jComboBoxDatasets.getSelectedItem() != NOT_DEFINED) {
            this.jTextFieldExpressionRead.setEnabled(true);
            if (this.jTextFieldExpressionRead.getText().equals(this.jTextFieldExpressionWrite.getText())) {
                this.jCheckBox1.setSelected(true);
                this.jTextFieldExpressionWrite.setEnabled(false);
            } else {
                this.jCheckBox1.setSelected(false);
                this.jTextFieldExpressionWrite.setEnabled(true);
            }
            this.jComboBoxCommandUpdate.setEnabled(true);
        } else {
            this.jCheckBox1.setEnabled(true);
            this.jCheckBox1.setSelected(true);
            this.jTextFieldExpressionWrite.setEnabled(false);
            this.jTextFieldExpressionRead.setEnabled(false);
            this.jComboBoxCommandUpdate.setEnabled(false);
        }
        if (!(this.jComboBoxDatasets.getModel() instanceof Model)) {
            return;
        }
        Model model = (Model)this.jComboBoxDatasets.getModel();
        if (model.isSelectedDataSetReadOnly() != null) {
            if (model.isSelectedDataSetReadOnly().booleanValue()) {
                this.jLabelReadOnly.setText(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_WARNINGRead_Only"));
            } else {
                this.jLabelReadOnly.setText(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_WARNING_Read/Write"));
            }
        } else {
            this.jLabelReadOnly.setText(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_WARNING_Not_Defined"));
        }
        if (this.jComboBoxIndexNames.getSelectedItem() == null || this.jComboBoxIndexNames.getSelectedItem() == NOT_DEFINED) {
            this.jComboBoxCommandsIndexablePrevious.setEnabled(false);
            this.jComboBoxIndexableNext.setEnabled(false);
        } else {
            this.jComboBoxCommandsIndexablePrevious.setEnabled(true);
            this.jComboBoxIndexableNext.setEnabled(true);
        }
    }

    @Override
    public void clean(DesignComponent component) {
        this.propertyEditor = null;
        this.radioButton = null;
        this.jCheckBox1 = null;
        this.jComboBoxCommandUpdate = null;
        this.jComboBoxCommandsIndexablePrevious = null;
        this.jComboBoxDatasets = null;
        this.jComboBoxIndexNames = null;
        this.jComboBoxIndexableNext = null;
        this.jLabel1 = null;
        this.jLabel2 = null;
        this.jLabel3 = null;
        this.jLabel4 = null;
        this.jLabel5 = null;
        this.jLabel6 = null;
        this.jLabel7 = null;
        this.jLabel8 = null;
        this.jLabel9 = null;
        this.jLabelReadOnly = null;
        this.jLabelWarning = null;
        this.jLabelWarning1 = null;
        this.jLabelWarning2 = null;
        this.jPanel1 = null;
        this.jPanel2 = null;
        this.jPanel3 = null;
        this.jPanel4 = null;
        this.jPanel5 = null;
        this.jTabbedPane1 = null;
        this.jTextFieldExpressionRead = null;
        this.jTextFieldExpressionWrite = null;
        this.removeAll();
    }

    private void updateIndexableUIComponents() {
        String name = (String)this.jComboBoxDatasets.getSelectedItem();
        if (name != null && name.contains(INDEXABLE)) {
            this.jComboBoxCommandsIndexablePrevious.setEnabled(true);
            this.jComboBoxIndexableNext.setEnabled(true);
            this.jComboBoxIndexNames.setEnabled(true);
        } else if (name != null && name.contains(DATASET) || name != null && name.equals(NOT_DEFINED)) {
            this.jComboBoxCommandsIndexablePrevious.setEnabled(false);
            this.jComboBoxCommandsIndexablePrevious.setSelectedItem(NOT_DEFINED);
            this.jComboBoxIndexableNext.setEnabled(false);
            this.jComboBoxIndexableNext.setSelectedItem(NOT_DEFINED);
            this.jComboBoxIndexNames.setEnabled(false);
            this.jComboBoxIndexNames.setSelectedItem(NOT_DEFINED);
        }
        if (this.jComboBoxIndexNames.getSelectedItem() == null || this.jComboBoxIndexNames.getSelectedItem() == NOT_DEFINED) {
            this.jComboBoxCommandsIndexablePrevious.setEnabled(false);
            this.jComboBoxIndexableNext.setEnabled(false);
        } else {
            this.jComboBoxCommandsIndexablePrevious.setEnabled(true);
            this.jComboBoxIndexableNext.setEnabled(true);
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBoxDatasets = new JComboBox();
        this.jTextFieldExpressionRead = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabelReadOnly = new JLabel();
        this.jLabelWarning = new JLabel();
        this.jComboBoxIndexNames = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxCommandUpdate = new JComboBox();
        this.jTextFieldExpressionWrite = new JTextField();
        this.jLabel9 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabelWarning2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jComboBoxIndexableNext = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jComboBoxCommandsIndexablePrevious = new JComboBox();
        this.jLabelWarning1 = new JLabel();
        this.setMaximumSize(new Dimension(0, 0));
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(355, 225));
        this.jTabbedPane1.setMinimumSize(new Dimension(0, 0));
        this.jTabbedPane1.setPreferredSize(new Dimension(0, 0));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jPanel1.border.title")));
        this.jPanel1.setFocusable(false);
        this.jLabel1.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel1.text"));
        this.jLabel1.setPreferredSize(new Dimension(68, 16));
        this.jLabel2.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel2.text"));
        this.jTextFieldExpressionRead.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jTextFieldExpressionRead.text"));
        this.jTextFieldExpressionRead.setEnabled(false);
        this.jLabel4.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel4.text_1"));
        this.jLabelReadOnly.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabelReadOnly.text"));
        this.jLabelWarning.setForeground(new Color(255, 0, 0));
        this.jLabelWarning.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabelWarning.text_1"));
        this.jLabelWarning.setVerticalAlignment(3);
        this.jComboBoxIndexNames.setEnabled(false);
        this.jLabel3.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel3.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelWarning, -1, 328, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelReadOnly, -1, 90, Short.MAX_VALUE).addGap(170, 170, 170)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxDatasets, 0, 246, Short.MAX_VALUE).addComponent(this.jComboBoxIndexNames, 0, 246, Short.MAX_VALUE).addComponent(this.jTextFieldExpressionRead, -1, 246, Short.MAX_VALUE)).addGap(14, 14, 14)))));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jComboBoxDatasets, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBoxIndexNames, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldExpressionRead, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabelReadOnly)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 46, Short.MAX_VALUE).addComponent(this.jLabelWarning)));
        this.jComboBoxDatasets.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCN_DatabindingDataSets"));
        this.jComboBoxDatasets.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCD_DatabindingDataSets"));
        this.jTextFieldExpressionRead.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCN_DatabindingELRead"));
        this.jTextFieldExpressionRead.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCD_DatabindingELRead"));
        this.jComboBoxIndexNames.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCN_DatabindingIndex"));
        this.jComboBoxIndexNames.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCD_DatabindingIndex"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jPanel1.TabConstraints.tabTitle"), this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jPanel2.border.title")));
        this.jPanel2.setFocusable(false);
        this.jLabel8.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel8.text"));
        this.jLabel5.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel5.text"));
        this.jTextFieldExpressionWrite.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jTextFieldExpressionWrite.text"));
        this.jTextFieldExpressionWrite.setEnabled(false);
        this.jLabel9.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel9.text"));
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jCheckBox1.text"));
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabindingElementUI.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jLabelWarning2.setForeground(new Color(255, 0, 0));
        this.jLabelWarning2.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabelWarning2.text"));
        this.jLabelWarning2.setVerticalAlignment(3);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -2, 69, Short.MAX_VALUE)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(262, 262, 262).addComponent(this.jLabel8, -1, 9, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1, -1, 247, Short.MAX_VALUE).addComponent(this.jTextFieldExpressionWrite, -1, 247, Short.MAX_VALUE).addComponent(this.jComboBoxCommandUpdate, 0, 247, Short.MAX_VALUE)).addContainerGap()))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabelWarning2, -1, 328, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.linkSize(0, this.jLabel5, this.jLabel9);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jComboBoxCommandUpdate, -2, -1, -2)).addGap(5, 5, 5).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextFieldExpressionWrite, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 67, Short.MAX_VALUE).addComponent(this.jLabelWarning2)));
        this.jComboBoxCommandUpdate.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCN_DatabindingCommand"));
        this.jComboBoxCommandUpdate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCD_DatabindingCommand"));
        this.jTextFieldExpressionWrite.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCN_DatabindingELWrite"));
        this.jTextFieldExpressionWrite.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCD_DatabindingELWrite"));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jPanel5.TabConstraints.tabTitle"), this.jPanel5);
        this.jPanel4.setPreferredSize(new Dimension(0, 0));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jPanel3.border.title")));
        this.jPanel3.setFocusable(false);
        this.jPanel3.setMinimumSize(new Dimension(0, 0));
        this.jPanel3.setPreferredSize(new Dimension(0, 0));
        this.jLabel6.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel6.text"));
        this.jLabel6.setPreferredSize(new Dimension(68, 16));
        this.jComboBoxIndexableNext.setEnabled(false);
        this.jLabel7.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabel7.text"));
        this.jComboBoxCommandsIndexablePrevious.setEnabled(false);
        this.jLabelWarning1.setForeground(new Color(255, 0, 0));
        this.jLabelWarning1.setText(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jLabelWarning1.text"));
        this.jLabelWarning1.setVerticalAlignment(3);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelWarning1, -1, 328, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxCommandsIndexablePrevious, 0, 248, Short.MAX_VALUE).addComponent(this.jComboBoxIndexableNext, 0, 248, Short.MAX_VALUE)))).addContainerGap()));
        jPanel3Layout.linkSize(0, this.jLabel6, this.jLabel7);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.jComboBoxIndexableNext, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jComboBoxCommandsIndexablePrevious, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 86, Short.MAX_VALUE).addComponent(this.jLabelWarning1)));
        this.jComboBoxIndexableNext.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCN_DatabindingNext"));
        this.jComboBoxIndexableNext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCD_DatabindingNext"));
        this.jComboBoxCommandsIndexablePrevious.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCN_DatabindingPrevious"));
        this.jComboBoxCommandsIndexablePrevious.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCD_DatabindingPrevious"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, 350, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, 186, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(DatabindingElementUI.class, (String)"DatabindingElementUI.jPanel4.TabConstraints.tabTitle"), this.jPanel4);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 355, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 213, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCN_DatabindingPane"));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabindingElementUI.class, (String)"ASCD_DatabindingPane"));
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
    }

    public void updateComponent(final DesignComponent component) {
        if (component == null) {
            return;
        }
        DesignDocument document = component.getDocument();
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DatabindingElementUI.this.jComboBoxDatasets.setModel(new Model(component, DatabindingCategoryCD.TYPEID));
                DatabindingElementUI.this.jComboBoxCommandUpdate.setModel(new Model(component, CommandsCategoryCD.TYPEID));
                DatabindingElementUI.this.jComboBoxCommandsIndexablePrevious.setModel(new Model(component, CommandsCategoryCD.TYPEID));
                DatabindingElementUI.this.jComboBoxIndexableNext.setModel(new Model(component, CommandsCategoryCD.TYPEID));
                Model indexNamesModel = new Model(component);
                DatabindingElementUI.this.jComboBoxIndexNames.setModel(indexNamesModel);
                indexNamesModel.addListDataListener(new Listener());
                DesignComponent connector = MidpDatabindingSupport.getConnector(component, (String)DatabindingElementUI.this.propertyEditor.getPropertyNames().get(0));
                if (connector != null) {
                    DatabindingElementUI.this.radioButton.setSelected(true);
                    String dataSetName = DatabindingElementUI.createDataSetName((String)connector.getParentComponent().readProperty("instanceName").getPrimitiveValue(), connector.getParentComponent());
                    DatabindingElementUI.this.jComboBoxDatasets.setSelectedItem(dataSetName);
                    String readExpression = (String)connector.readProperty("expressionRead").getPrimitiveValue();
                    String writeExpression = (String)connector.readProperty("expressionWrite").getPrimitiveValue();
                    DatabindingElementUI.this.jTextFieldExpressionRead.setText(readExpression);
                    DatabindingElementUI.this.jTextFieldExpressionWrite.setText(writeExpression);
                    DatabindingElementUI.this.jComboBoxIndexNames.setSelectedItem(MidpDatabindingSupport.getIndexName(connector));
                    DatabindingElementUI.this.setCommandComboBox(connector, DatabindingElementUI.this.jComboBoxCommandUpdate, "updateCommand");
                    DatabindingElementUI.this.setCommandComboBox(connector, DatabindingElementUI.this.jComboBoxIndexableNext, "nextCommand");
                    DatabindingElementUI.this.setCommandComboBox(connector, DatabindingElementUI.this.jComboBoxCommandsIndexablePrevious, "previousCommand");
                    DatabindingElementUI.this.setReadOnlyLabel(connector);
                } else {
                    DatabindingElementUI.this.jComboBoxCommandUpdate.setSelectedItem(NOT_DEFINED);
                    DatabindingElementUI.this.jComboBoxCommandsIndexablePrevious.setSelectedItem(NOT_DEFINED);
                    DatabindingElementUI.this.jComboBoxDatasets.setSelectedItem(NOT_DEFINED);
                    DatabindingElementUI.this.jComboBoxIndexNames.setSelectedItem(NOT_DEFINED);
                    DatabindingElementUI.this.jComboBoxIndexableNext.setSelectedItem(NOT_DEFINED);
                }
            }
        });
        this.updateDataSetRelatedUI();
        this.updateIndexableUIComponents();
        this.updateWarning();
    }

    private void setReadOnlyLabel(DesignComponent connector) {
        PropertyValue value = connector.getParentComponent().readProperty("readOnly");
        if (value != PropertyValue.createNull() && value.getPrimitiveValue() == Boolean.TRUE) {
            this.jLabelReadOnly.setText(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_WARNING_Read_Only"));
        } else {
            this.jLabelReadOnly.setText(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_WARNING_Read/Write"));
        }
    }

    private void setCommandComboBox(DesignComponent connector, JComboBox comboBox, String propertyName) {
        DesignComponent command = connector.readProperty(propertyName).getComponent();
        if (command != null) {
            String commandName = (String)command.readProperty("instanceName").getPrimitiveValue();
            comboBox.setSelectedItem(commandName);
        }
    }

    public void saveToModel(final DesignComponent component) {
        final DesignDocument document = component.getDocument();
        if (!this.updateWarning()) {
            return;
        }
        document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                String selectedDataSet = DatabindingElementUI.cleanUpDataSetName((String)DatabindingElementUI.this.jComboBoxDatasets.getSelectedItem());
                String selectedUpdateCommand = (String)DatabindingElementUI.this.jComboBoxCommandUpdate.getSelectedItem();
                String selectedNextCommand = (String)DatabindingElementUI.this.jComboBoxIndexableNext.getSelectedItem();
                String selectedPreviousCommand = (String)DatabindingElementUI.this.jComboBoxCommandsIndexablePrevious.getSelectedItem();
                Collection dataSets = MidpDocumentSupport.getCategoryComponent(document, DatabindingCategoryCD.TYPEID).getComponents();
                MidpDatabindingSupport.removeUnusedConnector(component, (String)DatabindingElementUI.this.propertyEditor.getPropertyNames().get(0));
                for (DesignComponent dataSet : dataSets) {
                    if (!dataSet.readProperty("instanceName").getPrimitiveValue().equals(selectedDataSet)) continue;
                    DesignComponent connector = MidpDatabindingSupport.getConnector(component, (String)DatabindingElementUI.this.propertyEditor.getPropertyNames().get(0));
                    if (connector == null) {
                        connector = document.createComponent(DataSetConnectorCD.TYPEID);
                        connector.writeProperty("property", MidpTypes.createStringValue((String)DatabindingElementUI.this.propertyEditor.getPropertyNames().get(0)));
                        dataSet.addComponent(connector);
                    }
                    if (DatabindingElementUI.this.jComboBoxIndexNames.getSelectedItem() != null && !DatabindingElementUI.this.jComboBoxIndexNames.getSelectedItem().equals(NOT_DEFINED)) {
                        if (MidpDatabindingSupport.isIndexableDataSet(document, dataSet.getType())) {
                            String indexName = (String)DatabindingElementUI.this.jComboBoxIndexNames.getSelectedItem();
                            DesignComponent index = MidpDatabindingSupport.getIndex(dataSet, indexName);
                            if (index == null) {
                                index = MidpDatabindingSupport.createIndex(dataSet, indexName);
                            }
                            connector.writeProperty("index", PropertyValue.createComponentReference((DesignComponent)index));
                        }
                    } else {
                        connector.writeProperty("index", PropertyValue.createNull());
                    }
                    connector.writeProperty("referencedComponent", MidpTypes.createLongValue(component.getComponentID()));
                    connector.writeProperty("expressionRead", MidpTypes.createStringValue(DatabindingElementUI.this.jTextFieldExpressionRead.getText().trim()));
                    connector.writeProperty("expressionWrite", MidpTypes.createStringValue(DatabindingElementUI.this.jTextFieldExpressionWrite.getText().trim()));
                    DatabindingElementUI.this.saveCommands(document, connector, selectedUpdateCommand, "updateCommand");
                    DatabindingElementUI.this.saveCommands(document, connector, selectedNextCommand, "nextCommand");
                    DatabindingElementUI.this.saveCommands(document, connector, selectedPreviousCommand, "previousCommand");
                    MidpDatabindingSupport.removerUnusedIndexes(document);
                    component.resetToDefault((String)DatabindingElementUI.this.propertyEditor.getPropertyNames().get(0));
                    break;
                }
            }
        });
    }

    private void saveCommands(DesignDocument document, DesignComponent connector, String commandName, String propertyName) {
        assert (document != null || connector != null || propertyName != null);
        Collection commands = MidpDocumentSupport.getCategoryComponent(document, CommandsCategoryCD.TYPEID).getComponents();
        for (DesignComponent command : commands) {
            PropertyValue value = command.readProperty("instanceName");
            if (value == PropertyValue.createNull() || !value.getPrimitiveValue().equals(commandName)) continue;
            connector.writeProperty(propertyName, PropertyValue.createComponentReference((DesignComponent)command));
            break;
        }
    }

    public void resetValuesInModel(final DesignComponent component) {
        component.getDocument().getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                MidpDatabindingSupport.removeUnusedConnector(component, (String)DatabindingElementUI.this.propertyEditor.getPropertyNames().get(0));
            }
        });
        this.jComboBoxCommandUpdate.setSelectedItem(null);
        this.jComboBoxDatasets.setSelectedItem(null);
        this.jComboBoxCommandsIndexablePrevious.setSelectedItem(null);
        this.jComboBoxIndexableNext.setSelectedItem(null);
        this.jTextFieldExpressionRead.setText(null);
        this.jTextFieldExpressionRead.setEnabled(false);
        this.jTextFieldExpressionWrite.setText(null);
        this.jTextFieldExpressionWrite.setEnabled(false);
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setEnabled(false);
        this.jLabelReadOnly.setText(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/propertyeditors/Bundle").getString("LBL_WARNING_Not_defined"));
        this.jComboBoxIndexNames.setSelectedItem(null);
        this.updateWarning();
        this.updateIndexableUIComponents();
    }

    private static String createDataSetName(String name, DesignComponent c) {
        DescriptorRegistry registry = c.getDocument().getDescriptorRegistry();
        if (registry.isInHierarchy(IndexableDataAbstractSetCD.TYPEID, c.getType())) {
            name = name + " " + INDEXABLE;
        } else if (registry.isInHierarchy(DataSetAbstractCD.TYPEID, c.getType())) {
            name = name + " " + DATASET;
        }
        return name;
    }

    private static String cleanUpDataSetName(String name) {
        if (name != null) {
            name = name.replace(INDEXABLE, "").replace(DATASET, "").trim();
        }
        return name;
    }

    private class TextFieldFocusListener
    extends FocusAdapter {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            DatabindingElementUI.this.jTextFieldExpressionRead.setText(DatabindingElementUI.this.jTextFieldExpressionRead.getText().trim());
            DatabindingElementUI.this.jTextFieldExpressionWrite.setText(DatabindingElementUI.this.jTextFieldExpressionWrite.getText().trim());
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            DatabindingElementUI.this.jTextFieldExpressionRead.setText(DatabindingElementUI.this.jTextFieldExpressionRead.getText().trim());
            DatabindingElementUI.this.jTextFieldExpressionWrite.setText(DatabindingElementUI.this.jTextFieldExpressionWrite.getText().trim());
        }
    }

    private class UpdateUIListener
    implements ActionListener {
        private UpdateUIListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatabindingElementUI.this.updateDataSetRelatedUI();
            DatabindingElementUI.this.updateWarning();
            DatabindingElementUI.this.updateIndexableUIComponents();
        }
    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            String name = "index";
            List<String> names = ((Model)DatabindingElementUI.this.jComboBoxIndexNames.getModel()).getItems();
            names.remove(CREATE_INDEX);
            names.remove(NOT_DEFINED);
            int i = 0;
            while (names.contains(name)) {
                name = name + i++;
            }
            names.add(name);
            names.add(NOT_DEFINED);
            names.add(CREATE_INDEX);
            Model indexNamesModel = new Model(names);
            DatabindingElementUI.this.jComboBoxIndexNames.setModel(indexNamesModel);
            indexNamesModel.addListDataListener(new Listener());
            DatabindingElementUI.this.jComboBoxIndexNames.setSelectedItem(name);
        }
    }

    private class ComponentFocusAdapter
    extends FocusAdapter {
        private ComponentFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            DatabindingElementUI.this.radioButton.setSelected(true);
        }
    }

    private class Model
    implements ComboBoxModel {
        private final List<String> names;
        private String selectedItem;
        private TypeID categoryType;
        private ListDataListener lisener;
        private Map<String, Boolean> dataSetWriteCapability;

        Model(DesignComponent component) {
            Collection<DesignComponent> connectors = MidpDatabindingSupport.getAllConnectors(component.getDocument());
            this.names = new ArrayList<String>();
            for (DesignComponent connector : connectors) {
                DesignComponent index = connector.readProperty("index").getComponent();
                String indexName = MidpDatabindingSupport.getIndexName(connector);
                if (index == null || this.names.contains(indexName)) continue;
                this.names.add(indexName);
            }
            this.names.add(NOT_DEFINED);
            this.names.add(CREATE_INDEX);
        }

        Model(List<String> items) {
            this.names = items;
        }

        Model(DesignComponent component, TypeID categoryType) {
            this.categoryType = categoryType;
            this.names = new ArrayList<String>();
            this.names.add(NOT_DEFINED);
            Collection components = MidpDocumentSupport.getCategoryComponent(component.getDocument(), categoryType).getComponents();
            for (DesignComponent component_ : components) {
                String name = (String)component_.readProperty("instanceName").getPrimitiveValue();
                if (name == null || name.trim().equals("")) continue;
                DescriptorRegistry registry = component_.getDocument().getDescriptorRegistry();
                name = DatabindingElementUI.createDataSetName(name, component_);
                if (registry.isInHierarchy(IndexableDataAbstractSetCD.TYPEID, component_.getType())) {
                    PropertyValue value;
                    if (this.dataSetWriteCapability == null) {
                        this.dataSetWriteCapability = new HashMap<String, Boolean>();
                    }
                    if ((value = component_.readProperty("readOnly")) != PropertyValue.createNull() && value.getPrimitiveValue().equals(Boolean.TRUE)) {
                        this.dataSetWriteCapability.put(name, Boolean.TRUE);
                    } else {
                        this.dataSetWriteCapability.put(name, Boolean.FALSE);
                    }
                }
                if (categoryType == CommandsCategoryCD.TYPEID) {
                    HashSet<String> activeCommands = new HashSet<String>();
                    List eventSources = DocumentSupport.gatherAllComponentsOfTypeID((DesignDocument)component.getDocument(), (TypeID)CommandEventSourceCD.TYPEID);
                    for (DesignComponent event : eventSources) {
                        if (event.readProperty("command").getComponent() != component_) continue;
                        activeCommands.add((String)component_.readProperty("instanceName").getPrimitiveValue());
                    }
                    this.names.addAll(activeCommands);
                    continue;
                }
                this.names.add(name);
            }
        }

        @Override
        public void setSelectedItem(Object item) {
            if (item == null) {
                this.selectedItem = NOT_DEFINED;
            } else if (item.equals(CREATE_INDEX)) {
                this.lisener.contentsChanged(new ListDataEvent(this, 0, -1, -1));
            } else {
                this.selectedItem = (String)item;
            }
        }

        public Boolean isSelectedDataSetReadOnly() {
            if (this.dataSetWriteCapability == null) {
                return null;
            }
            Boolean readOnly = this.dataSetWriteCapability.get(this.selectedItem);
            if (readOnly != null) {
                return readOnly;
            }
            return null;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.names.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.names.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            if (listener instanceof Listener) {
                this.lisener = listener;
            }
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this.lisener = null;
        }

        public List<String> getItems() {
            return this.names;
        }
    }
}

