/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.usercode;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public final class CodeUtils {
    private CodeUtils() {
    }

    public static int getMethodOffset(DataObjectContext context) {
        final int[] offset = new int[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)context.getDataObject().getPrimaryFile());
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    CompilationUnitTree unitTree = compilationController.getCompilationUnit();
                    List types = compilationController.getTopLevelElements();
                    if (types.size() > 0) {
                        TypeElement type = (TypeElement)types.get(0);
                        List<ExecutableElement> methods = ElementFilter.methodsIn(type.getEnclosedElements());
                        for (ExecutableElement method : methods) {
                            BlockTree tree;
                            MethodTree methodTree;
                            if (method.getModifiers().contains((Object)Modifier.STATIC) || (methodTree = compilationController.getTrees().getTree(method)).getKind() != Tree.Kind.METHOD || (tree = methodTree.getBody()) == null) continue;
                            offset[0] = (int)compilationController.getTrees().getSourcePositions().getStartPosition(unitTree, tree) + 1;
                            break;
                        }
                    }
                }
            }, true);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return offset[0];
    }
}

