/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.resource.elements;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.resources.TickerCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TickerEditorElement
extends PropertyEditorResourceElement
implements DocumentListener,
CleanUp {
    private long componentID;
    private boolean doNotFireEvent;
    private JLabel tickerLabel;
    private JTextField tickerTextField;

    public TickerEditorElement() {
        this.initComponents();
        this.tickerTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public void clean(DesignComponent component) {
        this.tickerLabel = null;
        this.tickerTextField = null;
        this.removeAll();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public TypeID getTypeID() {
        return TickerCD.TYPEID;
    }

    @Override
    public List<String> getPropertyValueNames() {
        return Arrays.asList("string");
    }

    @Override
    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper wrapper) {
        if (wrapper == null) {
            this.setText(null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = wrapper.getComponentID();
        final String[] _tickerText = new String[1];
        final DesignComponent component = wrapper.getComponent();
        if (component != null) {
            if (!component.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + component.getType());
            }
            this.componentID = component.getComponentID();
            component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue propertyValue = component.readProperty("string");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue)) {
                        _tickerText[0] = MidpTypes.getString(propertyValue);
                    }
                }
            });
        }
        if (wrapper.hasChanges()) {
            Map<String, PropertyValue> changes = wrapper.getChanges();
            for (String propertyName : changes.keySet()) {
                PropertyValue propertyValue = changes.get(propertyName);
                if (!"string".equals(propertyName)) continue;
                _tickerText[0] = MidpTypes.getString(propertyValue);
            }
        }
        this.setAllEnabled(true);
        this.setText(_tickerText[0]);
    }

    private synchronized void setText(String text) {
        this.doNotFireEvent = true;
        this.tickerTextField.setText(text);
        this.doNotFireEvent = false;
    }

    private void setAllEnabled(boolean isEnabled) {
        this.tickerLabel.setEnabled(isEnabled);
        this.tickerTextField.setEnabled(isEnabled);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.tickerTextField.hasFocus()) {
            this.textChanged();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.tickerTextField.hasFocus()) {
            this.textChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private synchronized void textChanged() {
        if (!this.doNotFireEvent) {
            this.fireElementChanged(this.componentID, "string", MidpTypes.createStringValue(this.tickerTextField.getText()));
        }
    }

    private void initComponents() {
        this.tickerLabel = new JLabel();
        this.tickerTextField = new JTextField();
        this.tickerLabel.setLabelFor(this.tickerTextField);
        Mnemonics.setLocalizedText((JLabel)this.tickerLabel, (String)NbBundle.getMessage(TickerEditorElement.class, (String)"TickerEditorElement.tickerLabel.text"));
        this.tickerLabel.setEnabled(false);
        this.tickerTextField.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.tickerLabel).addContainerGap()).addComponent(this.tickerTextField, -1, 320, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tickerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tickerTextField, -2, -1, -2).addContainerGap(110, Short.MAX_VALUE)));
        this.tickerTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TickerEditorElement.class, (String)"ACSN_Ticker"));
        this.tickerTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TickerEditorElement.class, (String)"ACSD_Ticker"));
    }
}

