/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.io.File;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public class Utils {
    private static RequestProcessor parallelRP;

    public static RequestProcessor.Task createParallelTask(Runnable runnable) {
        RequestProcessor rp = Utils.getParallelRequestProcessor();
        return rp.create(runnable);
    }

    public static RequestProcessor.Task postParallel(Runnable runnable) {
        RequestProcessor rp = Utils.getParallelRequestProcessor();
        return rp.post(runnable);
    }

    public static void openFile(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                OpenCookie oc = (OpenCookie)dao.getCookie(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private static RequestProcessor getParallelRequestProcessor() {
        if (parallelRP == null) {
            parallelRP = new RequestProcessor("Diff.ParallelTasks", 5);
        }
        return parallelRP;
    }

    private Utils() {
    }
}

