/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.options;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.netbeans.modules.diff.options.CategoryRenderer;
import org.netbeans.modules.diff.options.ColorComboBox;
import org.netbeans.modules.diff.options.DiffOptionsPanel;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.spi.FontsColorsController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DiffColorsPanel
extends JPanel
implements ActionListener,
FontsColorsController,
PropertyChangeListener {
    private static final String ATTR_NAME_ADDED = "added";
    private static final String ATTR_NAME_DELETED = "deleted";
    private static final String ATTR_NAME_CHANGED = "changed";
    private static final String ATTR_NAME_MERGE_UNRESOLVED = "merge.unresolved";
    private static final String ATTR_NAME_MERGE_APPLIED = "merge.applied";
    private static final String ATTR_NAME_MERGE_NOTAPPLIED = "merge.notapplied";
    private static final String ATTR_NAME_SIDEBAR_DELETED = "sidebar.deleted";
    private static final String ATTR_NAME_SIDEBAR_CHANGED = "sidebar.changed";
    private boolean listen;
    private List<AttributeSet> categories;
    private boolean changed;
    private JComboBox cbBackground;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JList lCategories;

    public DiffColorsPanel() {
        this.initComponents();
        this.setName(DiffColorsPanel.loc("LBL_DiffOptions_Tab"));
        ColorComboBox.init(this.cbBackground);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(6);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!DiffColorsPanel.this.listen) {
                    return;
                }
                DiffColorsPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.cbBackground.addActionListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getPropertyName() == "color") {
            this.updateData();
            this.changed = true;
        }
    }

    public void update(ColorModel colorModel) {
        this.listen = false;
        this.lCategories.setListData(new Vector<AttributeSet>(this.getCategories()));
        this.lCategories.setSelectedIndex(0);
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    public void cancel() {
        this.changed = false;
    }

    public void applyChanges() {
        List<AttributeSet> colors = this.getCategories();
        for (AttributeSet color : colors) {
            if (ATTR_NAME_ADDED.equals(color.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setAddedColor((Color)color.getAttribute(StyleConstants.Background));
            }
            if (ATTR_NAME_CHANGED.equals(color.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setChangedColor((Color)color.getAttribute(StyleConstants.Background));
            }
            if (ATTR_NAME_DELETED.equals(color.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setDeletedColor((Color)color.getAttribute(StyleConstants.Background));
            }
            if (ATTR_NAME_MERGE_APPLIED.equals(color.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setAppliedColor((Color)color.getAttribute(StyleConstants.Background));
            }
            if (ATTR_NAME_MERGE_NOTAPPLIED.equals(color.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setNotAppliedColor((Color)color.getAttribute(StyleConstants.Background));
            }
            if (ATTR_NAME_MERGE_UNRESOLVED.equals(color.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setUnresolvedColor((Color)color.getAttribute(StyleConstants.Background));
            }
            if (ATTR_NAME_SIDEBAR_DELETED.equals(color.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setSidebarDeletedColor((Color)color.getAttribute(StyleConstants.Background));
            }
            if (!ATTR_NAME_SIDEBAR_CHANGED.equals(color.getAttribute(StyleConstants.NameAttribute))) continue;
            DiffModuleConfig.getDefault().setSidebarChangedColor((Color)color.getAttribute(StyleConstants.Background));
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setCurrentProfile(String currentProfile) {
        this.refreshUI();
    }

    public void deleteProfile(String profile) {
    }

    public JComponent getComponent() {
        return this;
    }

    Collection<AttributeSet> getHighlightings() {
        return this.getCategories();
    }

    private static String loc(String key) {
        return NbBundle.getMessage(DiffColorsPanel.class, (String)key);
    }

    private void updateData() {
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            return;
        }
        List<AttributeSet> categories = this.getCategories();
        AttributeSet category = categories.get(this.lCategories.getSelectedIndex());
        SimpleAttributeSet c = new SimpleAttributeSet(category);
        Color color = ColorComboBox.getColor(this.cbBackground);
        if (color != null) {
            c.addAttribute(StyleConstants.Background, color);
        } else {
            c.removeAttribute(StyleConstants.Background);
        }
        categories.set(index, c);
    }

    private void refreshUI() {
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            this.cbBackground.setEnabled(false);
            return;
        }
        this.cbBackground.setEnabled(true);
        List<AttributeSet> categories = this.getCategories();
        AttributeSet category = categories.get(index);
        this.listen = false;
        ColorComboBox.setColor(this.cbBackground, (Color)category.getAttribute(StyleConstants.Background));
        this.listen = true;
    }

    private List<AttributeSet> getCategories() {
        if (this.categories == null) {
            this.categories = this.getDiffHighlights();
        }
        return this.categories;
    }

    private List<AttributeSet> getDiffHighlights() {
        ArrayList<AttributeSet> attrs = new ArrayList<AttributeSet>();
        SimpleAttributeSet sas = null;
        sas = new SimpleAttributeSet();
        StyleConstants.setBackground(sas, DiffModuleConfig.getDefault().getAddedColor());
        sas.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_ADDED);
        sas.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_AddedColor"));
        attrs.add(sas);
        sas = new SimpleAttributeSet();
        StyleConstants.setBackground(sas, DiffModuleConfig.getDefault().getDeletedColor());
        sas.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_DELETED);
        sas.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_DeletedColor"));
        attrs.add(sas);
        sas = new SimpleAttributeSet();
        StyleConstants.setBackground(sas, DiffModuleConfig.getDefault().getChangedColor());
        sas.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_CHANGED);
        sas.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_ChangedColor"));
        attrs.add(sas);
        sas = new SimpleAttributeSet();
        StyleConstants.setBackground(sas, DiffModuleConfig.getDefault().getAppliedColor());
        sas.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_MERGE_APPLIED);
        sas.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_AppliedColor"));
        attrs.add(sas);
        sas = new SimpleAttributeSet();
        StyleConstants.setBackground(sas, DiffModuleConfig.getDefault().getNotAppliedColor());
        sas.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_MERGE_NOTAPPLIED);
        sas.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_NotAppliedColor"));
        attrs.add(sas);
        sas = new SimpleAttributeSet();
        StyleConstants.setBackground(sas, DiffModuleConfig.getDefault().getUnresolvedColor());
        sas.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_MERGE_UNRESOLVED);
        sas.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_UnresolvedColor"));
        attrs.add(sas);
        sas = new SimpleAttributeSet();
        StyleConstants.setBackground(sas, DiffModuleConfig.getDefault().getSidebarDeletedColor());
        sas.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_SIDEBAR_DELETED);
        sas.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_SidebarDeletedColor"));
        attrs.add(sas);
        sas = new SimpleAttributeSet();
        StyleConstants.setBackground(sas, DiffModuleConfig.getDefault().getSidebarChangedColor());
        sas.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_SIDEBAR_CHANGED);
        sas.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_SidebarChangedColor"));
        attrs.add(sas);
        return attrs;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lCategories = new JList();
        this.jLabel3 = new JLabel();
        this.cbBackground = new JComboBox();
        this.jLabel1.setLabelFor(this.lCategories);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DiffColorsPanel.class, (String)"DiffColorsPanel.jLabel1.text"));
        this.lCategories.setModel(new DefaultListModel());
        this.jScrollPane1.setViewportView(this.lCategories);
        this.jLabel3.setLabelFor(this.cbBackground);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DiffColorsPanel.class, (String)"DiffColorsPanel.jLabel3.text"));
        this.cbBackground.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 344, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBackground, -2, 215, -2)).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbBackground, -2, -1, -2).addComponent(this.jLabel3)).addComponent(this.jScrollPane1, -1, 382, Short.MAX_VALUE)).addContainerGap()));
    }
}

