/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public final class NbRepository
extends Repository {
    static final String CONFIG_FOLDER = "config";

    public NbRepository() {
        super(NbRepository.createDefaultFileSystem());
    }

    private static FileSystem createDefaultFileSystem() {
        Exception exc;
        String ud;
        String systemDir = System.getProperty("system.dir");
        if (systemDir != null) {
            try {
                return SessionManager.getDefault().create(new File(systemDir), null, new File[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new InternalError();
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
                throw new InternalError();
            }
        }
        File u = null;
        File h = null;
        ArrayList<File> extradirs = new ArrayList<File>();
        String homeDir = CLIOptions.getHomeDir();
        if (homeDir != null) {
            File homeDirFile = new File(CLIOptions.getHomeDir());
            if (!homeDirFile.exists()) {
                System.err.println(NbBundle.getMessage(NbRepository.class, (String)"CTL_Netbeanshome_notexists"));
                NbRepository.doExit(2);
            }
            if (!homeDirFile.isDirectory()) {
                System.err.println(NbBundle.getMessage(NbRepository.class, (String)"CTL_Netbeanshome1"));
                NbRepository.doExit(3);
            }
            h = new File(homeDirFile, CONFIG_FOLDER);
            String nbdirs = System.getProperty("netbeans.dirs");
            if (nbdirs != null) {
                StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    File f = new File(tok.nextToken(), CONFIG_FOLDER);
                    if (!f.isDirectory()) continue;
                    extradirs.add(f);
                }
            }
        }
        if (!(ud = CLIOptions.getUserDir()).equals("memory")) {
            File userDirFile = new File(ud);
            if (!userDirFile.exists()) {
                System.err.println(NbBundle.getMessage(NbRepository.class, (String)"CTL_Netbeanshome2"));
                NbRepository.doExit(4);
            }
            if (!userDirFile.isDirectory()) {
                System.err.println(NbBundle.getMessage(NbRepository.class, (String)"CTL_Netbeanshome3"));
                NbRepository.doExit(5);
            }
            u = new File(userDirFile, CONFIG_FOLDER);
        }
        try {
            return SessionManager.getDefault().create(u, h, extradirs.toArray(new File[extradirs.size()]));
        }
        catch (IOException ex) {
            exc = ex;
        }
        catch (PropertyVetoException ex) {
            exc = ex;
        }
        catch (RuntimeException ex) {
            exc = ex;
        }
        exc.printStackTrace();
        System.err.println(NbBundle.getMessage(NbRepository.class, (String)"CTL_Cannot_mount_system_fs"));
        NbRepository.doExit(3);
        return null;
    }

    private static void doExit(int value) {
        TopLogging.exit(value);
    }

    static {
        Main.initializeURLFactory();
    }
}

