/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptor;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptorFactory;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Lookup;

final class PrimitiveDescriptorFactoryRegistry {
    private static final Lookup.Result<PrimitiveDescriptorFactory> factoriesLookupResult = Lookup.getDefault().lookupResult(PrimitiveDescriptorFactory.class);

    PrimitiveDescriptorFactoryRegistry() {
    }

    static PrimitiveDescriptor getDescriptor(String projectType, TypeID type) {
        assert (Debug.isFriend(PropertyValue.class));
        assert (type.getKind() == TypeID.Kind.PRIMITIVE);
        assert (type.getDimension() == 0);
        for (PrimitiveDescriptorFactory factory : factoriesLookupResult.allInstances()) {
            PrimitiveDescriptor descriptor;
            if (projectType == null || !projectType.equals(factory.getProjectType()) || (descriptor = factory.getDescriptorForTypeIDString(type.getString())) == null) continue;
            return descriptor;
        }
        Debug.warning("No PrimitiveDescriptorFactory found", type);
        return null;
    }
}

