/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Content;
import org.apache.felix.framework.resolver.HostedCapability;
import org.apache.felix.framework.resolver.HostedRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HostModule
implements Module {
    private final Module m_host;
    private final List<Module> m_fragments;
    private List<Capability> m_cachedCapabilities = null;
    private List<Requirement> m_cachedRequirements = null;

    public HostModule(Module module, List<Module> fragments) {
        this.m_host = module;
        this.m_fragments = fragments;
    }

    public Module getHost() {
        return this.m_host;
    }

    public List<Module> getFragments() {
        return this.m_fragments;
    }

    @Override
    public String getId() {
        return this.m_host.getId();
    }

    @Override
    public List<Capability> getCapabilities() {
        if (this.m_cachedCapabilities == null) {
            ArrayList<HostedCapability> capList = new ArrayList<HostedCapability>();
            List<Capability> caps = this.m_host.getCapabilities();
            for (int capIdx = 0; caps != null && capIdx < caps.size(); ++capIdx) {
                capList.add(new HostedCapability(this, caps.get(capIdx)));
            }
            for (int fragIdx = 0; this.m_fragments != null && fragIdx < this.m_fragments.size(); ++fragIdx) {
                caps = this.m_fragments.get(fragIdx).getCapabilities();
                for (int capIdx = 0; caps != null && capIdx < caps.size(); ++capIdx) {
                    if (!caps.get(capIdx).getNamespace().equals("package")) continue;
                    capList.add(new HostedCapability(this, caps.get(capIdx)));
                }
            }
            this.m_cachedCapabilities = Collections.unmodifiableList(capList);
        }
        return this.m_cachedCapabilities;
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.m_cachedRequirements == null) {
            ArrayList<HostedRequirement> reqList = new ArrayList<HostedRequirement>();
            List<Requirement> reqs = this.m_host.getRequirements();
            for (int reqIdx = 0; reqs != null && reqIdx < reqs.size(); ++reqIdx) {
                reqList.add(new HostedRequirement(this, reqs.get(reqIdx)));
            }
            for (int fragIdx = 0; this.m_fragments != null && fragIdx < this.m_fragments.size(); ++fragIdx) {
                reqs = this.m_fragments.get(fragIdx).getRequirements();
                for (int reqIdx = 0; reqs != null && reqIdx < reqs.size(); ++reqIdx) {
                    if (!reqs.get(reqIdx).getNamespace().equals("package") && !reqs.get(reqIdx).getNamespace().equals("module")) continue;
                    reqList.add(new HostedRequirement(this, reqs.get(reqIdx)));
                }
            }
            this.m_cachedRequirements = Collections.unmodifiableList(reqList);
        }
        return this.m_cachedRequirements;
    }

    public String toString() {
        return this.m_host.getId();
    }

    @Override
    public Map getHeaders() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isExtension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSymbolicName() {
        return this.m_host.getSymbolicName();
    }

    @Override
    public Version getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Requirement> getDynamicRequirements() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<R4Library> getNativeLibraries() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getDeclaredActivationPolicy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Bundle getBundle() {
        return this.m_host.getBundle();
    }

    @Override
    public List<Wire> getWires() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public Object getSecurityContext() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isRemovalPending() {
        return this.m_host.isRemovalPending();
    }

    @Override
    public Content getContent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Class getClassByDelegation(String name) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URL getResourceByDelegation(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Enumeration getResourcesByDelegation(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URL getEntry(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasInputStream(int index, String urlPath) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream getInputStream(int index, String urlPath) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URL getLocalURL(int index, String urlPath) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

