/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.nodes;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ActionProducer;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.explorer.view.Visualizer;

public class Node {
    static final String linkSuffix = Bundle.getString("org.openide.loaders.Bundle", "FMT_shadowName", (Object[])new String[]{""});
    protected JTreeOperator treeOperator;
    protected TreePath treePath;
    protected String stringPath;
    private Operator.StringComparator comparator;

    public Node(JTreeOperator treeOperator, String treePath) {
        this(treeOperator, new NodesJTreeOperator(treeOperator).findPath(treePath, "|"));
    }

    public Node(JTreeOperator treeOperator, String treePath, String indexes) {
        this(treeOperator, new NodesJTreeOperator(treeOperator).findPath(treePath, indexes, "|"));
    }

    public Node(Node parent, String treeSubPath) {
        this(parent.tree(), parent.findSubPath(treeSubPath, "|"));
    }

    public Node(Node parent, int childIndex) {
        this(parent.tree(), parent.tree().getChildPath(parent.getTreePath(), childIndex));
    }

    public Node(JTreeOperator treeOperator, TreePath path) {
        this.treeOperator = treeOperator.getClass().getName().endsWith("JTreeOperator") ? new NodesJTreeOperator(treeOperator) : treeOperator;
        this.treePath = path;
        this.stringPath = Node.convertPath(path);
    }

    public void setComparator(Operator.StringComparator comparator) {
        this.comparator = comparator;
        this.tree().setComparator(comparator);
    }

    public Operator.StringComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = this.tree().getComparator();
        }
        return this.comparator;
    }

    public JTreeOperator tree() {
        return this.treeOperator;
    }

    public TreePath getTreePath() {
        if (this.treePath.getLastPathComponent().toString().isEmpty() || this.tree().getRowForPath(this.treePath) < 0) {
            this.treePath = this.tree().findPath(this.stringPath);
        }
        return this.treePath;
    }

    public String getText() {
        return this.getTreePath().getLastPathComponent().toString();
    }

    private static String convertPath(TreePath path) {
        if (path == null) {
            return null;
        }
        int pathCount = path.getPathCount();
        if (pathCount < 2) {
            return "";
        }
        StringBuilder bufResult = new StringBuilder(path.getPathComponent(1).toString());
        for (int i = 2; i < pathCount; ++i) {
            bufResult.append("|").append(path.getPathComponent(i).toString());
        }
        return bufResult.toString();
    }

    public String getPath() {
        return Node.convertPath(this.getTreePath());
    }

    public String getParentPath() {
        return Node.convertPath(this.getTreePath().getParentPath());
    }

    public Object getOpenideNode() {
        return Visualizer.findNode((Object)this.getTreePath().getLastPathComponent());
    }

    public JPopupMenuOperator callPopup() {
        return new JPopupMenuOperator(this.treeOperator.callPopupOnPath(this.getTreePath()));
    }

    public void performMenuAction(String menuPath) {
        new org.netbeans.jellytools.actions.Action(menuPath, null).performMenu(this);
    }

    public void performPopupAction(String popupPath) {
        new org.netbeans.jellytools.actions.Action(null, popupPath).performPopup(this);
    }

    public void performAPIAction(String systemActionClass) {
        new org.netbeans.jellytools.actions.Action(null, null, systemActionClass).performAPI(this);
    }

    public void performMenuActionNoBlock(String menuPath) {
        new ActionNoBlock(menuPath, null).performMenu(this);
    }

    public void performPopupActionNoBlock(String popupPath) {
        new ActionNoBlock(null, popupPath).performPopup(this);
    }

    public void performAPIActionNoBlock(String systemActionClass) {
        new ActionNoBlock(null, null, systemActionClass).performAPI(this);
    }

    public void select() {
        this.tree().selectPath(this.getTreePath());
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                throw new JemmyException("Sleeping interrupted", (Throwable)e);
            }
            this.tree().clickOnPath(this.getTreePath());
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void addSelectionPath() {
        this.tree().addSelectionPath(this.getTreePath());
    }

    public boolean isLeaf() {
        return this.tree().getChildCount(this.getTreePath()) < 1;
    }

    public String[] getChildren() {
        this.tree().expandPath(this.getTreePath());
        Object[] o = this.tree().getChildren(this.getTreePath().getLastPathComponent());
        if (o == null) {
            return new String[0];
        }
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = o[i].toString();
        }
        return s;
    }

    public boolean isLink() {
        return this.getText().endsWith(linkSuffix);
    }

    public boolean isPresent() {
        this.tree().expandPath(this.treePath.getParentPath());
        int row = this.tree().getRowForPath(this.treePath);
        if (row < 0) {
            return false;
        }
        return this.treePath.equals(this.tree().getPathForRow(row));
    }

    public void verifyPopup(String popupPath) {
        this.verifyPopup(new String[]{popupPath});
    }

    public void verifyPopup(String[] popupPaths) {
        final JPopupMenuOperator popup = this.callPopup();
        for (int i = 0; i < popupPaths.length; ++i) {
            try {
                popup.showMenuItem(popupPaths[i], "|");
                continue;
            }
            catch (NullPointerException npe) {
                throw new JemmyException("Popup path [" + popupPaths[i] + "] not found.");
            }
        }
        popup.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                popup.pushKey(27);
                return !popup.isVisible();
            }

            public String getDescription() {
                return "Popup menu closed";
            }
        });
    }

    TreePath findSubPath(String subPath, String delimiter) {
        return this.findSubPath(subPath, "", delimiter);
    }

    TreePath findSubPath(String subPath, String indexes, String delimiter) {
        TreePath foundTreePath;
        String[] indexStr = this.tree().parseString(indexes, delimiter);
        int[] indexInt = new int[indexStr.length];
        for (int i = 0; i < indexStr.length; ++i) {
            indexInt[i] = Integer.parseInt(indexStr[i]);
        }
        try {
            foundTreePath = this.tree().findPath((JTreeOperator.TreePathChooser)new StringArraySubPathChooser(this.getTreePath(), this.tree().parseString(subPath, delimiter), indexInt, this.getComparator()));
        }
        catch (JTreeOperator.NoSuchPathException e) {
            foundTreePath = this.tree().findPath((JTreeOperator.TreePathChooser)new StringArraySubPathChooser(this.getTreePath(), this.tree().parseString(subPath, delimiter), indexInt, this.getComparator()));
        }
        return foundTreePath;
    }

    public void expand() {
        this.treeOperator.expandPath(this.getTreePath());
        this.waitExpanded();
    }

    public void collapse() {
        this.treeOperator.collapsePath(this.getTreePath());
        this.waitCollapsed();
    }

    public void waitExpanded() {
        this.treeOperator.waitExpanded(this.getTreePath());
    }

    public void waitCollapsed() {
        this.treeOperator.waitCollapsed(this.getTreePath());
    }

    public boolean isExpanded() {
        return this.treeOperator.isExpanded(this.getTreePath());
    }

    public boolean isCollapsed() {
        return this.treeOperator.isCollapsed(this.getTreePath());
    }

    public void verifyPopup(org.netbeans.jellytools.actions.Action[] actions) {
        ArrayList<String> popupPaths = new ArrayList<String>();
        for (int i = 0; i < actions.length; ++i) {
            String path = actions[i].getPopupPath();
            if (path == null) continue;
            popupPaths.add(path);
        }
        this.verifyPopup(popupPaths.toArray(new String[popupPaths.size()]));
    }

    public boolean isChildPresent(String childName) {
        String[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!this.getComparator().equals(children[i], childName)) continue;
            return true;
        }
        return false;
    }

    public void waitChildNotPresent(final String childName) {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object anObject) {
                    return Node.this.isChildPresent(childName) ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Child \"" + childName + "\" not present under parent \"" + Node.this.getPath() + "\"";
                }
            }).waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    public void waitNotPresent() {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object anObject) {
                    return Node.this.isPresent() ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Wait node " + Node.convertPath(Node.this.treePath) + " not present.";
                }
            }).waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    static {
        JellyVersion.checkJemmyVersion();
    }

    private static class NodesJTreeOperator
    extends JTreeOperator {
        public NodesJTreeOperator(JTreeOperator origOperator) {
            super((JTree)origOperator.getSource());
            this.copyEnvironment((Operator)origOperator);
        }

        public void expandPath(final TreePath treePath) {
            super.expandPath(treePath);
            try {
                ActionProducer actionProducer = new ActionProducer(new Action(){

                    public Object launch(Object obj) {
                        try {
                            Visualizer.findNode((Object)treePath.getLastPathComponent()).getChildren().getNodes(true);
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        return null;
                    }

                    public String getDescription() {
                        return "org.openide.nodes.Node.getChildren().getNodes(true)";
                    }
                });
                actionProducer.getTimeouts().setTimeout("ActionProducer.MaxActionTime", this.getTimeouts().getTimeout("JTreeOperator.WaitNodeVisibleTimeout"));
                actionProducer.produceAction(null);
            }
            catch (InterruptedException e) {
                throw new JemmyException("Interrupted.", (Throwable)e);
            }
            catch (TimeoutExpiredException tee) {
                for (org.openide.nodes.Node n : Visualizer.findNode((Object)treePath.getLastPathComponent()).getChildren().getNodes()) {
                    this.getOutput().printLine("    " + n.getDisplayName() + "  " + n);
                }
            }
        }
    }

    static class StringArraySubPathChooser
    implements JTreeOperator.TreePathChooser {
        String[] arr;
        int[] indices;
        Operator.StringComparator comparator;
        TreePath parentPath;
        int parentPathCount;

        StringArraySubPathChooser(TreePath parentPath, String[] arr, int[] indices, Operator.StringComparator comparator) {
            this.arr = arr;
            this.comparator = comparator;
            this.indices = indices;
            this.parentPath = parentPath;
            this.parentPathCount = parentPath.getPathCount();
        }

        public boolean checkPath(TreePath path, int indexInParent) {
            return path.getPathCount() == this.arr.length + this.parentPathCount && this.hasAsParent(path, indexInParent);
        }

        public boolean hasAsParent(TreePath path, int indexInParent) {
            if (path.getPathCount() <= this.parentPathCount) {
                return path.isDescendant(this.parentPath);
            }
            if (this.arr.length + this.parentPathCount < path.getPathCount()) {
                return false;
            }
            if (this.indices.length >= path.getPathCount() - this.parentPathCount && this.indices[path.getPathCount() - this.parentPathCount - 1] != indexInParent) {
                return false;
            }
            Object[] comps = path.getPath();
            for (int i = this.parentPathCount; i < comps.length; ++i) {
                if (this.comparator.equals(comps[i].toString(), this.arr[i - this.parentPathCount])) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            int i;
            StringBuilder bufDesc = new StringBuilder();
            Object[] parr = this.parentPath.getPath();
            for (i = 0; i < parr.length; ++i) {
                bufDesc.append(parr[i].toString()).append(", ");
            }
            for (i = 0; i < this.arr.length; ++i) {
                bufDesc.append(this.arr[i]).append(", ");
            }
            String desc = bufDesc.toString();
            if (desc.length() > 0) {
                desc = desc.substring(0, desc.length() - 2);
            }
            return "[ " + desc + " ]";
        }
    }
}

