/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wizard.XMLContentAttributes;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class XMLGeneratorVisitor
extends DeepAXITreeVisitor {
    private static final Logger LOG = Logger.getLogger(XMLGeneratorVisitor.class.getName());
    private XMLContentAttributes contentAttr;
    private String elemPrefix = "";
    private String attrPrefix = "";
    private String defaultPrefix;
    private AXIModel axiModel;
    private int depth = 0;
    private String schemaFileName;
    private Element rElement;
    private StringBuffer writer;
    private String primaryTNS;
    Map<String, String> namespaceToPrefix;
    private int counter = 1;
    private static final String PREFIX = "ns";
    private boolean qualifiedElem;
    private Stack<String> nestingStack = new Stack();
    private Set<String> machineIncluded = new HashSet<String>();
    private boolean parentSkippable;
    private boolean blockExpansion;

    public XMLGeneratorVisitor(String schemaFileName, XMLContentAttributes attr, StringBuffer writer) {
        this.contentAttr = attr;
        this.defaultPrefix = this.contentAttr.getPrefix();
        if (this.defaultPrefix == null) {
            this.defaultPrefix = "";
        }
        this.defaultPrefix = this.defaultPrefix + (this.defaultPrefix.trim().length() < 1 ? "" : ":");
        this.schemaFileName = schemaFileName;
        this.writer = writer;
        this.namespaceToPrefix = this.contentAttr.getNamespaceToPrefixMap();
    }

    public void generateXML(String rootElement, SchemaModel model) {
        if (model.getSchema().getAttributeFormDefaultEffective().equals((Object)Form.QUALIFIED)) {
            this.attrPrefix = this.defaultPrefix;
        }
        if (model.getSchema().getElementFormDefaultEffective().equals((Object)Form.QUALIFIED)) {
            this.elemPrefix = this.defaultPrefix;
        }
        this.axiModel = AXIModelFactory.getDefault().getModel(model);
        this.rElement = this.findAXIGlobalElement(rootElement);
        this.primaryTNS = this.rElement.getTargetNamespace();
        if (this.rElement != null) {
            this.visit(this.rElement);
        }
        this.contentAttr.setNamespaceToPrefixMap(this.namespaceToPrefix);
    }

    public void generateXML(String rootElement) {
        if (rootElement == null || this.schemaFileName == null || this.schemaFileName.equals("") || rootElement.equals("")) {
            return;
        }
        File f = new File(this.schemaFileName);
        FileObject fObj = FileUtil.toFileObject((File)(f = FileUtil.normalizeFile((File)f)));
        if (fObj == null) {
            return;
        }
        ModelSource ms = null;
        try {
            ms = Utilities.createModelSource((FileObject)fObj, (boolean)true);
        }
        catch (Exception e) {
            return;
        }
        if (ms == null) {
            return;
        }
        SchemaModel model = SchemaModelFactory.getDefault().getModel(ms);
        this.generateXML(rootElement, model);
    }

    public void generateXML(Element element) {
        if (element != null) {
            this.visit(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Element element) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Processing: " + this.getTab() + element);
        }
        int occurs = this.getOccurence(element, element.getMinOccurs(), element.getMaxOccurs());
        if (!this.contentAttr.generateOptionalElements() && this.isElementOptional(element)) {
            return;
        }
        String elementId = this.getElementId((AXIComponent)element);
        this.nestingStack.add(elementId);
        try {
            for (int i = 0; i < occurs; ++i) {
                this.visitChildren((AXIComponent)element);
            }
        }
        finally {
            this.nestingStack.remove(elementId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitChildren(AXIComponent component) {
        boolean saveBlockExpansion = this.blockExpansion;
        boolean saveSkippable = this.parentSkippable;
        try {
            this.parentSkippable = false;
            this.printModel(component);
            ++this.depth;
            this.visitChildrenForXML(component);
            this.postVisitChildren(component);
        }
        catch (Exception e) {
        }
        finally {
            this.parentSkippable = saveSkippable;
            this.blockExpansion = saveBlockExpansion;
            --this.depth;
        }
    }

    private boolean isElementOptional(Element element) {
        int i = Integer.parseInt(element.getMinOccurs());
        return i == 0;
    }

    private void printModel(AXIComponent component) throws IOException {
        StringBuffer buffer = new StringBuffer();
        boolean newLine = true;
        if (component.getChildElements().isEmpty()) {
            newLine = false;
        }
        if (component instanceof Compositor) {
            Compositor compositor = (Compositor)component;
            buffer.append(this.getTab() == null ? compositor : this.getTab() + compositor);
            buffer.append("<min=" + compositor.getMinOccurs() + ":max=" + compositor.getMaxOccurs() + ">");
            return;
        }
        if (component instanceof Element) {
            Element element = (Element)component;
            String prefix = this.setPrefixForElement(element);
            if (element.equals(this.rElement)) {
                int i;
                if (element.getAttributes().size() != 0 && (i = this.writer.lastIndexOf("\n")) != -1) {
                    this.writer = this.writer.insert(i - 1, " " + this.getAttributes(element));
                }
                return;
            }
            buffer.append(this.getTab() == null ? element.getName() : this.getTab() + "<" + prefix + element.getName());
            if (element.getAttributes().size() != 0) {
                buffer.append(" " + this.getAttributes(element));
            }
            if (newLine) {
                this.writer.append(buffer.toString() + ">" + "\n");
            } else {
                this.writer.append(buffer.toString() + ">");
            }
            this.writer.append(this.getComponentValue((AXIComponent)element));
        }
    }

    private String getAttributes(Element element) {
        StringBuffer attrs = new StringBuffer();
        for (AbstractAttribute attr : element.getAttributes()) {
            String lprefix = this.attrPrefix;
            if (this.isGlobal((AXIComponent)attr)) {
                lprefix = this.contentAttr.getPrefix() + ":";
            }
            if (attr instanceof Attribute && !this.contentAttr.generateOptionalAttributes()) {
                if (!((Attribute)attr).getUse().equals((Object)Attribute.Use.REQUIRED)) continue;
                attrs.append(lprefix + attr + "=\"" + this.getComponentValue((AXIComponent)((Attribute)attr)) + "\" ");
                continue;
            }
            if (attr instanceof Attribute) {
                attrs.append(lprefix + attr + "=\"" + this.getComponentValue((AXIComponent)((Attribute)attr)) + "\" ");
                continue;
            }
            attrs.append(attr + "= \" \" ");
        }
        if (attrs.length() > 0) {
            return attrs.toString().substring(0, attrs.length() - 1);
        }
        return attrs.toString();
    }

    private String getTab() {
        String tabStr = "    ";
        if (this.depth == 0) {
            return null;
        }
        StringBuffer tab = new StringBuffer();
        for (int i = 0; i < this.depth; ++i) {
            tab.append(tabStr);
        }
        return tab.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitChildrenForXML(AXIComponent component) {
        if (!super.canVisit(component)) {
            return;
        }
        if (component instanceof Compositor) {
            Compositor.CompositorType type = ((Compositor)component).getType();
            String minOccurs = ((Compositor)component).getMinOccurs();
            boolean canSkip = this.parentSkippable;
            boolean saveSkippable = this.parentSkippable;
            if (minOccurs != null) {
                boolean bl = canSkip = this.parentSkippable || Integer.parseInt(minOccurs) == 0;
            }
            if (type.equals((Object)Compositor.CompositorType.CHOICE)) {
                List children = component.getChildren();
                if (children != null) {
                    for (AXIComponent axiCo : children) {
                        String id = this.getElementId(axiCo);
                        if (id == null || !this.nestingStack.contains(id) && !this.machineIncluded.contains(id)) {
                            if (canSkip) {
                                this.machineIncluded.add(id);
                            }
                            this.parentSkippable = canSkip;
                            try {
                                axiCo.accept((AXIVisitor)this);
                                break;
                            }
                            finally {
                                this.parentSkippable = saveSkippable;
                            }
                        }
                        if (!canSkip) continue;
                        break;
                    }
                }
                return;
            }
        }
        for (AXIComponent child : component.getChildren()) {
            child.accept((AXIVisitor)this);
        }
    }

    private String getElementId(AXIComponent co) {
        if (!(co instanceof Element)) {
            return null;
        }
        Element e = (Element)co;
        String ns = e.getTargetNamespace();
        if (ns == null) {
            return e.getName();
        }
        return ns + ":" + e.getName();
    }

    private int getOccurence(Element el, String minOccurs, String maxOccurs) {
        boolean minimize;
        int min = Integer.parseInt(minOccurs);
        String elementId = this.getElementId((AXIComponent)el);
        boolean nestedIn = this.nestingStack.contains(elementId);
        boolean alreadyIncluded = this.machineIncluded.contains(elementId);
        boolean bl = minimize = nestedIn || alreadyIncluded || this.blockExpansion;
        if (minimize && min == 0) {
            return 0;
        }
        if (maxOccurs.equals("unbounded")) {
            if (minimize) {
                return min;
            }
            this.machineIncluded.add(this.getElementId((AXIComponent)el));
            return this.contentAttr.getPreferredOccurences();
        }
        int max = Integer.parseInt(maxOccurs);
        if (this.contentAttr.getPreferredOccurences() > min && this.contentAttr.getPreferredOccurences() < max) {
            this.blockExpansion = true;
            if (min == 0) {
                this.machineIncluded.add(this.getElementId((AXIComponent)el));
            }
            return this.contentAttr.getPreferredOccurences();
        }
        if (this.contentAttr.getPreferredOccurences() > max) {
            return max;
        }
        if (this.contentAttr.getPreferredOccurences() < min) {
            return min;
        }
        return min;
    }

    private void postVisitChildren(AXIComponent component) throws IOException {
        if (component instanceof Element) {
            if (((Element)component).equals(this.rElement)) {
                return;
            }
            String prefix = this.setPrefixForElement((Element)component);
            if (component.getChildElements().isEmpty()) {
                this.writer.append("</" + prefix + ((Element)component).getName() + ">" + "\n");
            } else {
                this.writer.append(this.getTab() + "</" + prefix + ((Element)component).getName() + ">" + "\n");
            }
        }
    }

    private Element findAXIGlobalElement(String name) {
        if (name == null) {
            return null;
        }
        for (Element e : this.axiModel.getRoot().getElements()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    private String getComponentValue(AXIComponent component) {
        Element element;
        String value = null;
        if (component instanceof Attribute) {
            Attribute attribute = (Attribute)component;
            value = attribute.getFixed();
            if (value == null) {
                value = attribute.getDefault();
            }
        } else if (component instanceof Element && (value = (element = (Element)component).getFixed()) == null) {
            value = element.getDefault();
        }
        if (value != null) {
            return value;
        }
        return "";
    }

    private String generatePrefix() {
        String generatedName = PREFIX + this.counter++;
        while (this.namespaceToPrefix.containsValue(generatedName)) {
            generatedName = PREFIX + this.counter++;
        }
        return generatedName;
    }

    private String setPrefixForElement(Element element) {
        String prefix = this.elemPrefix;
        String ns = element.isReference() ? element.getReferent().getTargetNamespace() : element.getTargetNamespace();
        if (ns == null) {
            return prefix;
        }
        if (!ns.equals(this.primaryTNS)) {
            String pre;
            if (this.namespaceToPrefix == null) {
                this.namespaceToPrefix = new HashMap<String, String>();
            }
            if ((pre = this.namespaceToPrefix.get(ns)) == null || pre.equals("")) {
                pre = this.generatePrefix();
                this.namespaceToPrefix.put(ns, pre);
            }
            prefix = pre + ":";
            return prefix;
        }
        if (this.isGlobal((AXIComponent)element)) {
            return this.defaultPrefix;
        }
        return prefix;
    }

    private boolean isGlobal(AXIComponent component) {
        AXIComponent original = component.getOriginal();
        if (original.getComponentType() == AXIComponent.ComponentType.REFERENCE) {
            return true;
        }
        return original.isGlobal();
    }
}

