/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.BlankDebugEventListener;
import org.antlr.runtime.tree.Tree;
import org.netbeans.modules.css.lib.AbstractParseTreeNode;
import org.netbeans.modules.css.lib.CommonTokenUtil;
import org.netbeans.modules.css.lib.ErrorNode;
import org.netbeans.modules.css.lib.RootNode;
import org.netbeans.modules.css.lib.RuleNode;
import org.netbeans.modules.css.lib.TokenNode;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.ProblemDescription;
import org.openide.util.NbBundle;

public class NbParseTreeBuilder
extends BlankDebugEventListener {
    private String[] IGNORED_RULES = new String[]{"syncToFollow", "syncTo_IDENT_RBRACE"};
    Stack<RuleNode> callStack = new Stack();
    List<CommonToken> hiddenTokens = new ArrayList<CommonToken>();
    private int backtracking = 0;
    private CommonToken lastConsumedToken;
    private CharSequence source;
    static boolean debug_tokens = false;
    private Stack<ErrorNode> errorNodes = new Stack();
    private boolean resync;
    private CommonToken unexpectedToken;
    private Map<CommonToken, Pair<Node>> noViableAltNodes = new HashMap<CommonToken, Pair<Node>>();
    private Collection<RuleNode> leafRuleNodes = new ArrayList<RuleNode>();

    public NbParseTreeBuilder(CharSequence source) {
        this.source = source;
        this.callStack.push(new RootNode(source));
    }

    public AbstractParseTreeNode getTree() {
        return (AbstractParseTreeNode)this.callStack.elementAt(0);
    }

    public void enterDecision(int d, boolean couldBacktrack) {
        ++this.backtracking;
    }

    public void exitDecision(int i) {
        --this.backtracking;
    }

    private boolean isIgnoredRule(String ruleName) {
        return Arrays.binarySearch(this.IGNORED_RULES, ruleName) >= 0;
    }

    public void enterRule(String filename, String ruleName) {
        if (this.backtracking > 0) {
            return;
        }
        if (this.isIgnoredRule(ruleName)) {
            return;
        }
        AbstractParseTreeNode parentRuleNode = this.callStack.peek();
        RuleNode ruleNode = new RuleNode(NodeType.valueOf(ruleName), this.source);
        this.addNodeChild(parentRuleNode, ruleNode);
        this.callStack.push(ruleNode);
    }

    public void exitRule(String filename, String ruleName) {
        if (this.backtracking > 0) {
            return;
        }
        if (this.isIgnoredRule(ruleName)) {
            return;
        }
        RuleNode ruleNode = this.callStack.pop();
        if (ruleNode.getChildCount() > 0) {
            if (this.lastConsumedToken != null) {
                ruleNode.setLastToken(this.lastConsumedToken);
            }
        } else {
            this.leafRuleNodes.add(ruleNode);
        }
    }

    public void beginResync() {
        super.beginResync();
        this.resync = true;
    }

    public void endResync() {
        super.endResync();
        this.resync = false;
    }

    public void consumeToken(Token token) {
        if (this.backtracking > 0 || this.resync) {
            return;
        }
        if (debug_tokens) {
            CommonToken ct = (CommonToken)token;
            int[] ctr = CommonTokenUtil.getCommonTokenOffsetRange(ct);
            System.out.println(token + "(" + ctr[0] + "-" + ctr[1] + ")");
        }
        if (token.getType() == -1) {
            return;
        }
        if (token.getType() == 0) {
            return;
        }
        this.lastConsumedToken = (CommonToken)token;
        RuleNode ruleNode = this.callStack.peek();
        TokenNode elementNode = new TokenNode((CommonToken)token);
        elementNode.hiddenTokens = this.hiddenTokens;
        this.hiddenTokens.clear();
        ruleNode.addChild((Tree)elementNode);
        this.updateFirstTokens(ruleNode, this.lastConsumedToken);
    }

    private void updateFirstTokens(RuleNode ruleNode, CommonToken token) {
        while (ruleNode.from() == -1) {
            ruleNode.setFirstToken(token);
            if ((ruleNode = (RuleNode)ruleNode.getParent()) != null) continue;
            break;
        }
    }

    public void consumeHiddenToken(Token token) {
        if (this.backtracking > 0 || this.resync) {
            return;
        }
        if (debug_tokens) {
            CommonToken ct = (CommonToken)token;
            int[] ctr = CommonTokenUtil.getCommonTokenOffsetRange(ct);
            System.out.println(token + "(" + ctr[0] + "-" + ctr[1] + ")");
        }
        this.hiddenTokens.add((CommonToken)token);
    }

    public void recognitionException(RecognitionException e) {
        int from;
        int to;
        if (this.backtracking > 0) {
            return;
        }
        RuleNode ruleNode = this.callStack.peek();
        assert (e.token != null);
        this.unexpectedToken = (CommonToken)e.token;
        int unexpectedTokenCode = e.getUnexpectedType();
        CssTokenId unexpectedTokenId = CssTokenId.forTokenTypeCode(unexpectedTokenCode);
        assert (unexpectedTokenId != null) : "No CssTokenId for " + this.unexpectedToken;
        if (unexpectedTokenId == CssTokenId.EOF) {
            from = to = CommonTokenUtil.getCommonTokenOffsetRange(this.unexpectedToken)[0];
        } else {
            from = CommonTokenUtil.getCommonTokenOffsetRange(this.unexpectedToken)[0];
            to = CommonTokenUtil.getCommonTokenOffsetRange(this.unexpectedToken)[1];
        }
        String message = unexpectedTokenId == CssTokenId.EOF ? NbBundle.getMessage(NbParseTreeBuilder.class, (String)"MSG_Error_Premature_EOF") : NbBundle.getMessage(NbParseTreeBuilder.class, (String)"MSG_Error_Unexpected_Token", (Object)unexpectedTokenId.name());
        ProblemDescription problemDescription = new ProblemDescription(from, to, message, ProblemDescription.Keys.PARSING.name(), ProblemDescription.Type.ERROR);
        ErrorNode errorNode = new ErrorNode(from, to, problemDescription, this.source);
        TokenNode tokenNode = new TokenNode(this.unexpectedToken);
        this.addNodeChild(errorNode, tokenNode);
        if (e instanceof NoViableAltException) {
            this.noViableAltNodes.put(this.unexpectedToken, new Pair<ErrorNode>((ErrorNode)ruleNode, errorNode));
            this.errorNodes.push(errorNode);
        } else {
            this.addNodeChild(ruleNode, errorNode);
            this.errorNodes.push(errorNode);
            this.lastConsumedToken = new CommonToken(0);
            this.lastConsumedToken.setStartIndex(from);
            this.lastConsumedToken.setStopIndex(to - 1);
        }
    }

    public void terminate() {
        super.terminate();
        for (Pair<Node> pair : this.noViableAltNodes.values()) {
            RuleNode ruleNode = (RuleNode)pair.n1;
            ErrorNode errorNode = (ErrorNode)pair.n2;
            ruleNode.addChild((Tree)errorNode);
            errorNode.setParent((Tree)ruleNode);
        }
        for (ErrorNode en : this.errorNodes) {
            this.synchronizeAncestorsBoundaries(en);
        }
        for (RuleNode node : this.leafRuleNodes) {
            this.removeLeafRuleNodes(node);
        }
    }

    private void removeLeafRuleNodes(RuleNode node) {
        while (node.children().isEmpty()) {
            RuleNode parent = (RuleNode)node.parent();
            if (parent == null) {
                return;
            }
            parent.deleteChild(node);
            node = parent;
        }
    }

    private void synchronizeAncestorsBoundaries(RuleNode en) {
        for (RuleNode n = en; n != null; n = (RuleNode)n.parent()) {
            if (n.from() == -1 || n.from() > en.from()) {
                n.from = en.from();
            }
            if (n.to() != -1 && n.to() >= en.to()) continue;
            n.to = en.to();
        }
    }

    public Collection<ProblemDescription> getProblems() {
        LinkedHashSet<ProblemDescription> problems = new LinkedHashSet<ProblemDescription>();
        for (ErrorNode errorNode : this.errorNodes) {
            problems.add(errorNode.getProblemDescription());
        }
        return problems;
    }

    void consumeSkippedTokens(List<Token> tokens) {
        int i;
        boolean ignoreFirstToken;
        if (tokens.isEmpty()) {
            return;
        }
        CommonToken first = (CommonToken)tokens.get(0);
        CommonToken last = (CommonToken)tokens.get(tokens.size() - 1);
        boolean bl = ignoreFirstToken = this.unexpectedToken == first;
        if (ignoreFirstToken && tokens.size() == 1) {
            return;
        }
        if (ignoreFirstToken) {
            first = (CommonToken)tokens.get(1);
        }
        RuleNode peek = this.errorNodes.peek();
        RuleNode node = new RuleNode(NodeType.recovery, this.source);
        peek.addChild((Tree)node);
        node.setParent((Tree)peek);
        peek = node;
        peek.setFirstToken(first);
        peek.setLastToken(last);
        this.synchronizeAncestorsBoundaries(peek);
        peek.from = CommonTokenUtil.getCommonTokenOffsetRange(first)[0];
        peek.to = CommonTokenUtil.getCommonTokenOffsetRange(last)[1];
        int n = i = ignoreFirstToken ? 1 : 0;
        while (i < tokens.size()) {
            CommonToken token = (CommonToken)tokens.get(i);
            TokenNode tokenNode = new TokenNode(token);
            this.addNodeChild(peek, tokenNode);
            ++i;
        }
        this.lastConsumedToken = new CommonToken(0);
        this.lastConsumedToken.setStartIndex(first.getStartIndex());
        this.lastConsumedToken.setStopIndex(last.getStopIndex());
    }

    private void addNodeChild(AbstractParseTreeNode parent, AbstractParseTreeNode child) {
        parent.addChild((Tree)child);
        child.setParent((Tree)parent);
    }

    private static class Pair<T> {
        T n1;
        T n2;

        public Pair(T n1, T n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }
}

