/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.method;

import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractInterceptedElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.MethodModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.TargetAnalyzer;
import org.netbeans.modules.web.beans.api.model.InterceptorsResult;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.hints.EditorAnnotationsHelper;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class InterceptedMethodAnalyzer
extends AbstractInterceptedElementAnalyzer
implements MethodModelAnalyzer.MethodAnalyzer {
    @Override
    public void analyze(ExecutableElement element, TypeMirror returnType, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        boolean hasInterceptorBindings = this.hasInterceptorBindings(element, model);
        if (hasInterceptorBindings) {
            result.requireCdiEnabled(element, model);
            EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(result);
            ElementHandle handle = ElementHandle.create((Element)element);
            if (helper != null) {
                helper.addInterceptedMethod(result, (ExecutableElement)handle.resolve(result.getInfo()));
            }
        }
        if (AnnotationUtil.isLifecycleCallback(element, (CompilationInfo)model.getCompilationController())) {
            if (hasInterceptorBindings) {
                result.addNotification(Severity.WARNING, (Element)element, model, NbBundle.getMessage(InterceptedMethodAnalyzer.class, (String)"WARN_CallbackInterceptorBinding"));
            }
            if (cancel.get()) {
                return;
            }
            InterceptorsResult interceptorResult = model.getInterceptors(element);
            List<TypeElement> interceptors = interceptorResult.getResolvedInterceptors();
            AnnotationHelper helper = null;
            if (interceptors.size() > 0) {
                helper = new AnnotationHelper((CompilationInfo)model.getCompilationController());
            }
            for (TypeElement interceptor : interceptors) {
                Collection<AnnotationMirror> interceptorBindings = model.getInterceptorBindings(interceptor);
                for (AnnotationMirror annotationMirror : interceptorBindings) {
                    Set<ElementType> declaredTargetTypes;
                    Element iBinding = model.getCompilationController().getTypes().asElement(annotationMirror.getAnnotationType());
                    if (!(iBinding instanceof TypeElement) || (declaredTargetTypes = TargetAnalyzer.getDeclaredTargetTypes(helper, (TypeElement)iBinding)).size() == 1 && declaredTargetTypes.contains((Object)ElementType.TYPE)) continue;
                    result.addError((Element)element, model, NbBundle.getMessage(InterceptedMethodAnalyzer.class, (String)"ERR_LifecycleInterceptorTarget", (Object)interceptor.getQualifiedName().toString(), (Object)((TypeElement)iBinding).getQualifiedName().toString()));
                }
            }
        }
        if (cancel.get()) {
            return;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) {
            return;
        }
        boolean finalMethod = modifiers.contains((Object)Modifier.FINAL);
        boolean finalClass = parent.getModifiers().contains((Object)Modifier.FINAL);
        if (!finalMethod && !finalClass) {
            return;
        }
        if (cancel.get()) {
            return;
        }
        if (hasInterceptorBindings) {
            if (finalMethod) {
                result.addError((Element)element, model, NbBundle.getMessage(InterceptedMethodAnalyzer.class, (String)"ERR_FinalInterceptedMethod"));
            }
            if (finalClass && !AnnotationUtil.hasAnnotation(parent, "javax.interceptor.Interceptor", (CompilationInfo)model.getCompilationController())) {
                result.addError((Element)element, model, NbBundle.getMessage(InterceptedMethodAnalyzer.class, (String)"ERR_FinalInterceptedClass"));
            }
        }
    }

    @Override
    protected Set<AnnotationMirror> getInterceptorBindings(Element element, WebBeansModel model) {
        Set<AnnotationMirror> iBindings = super.getInterceptorBindings(element, model);
        List<? extends AnnotationMirror> annotations = model.getCompilationController().getElements().getAllAnnotationMirrors(element);
        iBindings.retainAll(annotations);
        return iBindings;
    }
}

