/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.method;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractScopedAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.MethodModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.openide.util.NbBundle;

public class ScopedMethodAnalyzer
extends AbstractScopedAnalyzer
implements MethodModelAnalyzer.MethodAnalyzer {
    @Override
    public void analyze(ExecutableElement element, TypeMirror returnType, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (AnnotationUtil.hasAnnotation(element, "javax.enterprise.inject.Produces", (CompilationInfo)model.getCompilationController())) {
            result.requireCdiEnabled(element, model);
            this.analyzeScope(element, model, cancel, result);
        }
    }

    @Override
    protected void checkScope(TypeElement scopeElement, Element element, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (scopeElement.getQualifiedName().contentEquals("javax.enterprise.context.Dependent")) {
            return;
        }
        TypeMirror methodType = element.asType();
        if (methodType instanceof ExecutableType) {
            TypeMirror returnType = ((ExecutableType)methodType).getReturnType();
            if (cancel.get()) {
                return;
            }
            if (this.hasTypeVarParameter(returnType)) {
                result.addError(element, model, NbBundle.getMessage(ScopedMethodAnalyzer.class, (String)"ERR_WrongScopeParameterizedProducerReturn", (Object)scopeElement.getQualifiedName().toString()));
            }
        }
    }
}

