/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.type;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractScopedAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.ClassModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class ScopedBeanAnalyzer
extends AbstractScopedAnalyzer
implements ClassModelAnalyzer.ClassAnalyzer {
    @Override
    public void analyze(TypeElement element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        this.analyzeScope(element, model, cancel, result);
    }

    @Override
    protected void checkScope(TypeElement scopeElement, Element element, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (cancel.get()) {
            return;
        }
        this.checkProxiability(scopeElement, element, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkPublicField(scopeElement, element, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkParameterizedBean(scopeElement, element, model, result);
    }

    private void checkParameterizedBean(TypeElement scopeElement, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        List<? extends TypeMirror> typeArguments;
        if ("javax.enterprise.context.Dependent".contentEquals(scopeElement.getQualifiedName())) {
            return;
        }
        result.requireCdiEnabled(element, model);
        TypeMirror type = element.asType();
        if (type instanceof DeclaredType && (typeArguments = ((DeclaredType)type).getTypeArguments()).size() != 0) {
            result.addError(element, model, NbBundle.getMessage(ScopedBeanAnalyzer.class, (String)"ERR_IncorrectScopeForParameterizedBean"));
        }
    }

    private void checkPublicField(TypeElement scopeElement, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        if ("javax.enterprise.context.Dependent".contentEquals(scopeElement.getQualifiedName())) {
            return;
        }
        result.requireCdiEnabled(element, model);
        List<VariableElement> fields = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (VariableElement field : fields) {
            Set<Modifier> modifiers = field.getModifiers();
            if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
            result.addError(element, model, NbBundle.getMessage(ScopedBeanAnalyzer.class, (String)"ERR_IcorrectScopeWithPublicField", (Object)field.getSimpleName().toString()));
            return;
        }
    }

    private void checkProxiability(TypeElement scopeElement, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        boolean isNormal = AnnotationUtil.hasAnnotation(scopeElement, "javax.enterprise.context.NormalScope", (CompilationInfo)model.getCompilationController());
        if (isNormal) {
            result.requireCdiEnabled(element, model);
            this.checkFinal(element, model, result);
        }
    }

    private void checkFinal(Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        if (!(element instanceof TypeElement)) {
            return;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            result.addError(element, model, NbBundle.getMessage(ScopedBeanAnalyzer.class, (String)"ERR_FinalScopedClass"));
            return;
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
        for (ExecutableElement method : methods) {
            modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.FINAL)) continue;
            result.addNotification(Severity.WARNING, (Element)method, model, NbBundle.getMessage(ScopedBeanAnalyzer.class, (String)"WARN_FinalScopedClassMethod"));
        }
    }
}

