/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.netbeans.modules.web.beans.impl.model.AbstractAssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.RestrictedTypedFilter;

class DelegateAssignabilityChecker
extends AbstractAssignabilityChecker {
    DelegateAssignabilityChecker() {
    }

    @Override
    protected boolean hasBeanType(Element element, ReferenceType variableType) {
        Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
        Collection<TypeMirror> restrictedTypes = RestrictedTypedFilter.getRestrictedTypes(element, this.getImplementation());
        if (restrictedTypes != null) {
            boolean hasBeanType = false;
            for (TypeMirror restrictedType : restrictedTypes) {
                if (!types.isSameType(types.erasure(restrictedType), types.erasure(variableType))) continue;
                hasBeanType = true;
                break;
            }
            if (!hasBeanType) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkAssignability(ReferenceType variableType, ReferenceType refType) {
        if (refType instanceof DeclaredType) {
            return this.checkAssignability(variableType, refType, ((DeclaredType)refType).asElement());
        }
        return super.checkAssignability(variableType, refType);
    }

    @Override
    protected boolean handleBothTypeVars(TypeMirror argType, TypeMirror varTypeArg, Types types) {
        TypeMirror upper = ((TypeVariable)argType).getUpperBound();
        TypeMirror upperVar = ((TypeVariable)varTypeArg).getUpperBound();
        if (upperVar == null || upperVar.getKind() == TypeKind.NULL) {
            return true;
        }
        if (upper == null || upper.getKind() == TypeKind.NULL) {
            return false;
        }
        return this.checkIsAssignable(types, upper, upperVar);
    }

    @Override
    protected boolean handleBeanTypeVar(TypeMirror argType, TypeMirror varTypeArg, Types types) {
        return false;
    }

    @Override
    protected boolean handleWildCardTypeVar(TypeMirror argType, Types types, TypeMirror upperBound, TypeMirror lowerBound) {
        TypeMirror typeUpper = ((TypeVariable)argType).getUpperBound();
        if (typeUpper == null || typeUpper.getKind() == TypeKind.NULL) {
            return upperBound == null || upperBound.getKind() == TypeKind.NULL;
        }
        if (upperBound == null || upperBound.getKind() == TypeKind.NULL) {
            if (lowerBound == null || lowerBound.getKind() == TypeKind.NULL) {
                return true;
            }
            return this.checkIsAssignable(types, lowerBound, typeUpper);
        }
        if (lowerBound == null || lowerBound.getKind() == TypeKind.NULL) {
            return this.checkIsAssignable(types, typeUpper, upperBound);
        }
        return this.checkIsAssignable(types, typeUpper, upperBound) && this.checkIsAssignable(types, lowerBound, typeUpper);
    }

    @Override
    protected boolean isAssignable(TypeMirror from, TypeMirror to, Types types) {
        if (!super.isAssignable(from, to, types)) {
            return false;
        }
        Element fromElement = types.asElement(from);
        Collection<TypeMirror> restrictedTypes = RestrictedTypedFilter.getRestrictedTypes(fromElement, this.getImplementation());
        if (restrictedTypes == null) {
            return this.getImplementation().getHelper().getCompilationController().getTypes().isAssignable(from, to);
        }
        for (TypeMirror restrictedType : restrictedTypes) {
            if (!types.isSameType(types.erasure(restrictedType), types.erasure(to))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleBeanRawType(Types types, List<? extends TypeMirror> typeArguments, TypeElement objectElement) {
        for (TypeMirror typeMirror : typeArguments) {
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                if (((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals(Object.class.getCanonicalName())) continue;
                return false;
            }
            if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                TypeMirror lowerBound = ((TypeVariable)typeMirror).getLowerBound();
                if (lowerBound != null && lowerBound.getKind() != TypeKind.NULL) {
                    return false;
                }
                TypeMirror upperBound = ((TypeVariable)typeMirror).getUpperBound();
                if (upperBound == null || upperBound.getKind() == TypeKind.NULL) continue;
                return types.isSameType(upperBound, objectElement.asType());
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean handleRequiredRawType(Types types, List<? extends TypeMirror> varTypeArguments, TypeElement objectElement) {
        return false;
    }

    @Override
    protected boolean handleRequiredTypeVar(TypeMirror argType, TypeMirror varTypeArg, Types types) {
        TypeMirror upper = ((TypeVariable)varTypeArg).getUpperBound();
        if (upper == null || upper.getKind() == TypeKind.NULL) {
            return true;
        }
        return this.checkIsAssignable(types, argType, upper);
    }
}

