/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Collection;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class PackagingFilter {
    private WebBeansModelImplementation myModel;

    PackagingFilter(WebBeansModelImplementation model) {
        this.myModel = model;
    }

    void filter(Collection<? extends Element> collection) {
        Iterator<? extends Element> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            if (!this.remove(element)) continue;
            iterator.remove();
        }
    }

    void filterTypes(Collection<? extends DeclaredType> collection) {
        Iterator<? extends DeclaredType> iterator = collection.iterator();
        while (iterator.hasNext()) {
            DeclaredType type = iterator.next();
            Element element = this.getModel().getHelper().getCompilationController().getTypes().asElement(type);
            if (element == null || !this.remove(element)) continue;
            iterator.remove();
        }
    }

    private boolean remove(Element element) {
        TypeElement typeElement = element instanceof TypeElement ? (TypeElement)element : this.getModel().getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
        if (typeElement == null) {
            return false;
        }
        FileObject file = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)ClasspathInfo.create((ClassPath)this.getModel().getModelUnit().getBootPath(), (ClassPath)ClassPath.EMPTY, (ClassPath)this.getModel().getModelUnit().getSourcePath()));
        if (file != null) {
            return false;
        }
        PackageElement pack = this.getModel().getHelper().getCompilationController().getElements().getPackageOf(typeElement);
        if (pack == null) {
            return false;
        }
        String packageName = pack.getQualifiedName().toString();
        String fqn = ElementUtilities.getBinaryName((TypeElement)typeElement);
        String className = fqn.substring(packageName.length());
        if (className.length() <= 0 || className.charAt(0) != '.') {
            return false;
        }
        className = className.substring(1);
        int dotIndex = className.indexOf(46);
        if (dotIndex != -1) {
            className = className.substring(0, dotIndex);
        }
        if (className == null) {
            return false;
        }
        String path = packageName.replace('.', '/') + '/' + className + ".class";
        ClassPath classPath = this.getModel().getModelUnit().getCompilePath();
        FileObject resource = classPath.findResource(path);
        if (resource != null) {
            FileObject archiveFile;
            String ext;
            FileObject root = classPath.findOwnerRoot(resource);
            if (root == null) {
                return false;
            }
            if (FileUtil.isArchiveFile((FileObject)root) && "war".equalsIgnoreCase(ext = (archiveFile = FileUtil.getArchiveFile((FileObject)root)).getExt())) {
                return root.getFileObject("WEB-INF/beans.xml") == null;
            }
            return !this.hasMetaBeans(root);
        }
        return false;
    }

    private boolean hasMetaBeans(FileObject root) {
        return root.getFileObject("META-INF/beans.xml") != null;
    }

    private WebBeansModelImplementation getModel() {
        return this.myModel;
    }
}

