/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.beans.hints.CDIAnnotation;
import org.netbeans.modules.web.beans.hints.EditorAnnotationsHelper;
import org.netbeans.modules.web.beans.navigation.actions.GoToDecoratorAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.InspectCDIAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.PositionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class CdiGlyphAction
extends AbstractAction {
    public CdiGlyphAction() {
        this.putValue("Name", NbBundle.getMessage(CdiGlyphAction.class, (String)"TXT_GlyphActionName"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JTextComponent comp = (JTextComponent)event.getSource();
        if (!this.performCdiAction(comp)) {
            Action action;
            int nextIndex;
            Action[] actions = ImplementationProvider.getDefault().getGlyphGutterActions(comp);
            if (actions == null) {
                return;
            }
            for (nextIndex = 0; nextIndex < actions.length && actions[nextIndex] != this; ++nextIndex) {
            }
            if (actions.length > ++nextIndex && (action = actions[nextIndex]) != null && action.isEnabled()) {
                action.actionPerformed(event);
            }
        }
    }

    private boolean performCdiAction(final JTextComponent comp) {
        final Document document = comp.getDocument();
        if (document instanceof BaseDocument) {
            final Object[] values = new Object[2];
            document.render(new Runnable(){

                @Override
                public void run() {
                    int dot = comp.getCaret().getDot();
                    Annotations annotations = ((BaseDocument)document).getAnnotations();
                    Line line = NbEditorUtilities.getLine((Document)document, (int)dot, (boolean)false);
                    if (line == null) {
                        return;
                    }
                    int lineNumber = line.getLineNumber();
                    AnnotationDesc desc = annotations.getActiveAnnotation(lineNumber);
                    values[0] = lineNumber;
                    values[1] = desc;
                }
            });
            if (values[0] == null || values[1] == null) {
                return false;
            }
            int lineNumber = (Integer)values[0];
            AnnotationDesc desc = (AnnotationDesc)values[1];
            String annotationType = desc.getAnnotationType();
            EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(this.getFile(comp));
            if (helper == null) {
                return false;
            }
            List<CDIAnnotation> cdiAnnotations = helper.getAnnotations();
            for (CDIAnnotation cdiAnnotation : cdiAnnotations) {
                int length;
                Line cdiLine;
                String cdiAnnotationType = cdiAnnotation.getAnnotationType();
                if (!cdiAnnotationType.equals(annotationType) || (cdiLine = cdiAnnotation.getPart().getLine()).getLineNumber() != lineNumber || (length = cdiAnnotation.getPart().getLength()) != desc.getLength()) continue;
                this.doAction(comp, annotationType, cdiAnnotation.getPart(), (BaseDocument)document);
                return true;
            }
        }
        return false;
    }

    private void doAction(JTextComponent comp, String annotationType, Line.Part part, BaseDocument doc) {
        if (annotationType.equals(CDIAnnotation.CDIAnnotaitonType.INJECTION_POINT.toString()) || annotationType.equals(CDIAnnotation.CDIAnnotaitonType.DELEGATE_POINT.toString())) {
            final AnnotationPositionStrategy strategy = new AnnotationPositionStrategy(part, doc);
            GoToInjectableAtCaretAction action = new GoToInjectableAtCaretAction(){

                @Override
                protected boolean findContext(JTextComponent component, Object[] context) {
                    return WebBeansActionHelper.getVariableElementAtDot(component, context, true, strategy);
                }
            };
            action.actionPerformed(null, comp);
        } else if (annotationType.equals(CDIAnnotation.CDIAnnotaitonType.EVENT.toString())) {
            final AnnotationPositionStrategy strategy = new AnnotationPositionStrategy(part, doc);
            InspectCDIAtCaretAction action = new InspectCDIAtCaretAction(){

                @Override
                protected boolean findContext(JTextComponent component, Object[] subject) {
                    return WebBeansActionHelper.getVariableElementAtDot(component, subject, false, strategy) || WebBeansActionHelper.getContextEventInjectionAtDot(component, subject, strategy);
                }
            };
            action.actionPerformed(null, comp);
        } else if (annotationType.equals(CDIAnnotation.CDIAnnotaitonType.OBSERVER.toString())) {
            final AnnotationPositionStrategy strategy = new AnnotationPositionStrategy(part, doc);
            InspectCDIAtCaretAction action = new InspectCDIAtCaretAction(){

                @Override
                protected boolean findContext(JTextComponent component, Object[] subject) {
                    return WebBeansActionHelper.getMethodAtDot(component, subject, strategy);
                }
            };
            action.actionPerformed(null, comp);
        } else if (annotationType.equals(CDIAnnotation.CDIAnnotaitonType.INTERCEPTED_ELEMENT.toString())) {
            final AnnotationPositionStrategy strategy = new AnnotationPositionStrategy(part, doc);
            InspectCDIAtCaretAction action = new InspectCDIAtCaretAction(){

                @Override
                protected boolean findContext(JTextComponent component, Object[] subject) {
                    return WebBeansActionHelper.getMethodAtDot(component, subject, strategy) || WebBeansActionHelper.getClassAtDot(component, subject, strategy);
                }
            };
            action.actionPerformed(null, comp);
        } else if (annotationType.equals(CDIAnnotation.CDIAnnotaitonType.DECORATED_BEAN.toString())) {
            final AnnotationPositionStrategy strategy = new AnnotationPositionStrategy(part, doc);
            GoToDecoratorAtCaretAction action = new GoToDecoratorAtCaretAction(){

                @Override
                protected boolean findContext(JTextComponent component, Object[] subject) {
                    return WebBeansActionHelper.getClassAtDot(component, subject, strategy);
                }
            };
            action.actionPerformed(null, comp);
        }
    }

    private FileObject getFile(JTextComponent component) {
        Document doc = component.getDocument();
        DataObject od = (DataObject)doc.getProperty("stream");
        if (od == null) {
            return null;
        }
        return od.getPrimaryFile();
    }

    private static class AnnotationPositionStrategy
    implements PositionStrategy,
    Runnable {
        private Line.Part myPart;
        private BaseDocument myDocument;
        private int myOffset;

        AnnotationPositionStrategy(Line.Part part, BaseDocument doc) {
            this.myPart = part;
            this.myDocument = doc;
        }

        @Override
        public void run() {
            Line line = this.myPart.getLine();
            int startOffset = Utilities.getRowStartFromLineOffset((BaseDocument)this.myDocument, (int)line.getLineNumber());
            this.myOffset = startOffset + this.myPart.getColumn();
        }

        @Override
        public int getOffset(JTextComponent component) {
            Document document = component.getDocument();
            document.render(this);
            return this.myOffset;
        }
    }
}

