/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.Browser;
import org.netbeans.modules.css.editor.module.spi.CssModule;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.module.spi.PropertySupportResolver;
import org.openide.util.NbBundle;

public class BrowserSpecificDefinitionParser
extends PropertySupportResolver {
    private String resourcePath;
    private Browser browser;
    private CssModule module;
    private final Set<String> supportedPropertiesNames = new HashSet<String>();
    private final Collection<Property> vendorSpecificProperties = new HashSet<Property>();

    public BrowserSpecificDefinitionParser(String resourcePath, Browser browser, CssModule module) {
        this.resourcePath = resourcePath;
        this.browser = browser;
        this.module = module;
        this.load();
    }

    private void load() {
        ResourceBundle bundle = NbBundle.getBundle((String)this.resourcePath);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String name = keys.nextElement();
            String value = bundle.getString(name).trim();
            if (value.isEmpty()) continue;
            char firstValueChar = value.charAt(0);
            StringTokenizer nameTokenizer = new StringTokenizer(name, ";");
            ArrayList<String> propertyNames = new ArrayList<String>();
            while (nameTokenizer.hasMoreTokens()) {
                String parsed_name = nameTokenizer.nextToken().trim();
                propertyNames.add(parsed_name);
            }
            block8: for (String propertyName : propertyNames) {
                if (propertyName.startsWith(this.browser.getVendorSpecificPropertyPrefix())) {
                    this.vendorSpecificProperties.add(new Property(propertyName, value, this.module));
                    this.supportedPropertiesNames.add(propertyName);
                    continue;
                }
                switch (firstValueChar) {
                    case '!': {
                        String vendorSpecificPropertyName = this.createVendorSpecificPropertyName(this.browser.getVendorSpecificPropertyPrefix(), propertyName);
                        this.vendorSpecificProperties.add(new ProxyProperty(vendorSpecificPropertyName, propertyName));
                        this.supportedPropertiesNames.add(vendorSpecificPropertyName);
                        continue block8;
                    }
                    case '+': {
                        this.supportedPropertiesNames.add(propertyName);
                        continue block8;
                    }
                    case '*': {
                        String vendorSpecificPropertyName = this.createVendorSpecificPropertyName(this.browser.getVendorSpecificPropertyPrefix(), propertyName);
                        this.vendorSpecificProperties.add(new ProxyProperty(vendorSpecificPropertyName, propertyName));
                        this.supportedPropertiesNames.add(propertyName);
                        this.supportedPropertiesNames.add(vendorSpecificPropertyName);
                        continue block8;
                    }
                    case '-': {
                        continue block8;
                    }
                }
                this.vendorSpecificProperties.add(new Property(propertyName, value, this.module));
                this.supportedPropertiesNames.add(propertyName);
            }
        }
    }

    private String createVendorSpecificPropertyName(String prefix, String standardPropertyName) {
        return prefix + standardPropertyName;
    }

    @Override
    public boolean isPropertySupported(String propertyName) {
        return this.supportedPropertiesNames.contains(propertyName);
    }

    public Collection<Property> getVendorSpecificProperties() {
        return this.vendorSpecificProperties;
    }

    private class ProxyProperty
    extends Property {
        private String delegateToPropertyName;

        public ProxyProperty(String name, String delegateToPropertyName) {
            super(name, null, null);
            this.delegateToPropertyName = delegateToPropertyName;
        }

        @Override
        public String getValueGrammar() {
            Property p = CssModuleSupport.getProperty(this.delegateToPropertyName);
            if (p == null) {
                p = CssModuleSupport.getProperty(this.delegateToPropertyName, true);
            }
            if (p == null) {
                Logger.getAnonymousLogger().warning(String.format("Cannot fine property %s referred in %s", this.delegateToPropertyName, BrowserSpecificDefinitionParser.this.resourcePath));
                return "";
            }
            return p.getValueGrammar();
        }
    }
}

