/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.css.editor.properties.Acceptors;
import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.netbeans.modules.css.editor.properties.KeywordUtil;
import org.netbeans.modules.css.editor.properties.parser.GrammarElement;
import org.netbeans.modules.css.editor.properties.parser.GrammarParser;
import org.netbeans.modules.css.editor.properties.parser.GroupGrammarElement;
import org.netbeans.modules.css.editor.properties.parser.PropertyModel;
import org.netbeans.modules.css.editor.properties.parser.ValueGrammarElement;

public class PropertyValue {
    private static final Logger LOGGER = Logger.getLogger(PropertyValue.class.getName());
    final GroupGrammarElement groupGrammarElement;
    private final String text;
    private final List<ResolvedToken> resolved = new ArrayList<ResolvedToken>();
    private Set<GrammarElement> resolvedAlternatives;
    private Set<GrammarElement> visibleAlternatives = new HashSet<GrammarElement>();
    private final Stack<String> stack = new Stack();
    private final String propertyDefinition;
    Stack<String> originalStack;
    final StringBuffer log = new StringBuffer();
    private static final Pattern FILTER_COMMENTS_PATTERN = Pattern.compile("/\\*.*?\\*/");
    private String propertyName;

    private static String filterComments(String text) {
        Matcher m = FILTER_COMMENTS_PATTERN.matcher(text);
        StringBuilder b = new StringBuilder(text);
        while (m.find()) {
            int to;
            int from = m.start();
            if (from == (to = m.end())) continue;
            char[] spaces = new char[to - from];
            Arrays.fill(spaces, ' ');
            String replacement = new String(spaces);
            b.replace(from, to, replacement);
        }
        return b.toString();
    }

    public PropertyValue(PropertyModel property, String textOfTheValue) {
        this.propertyName = property.getPropertyDescriptor().getName();
        this.groupGrammarElement = property.values();
        this.text = PropertyValue.filterComments(textOfTheValue);
        this.propertyDefinition = property.getPropertyDescriptor().getValueGrammar();
        this.consume();
    }

    PropertyValue(String propertyValueDefinition, String textOfTheValue) {
        this.groupGrammarElement = GrammarParser.parse(propertyValueDefinition);
        this.text = textOfTheValue;
        this.propertyDefinition = propertyValueDefinition;
        this.consume();
    }

    private void log(String msg) {
        this.log.append(msg);
    }

    String log() {
        return this.log.toString();
    }

    String inputText() {
        return this.text;
    }

    String propertyDefinition() {
        return this.propertyDefinition;
    }

    public List<String> left() {
        return this.stack;
    }

    public List<ResolvedToken> resolved() {
        return this.resolved;
    }

    public boolean success() {
        return this.stack.isEmpty();
    }

    public Set<GrammarElement> alternatives() {
        if (this.resolvedAlternatives == null) {
            this.initAlternatives();
        }
        return this.resolvedAlternatives;
    }

    public Set<GrammarElement> visibleAlternatives() {
        if (this.resolvedAlternatives == null) {
            this.initAlternatives();
        }
        return this.visibleAlternatives;
    }

    private void computeVisibleAlts() {
        for (GrammarElement e : this.alternatives()) {
            if (e instanceof ValueGrammarElement && ((ValueGrammarElement)e).isUnit()) continue;
            this.visibleAlternatives.add(e);
        }
    }

    private void consume() {
        PropertyValue.fillStack(this.stack, this.text);
        this.originalStack = (Stack)this.stack.clone();
        this.resolve(this.groupGrammarElement, this.stack, this.resolved);
    }

    private void initAlternatives() {
        this.resolvedAlternatives = this.resolveGrammarElement(this.groupGrammarElement, new ArrayList<ResolvedToken>(this.resolved)).alternatives();
        this.eliminateDuplicatedAlternatives();
        this.computeVisibleAlts();
    }

    private void eliminateDuplicatedAlternatives() {
        this.log("\nEliminated duplicate alternatives:\n");
        HashMap<String, GrammarElement> dupes = new HashMap<String, GrammarElement>();
        for (GrammarElement e : this.alternatives()) {
            if (dupes.put(e.toString(), e) == null) continue;
            this.log(e.path() + "\n");
        }
        this.log("-----------------\n");
        this.alternatives().retainAll(dupes.values());
    }

    private ResolveContext resolveGrammarElement(GrammarElement GrammarElement2, List<ResolvedToken> resolved) {
        int repeat;
        ResolveContext.ResolveType resolveType = ResolveContext.ResolveType.UNEVALUATED;
        HashSet<GrammarElement> alternatives = new HashSet<GrammarElement>();
        block0: for (repeat = 0; repeat < GrammarElement2.getMaximumOccurances(); ++repeat) {
            ResolveContext rt;
            ResolveContext.ResolveType previousPassResolveType = resolveType;
            if (resolveType == ResolveContext.ResolveType.UNRESOLVED) break;
            resolveType = ResolveContext.ResolveType.UNRESOLVED;
            if (GrammarElement2 instanceof ValueGrammarElement) {
                if (!this.consume(GrammarElement2, resolved)) break;
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED;
                continue;
            }
            if (!(GrammarElement2 instanceof GroupGrammarElement)) continue;
            GroupGrammarElement ge = (GroupGrammarElement)GrammarElement2;
            if (ge.getType() == GroupGrammarElement.Type.SET) {
                for (GrammarElement e : ge.elements()) {
                    rt = this.resolveGrammarElement(e, resolved);
                    if (rt.resolveType() == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) {
                        resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                        alternatives.clear();
                        alternatives.addAll(rt.alternatives());
                        break block0;
                    }
                    if (rt.resolved()) {
                        resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
                        alternatives.clear();
                        alternatives.addAll(rt.alternatives());
                        continue block0;
                    }
                    alternatives.addAll(rt.alternatives());
                }
                continue;
            }
            if (ge.getType() == GroupGrammarElement.Type.LIST) {
                for (GrammarElement e : ge.elements()) {
                    rt = this.resolveGrammarElement(e, resolved);
                    alternatives.addAll(rt.alternatives());
                    if (rt.resolveType() == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) {
                        resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                        alternatives.clear();
                        alternatives.addAll(rt.alternatives());
                        break block0;
                    }
                    if (!rt.resolved()) continue;
                    resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
                }
                continue;
            }
            if (ge.getType() != GroupGrammarElement.Type.SEQUENCE) continue;
            this.log("<S> " + ge.path() + "\n");
            GrammarElement firstUnresolved = null;
            HashSet<GrammarElement> localAlts = new HashSet<GrammarElement>();
            for (GrammarElement e : ge.elements()) {
                ResolveContext rt2 = this.resolveGrammarElement(e, resolved);
                this.log("trying " + e.path() + " (MIN=" + e.getMinimumOccurances() + "; MAX=" + e.getMaximumOccurances() + "; resolved=" + (Object)((Object)rt2.resolveType()) + "; alts=" + rt2.alternatives().size() + ")\n");
                if (rt2.resolveType() == ResolveContext.ResolveType.UNRESOLVED) {
                    localAlts.addAll(rt2.alternatives());
                    if (e.getMinimumOccurances() <= 0) continue;
                    firstUnresolved = e;
                    break;
                }
                if (rt2.resolveType() == ResolveContext.ResolveType.FULLY_RESOLVED) {
                    resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                    localAlts.clear();
                    continue;
                }
                if (rt2.resolveType() != ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) continue;
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                localAlts.clear();
                localAlts.addAll(rt2.alternatives());
                firstUnresolved = e;
                this.log("break on " + e.path() + "\n");
                break;
            }
            alternatives.addAll(localAlts);
            if (firstUnresolved == null) {
                resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
            } else if (previousPassResolveType == ResolveContext.ResolveType.FULLY_RESOLVED) {
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
            }
            this.log("sequence " + (Object)((Object)resolveType) + "\n");
            if (resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) break;
        }
        int remainingPossibleOccurances = GrammarElement2.getMaximumOccurances() - repeat;
        if (GrammarElement2 instanceof ValueGrammarElement) {
            if (resolveType == ResolveContext.ResolveType.UNRESOLVED || resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED && remainingPossibleOccurances > 0) {
                alternatives.add(GrammarElement2);
            }
            if (resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED && remainingPossibleOccurances == 0) {
                resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
            }
        }
        return ResolveContext.resolveContext(resolveType, alternatives);
    }

    private boolean consume(GrammarElement e, List<ResolvedToken> resolved) {
        for (ResolvedToken rt : resolved) {
            if (!rt.getGrammarElement().equals(e)) continue;
            resolved.remove(rt);
            return true;
        }
        return false;
    }

    static void fillStack(Stack<String> stack, String input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'' || c == '\"') {
                sb.append(c);
                ++i;
                while (i < input.length() && (c = input.charAt(i)) != '\'' && c != '\"') {
                    sb.append(c);
                    ++i;
                }
                sb.append(c);
                stack.add(0, sb.toString());
                sb = new StringBuffer();
                continue;
            }
            if (sb.toString().equalsIgnoreCase("url") && c == '(') {
                stack.add(0, sb.toString());
                stack.add(0, "" + c);
                sb = new StringBuffer();
                ++i;
                while (i < input.length() && (c = input.charAt(i)) != ')') {
                    sb.append(c);
                    ++i;
                }
                stack.add(0, sb.toString());
                stack.add(0, "" + c);
                sb = new StringBuffer();
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n') {
                if (sb.length() > 0) {
                    stack.add(0, sb.toString());
                    sb = new StringBuffer();
                }
                while (i < input.length() && (c = input.charAt(i)) == ' ' && c == '\t') {
                    ++i;
                }
                continue;
            }
            if (c == ',' || c == '/' || c == '(' || c == ')') {
                if (sb.length() > 0) {
                    stack.add(0, sb.toString());
                }
                stack.add(0, "" + c);
                sb = new StringBuffer();
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            stack.add(0, sb.toString());
        }
    }

    private boolean resolve(GrammarElement e, Stack<String> input, List<ResolvedToken> consumed) {
        this.log.append(e.path()).append("\n");
        boolean itemResolved = false;
        if (input.isEmpty()) {
            return true;
        }
        if (e instanceof GroupGrammarElement) {
            GroupGrammarElement ge = (GroupGrammarElement)e;
            boolean isResolved = false;
            for (int i = 0; i < e.getMaximumOccurances(); ++i) {
                ArrayList<GrammarElement> GrammarElementsToProcess = new ArrayList<GrammarElement>(ge.elements());
                block1: do {
                    for (GrammarElement member : GrammarElementsToProcess) {
                        isResolved = this.resolve(member, input, consumed);
                        if (isResolved) {
                            itemResolved = true;
                            if (ge.getType() == GroupGrammarElement.Type.SEQUENCE) continue;
                            if (ge.getType() != GroupGrammarElement.Type.LIST) break block1;
                            this.log.append("sg resolved in ").append(member.path()).append("\n");
                            GrammarElementsToProcess.remove(member);
                            continue block1;
                        }
                        if (ge.getType() != GroupGrammarElement.Type.SEQUENCE || member.getMinimumOccurances() <= 0) continue;
                        continue block1;
                    }
                } while (!input.isEmpty() && isResolved && !GrammarElementsToProcess.isEmpty() && ge.getType() == GroupGrammarElement.Type.LIST);
                if (isResolved && !input.isEmpty()) {
                    continue;
                }
                break;
            }
        } else if (e instanceof ValueGrammarElement) {
            String token = input.peek();
            ValueGrammarElement ve = (ValueGrammarElement)e;
            if (ve.isUnit() && !KeywordUtil.isKeyword(token)) {
                String unitName = ve.value();
                CssPropertyValueAcceptor acceptor = Acceptors.instance().getAcceptor(unitName);
                if (acceptor != null) {
                    if (acceptor.accepts(token)) {
                        input.pop();
                        consumed.add(new ResolvedToken(token, e));
                        this.log.append("eaten UNIT '").append(token).append("'\n");
                        return true;
                    }
                } else {
                    LOGGER.log(Level.WARNING, String.format("Cannot find unit acceptor '%s' for of the '%s' property", ve.value(), this.propertyName));
                }
            } else if (token.equalsIgnoreCase(ve.value())) {
                input.pop();
                consumed.add(new ResolvedToken(token, e));
                this.log.append("eaten '").append(token).append("'\n");
                return true;
            }
        }
        return itemResolved;
    }

    public class ResolvedToken {
        private String token;
        private GrammarElement GrammarElement;

        private ResolvedToken(String token, GrammarElement GrammarElement2) {
            this.token = token;
            this.GrammarElement = GrammarElement2;
        }

        public String token() {
            return this.token;
        }

        public GrammarElement getGrammarElement() {
            return this.GrammarElement;
        }
    }

    static class ResolveContext {
        private ResolveType type;
        private Set<GrammarElement> alternatives;

        public static ResolveContext resolveContext(ResolveType type, Set<GrammarElement> alternatives) {
            return new ResolveContext(type, alternatives);
        }

        private ResolveContext(ResolveType type, Set<GrammarElement> alternatives) {
            this.type = type;
            this.alternatives = alternatives;
        }

        public boolean resolved() {
            return this.type == ResolveType.PARTIALLY_RESOLVED || this.type == ResolveType.FULLY_RESOLVED;
        }

        public ResolveType resolveType() {
            return this.type;
        }

        public Set<GrammarElement> alternatives() {
            return this.alternatives;
        }

        public static enum ResolveType {
            UNEVALUATED,
            UNRESOLVED,
            PARTIALLY_RESOLVED,
            FULLY_RESOLVED,
            PARTIALLY_RESOLVED_SEQUENCE;

        }
    }
}

