<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{
	/*
	=============================
		FORM VARIABLES
	=============================
	*/	
	$_FORM['link']				= (string) $_POST['link'];
	$_FORM['title']			= (string) $_POST['title'];
	$_FORM['description']	= (string) $_POST['description'];
	$_FORM['tags']				= (string) $_POST['tags'];
	$_FORM['category']		= (int) $_POST['category'];
	$_FORM['allow_comments']= (int) $_POST['allow_comments'];
	$_FORM['sticky']			= (int) $_POST['sticky'];

	/*
	=============================
		EXECUTE
	=============================
	*/
	$ARGS = array();
	
	$ARGS['type'] = 'video';
	$ARGS['title'] = $_FORM['title'];
	$ARGS['video'] = $_FORM['link'];
	
	// Content
	$ARGS['content'] = $_FORM['description'] . '<!-- pagebreak -->';

	// IDs
	$ARGS['idcat']		= $_FORM['category'];
	$ARGS['iduser']	= $login->get_iduser();
	
	// Options
	$ARGS['allow_comments'] = $_FORM['allow_comments'];
	$ARGS['sticky'] = $_FORM['sticky'];

	$dbxml_post->add( $ARGS );

	if( !$dbxml_post->flag_error() )
	{
		// ADD TAGS
		$dbxml_tags->add( $dbxml_post->get_last_insert_id(), $_FORM['tags'] );
		$dbxml_tags->savetofile();
		
		// Generate RSS
		$nbfunctions->generate_rss($dbxml_config, $dbxml_post, $dbxml_rss);
		
		$_FLAG['msj'] = $_LANG['POST_PUBLISHED_SUCCESS'] . '<br /> <a href="../post.php?idpost='.$dbxml_post->get_last_insert_id().'" class="banner">'.$_LANG['VIEW_POST'].'</a> | <a href="post.php?view=edit&amp;idpost='.$dbxml_post->get_last_insert_id().'" class="banner">'.$_LANG['EDIT_POST'].'</a> | <a href="./" class="banner">'.$_LANG['BACK_TO_DASHBOARD'].'</a>';
		$_FLAG['success'] = true;
	}
	else
	{
		$_FLAG['msj'] = $_LANG[ $dbxml_post->flag_i18n() ];
		$_FLAG['error'] = true;
	}
}

/*
=======================================================
	HTML
=======================================================
*/

	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error'], true, 7000);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['NEW_VIDEO_POST'].'</div>';

	echo '<form method="post">';
	
	echo '
			<input type="hidden" id="exe" name="exe" />
			<input type="hidden" name="token" value="'.$login->get_token().'" />
	';

	echo '	
			<div class="container_form_section">
				<label for="js_link">'.$_LANG['VIDEO_LINK'].'</label>
				<input type="text" name="link" id="js_link" class="textbox_big" value="http://" /> <input type="button" value="'.$_LANG['GET_INFO'].'" class="border_round_3px button_default" id="js_button_get" />
				<div class="container_form_help" id="js_help_link">'.$_LANG['EXAMPLE'].': http://www.youtube.com/watch?v=ylfKWVpp3uo</div>
			</div>
				
			<div id="js_container_fields_hidden" style="display: none;">
			
				<div class="container_form_section">
					<label for="js_title">'.$_LANG['TITLE'].'</label>
					<input type="text" name="title" id="js_title" value="'.$_LANG['TITLE_HERE'].'" class="textbox_big" />
				</div>
			
				<div class="container_form_section">
					<label for="js_description">'.$_LANG['DESCRIPTION'].'</label>
					<textarea name="description" id="js_description" class="big_medium"></textarea>
				</div>
			
				<div class="container_form_section">
					<label for="js_tags">'.$_LANG['TAGS_AND_KEYWORDS'].'</label>
					<input type="text" name="tags" id="js_tags" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['TAGS_SEPARATED_BY_COMMA'].'</div>
				</div>
			
				<div class="container_form_section">
					<label for="js_category">'.$_LANG['CATEGORIES'].'</label>
					<select name="category" id="js_category" class="textbox_small">
	';
					$categories = $dbxml_categories->get_all();
					foreach( $categories as $category )
					{
						echo '<option value="'.$category['id'].'">'.$category['name'].'</option>';
					}
	echo '
					</select>
				</div>
			
				<div class="container_form_section">
					<label>Options</label>
					<label class="option">
						<input type="checkbox" name="allow_comments" value="1" /> '.$_LANG['ALLOW_COMMENTS'].'
					</label>
					<label class="option">
						<input type="checkbox" name="sticky" value="1" /> '.$_LANG['STICKY_POST'].'
					</label>
				</div>
				
				<div class="container_form_buttons">
					<input type="submit" value="'.$_LANG['PUBLISH_POST'].'"	class="border_round_3px button_default" />
					<input type="button" value="'.$_LANG['CANCEL'].'"			class="border_round_3px button_cancel"		id="js_button_cancel" />
				</div>
				
			</div>
	';

	echo '</form>';

	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">

?>

<script type="text/javascript">

/*
=======================================================
	JAVASCRIPT : VARS
=======================================================
*/

var tmp_url = "";
var token = "<?php echo $login->get_token() ?>";

/*
=======================================================
	JAVASCRIPT : FUNCTIONS
=======================================================
*/

function link_set_info(url)
{
	var button = $("#js_button_get");
	var fields_hidden = $("#js_container_fields_hidden");
	var field_help = $("#js_help_link");
	
	fields_hidden.slideUp("slow");
	button.attr("disabled","disabled").addClass("button_wait").attr("value", "<?php echo $_LANG['PLASE_WAIT'] ?>");
	
	$.ajax({
			url: "ajax/nb_get_metatags.php",
			type: 'POST',
			data: {token:token, url: url},
			cache: false,
			timeout: 15000,
			dataType: "xml",
			error: function()
			{
				alert("Ajax fail");
			},
			success: function(xml)
			{ 
				if( $(xml).find("success").text() == "1" )
				{
					$("#js_title").attr("value", $(xml).find("title").text() );
					$("#js_description").html( $(xml).find("description").text() );
					$("#js_tags").attr("value", $(xml).find("keywords").text() );
	
					field_help.html("<?php echo $_LANG['EXAMPLE'] .': http://www.youtube.com/watch?v=ylfKWVpp3uo'?>").removeClass().addClass("container_form_help");
	
					fields_hidden.slideDown("slow");
				}
				else
				{					
					field_help.html("<?php echo $_LANG['INVALID_URL'] . '. ' . $_LANG['EXAMPLE'] .': http://www.youtube.com/watch?v=ylfKWVpp3uo'?>").removeClass().addClass("container_form_help_alert");
				}
				
				button.attr("disabled","").removeClass("button_wait").attr("value", "<?php echo $_LANG['GET_INFO'] ?>");
			}
	});

}

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/

$(document).ready(function(){

	// Event - Click
	$('#js_button_get').click(
		function()
		{ 		
			var value = $("#js_link").attr("value");
			if ( (value != '') && (value != tmp_url) )
			{			
				tmp_url = value;
				link_set_info( value );
	 		}
    });
	
	// Event - submit
	$("form").submit(
		function()
		{		
			return true;
		}
	);
	
	// Event - Click - Button cancel
	$("#js_button_cancel").click(
		function()
		{
			window.location = "./index.php";
		}
	);

});

</script>
