<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

$profile_tip  = '1- '.$_LANG['SELECT_JPG_IMAGE_CLICKING_OVER'];
$profile_tip .= '<br />';
$profile_tip .= '2- '.$_LANG['THEN_CLICK_OVER_THE_UPLOAD_IMAGE_BUTTON'];

if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{
	if( $_URL['exe'] === 'upload' )
	{
		/*
		=============================
			FORM VARIABLES
		=============================
		*/	
		$_FORM['name']			= $_FILES['imagefile']['name'];
		$_FORM['type']			= $_FILES['imagefile']['type'];
		$_FORM['size']			= $_FILES['imagefile']['size'];
		$_FORM['tmp_name']	= $_FILES['imagefile']['tmp_name'];
		$_FORM['error']		= $_FILES['imagefile']['error'];

		/*
		=============================
			EXECUTE
		=============================
		*/
		if( $_FORM['error'] == 0 )
		{
			if( $_FORM['type'] == 'image/jpeg' )
			{
				if( !move_uploaded_file($_FORM['tmp_name'], PATH_TMP.'profile.jpg') )
				{
					$_FLAG['msj'] = $_LANG['ERROR_WHEN_UPLOAD_THE_IMAGE'];
					$_FLAG['error'] = true;
				}
				else
				{
					$profile_tip = $_LANG['NOW_SELECT_WITH_YOUR_MOUSE_A_REGION'];
				}
			}
			else
			{
				$_FLAG['msj'] = $_LANG['ONLY_SUPPORT_JPG_IMAGES'];
				$_FLAG['error'] = true;
			}
		}
		else
		{
			$_FLAG['msj'] = $_LANG['PHP_ERROR'] . ' - ' . $_LANG['FILE_ERROR_CODE'] . ' #' . $_FORM['error'];
			$_FLAG['error'] = true;
		}
	}
	elseif( $_URL['exe'] === 'crop' )
	{
		/*
		=============================
			FORM VARIABLES
		=============================
		*/
		$_FORM['quality'] = 90;
		
		$_FORM['src_x'] = $_POST['x'];	// crop
		$_FORM['src_y'] = $_POST['y'];	// crop
			
		$_FORM['src_w'] = $_POST['w']; // crop
		$_FORM['src_h'] = $_POST['h']; // crop

		/*
		=============================
			EXECUTE
		=============================
		*/

		$src_image = imagecreatefromjpeg( PATH_TMP . 'profile.jpg' );

		$dst_image120 = ImageCreateTrueColor(120, 120);
		imagecopyresampled($dst_image120, $src_image, 0, 0, $_FORM['src_x'], $_FORM['src_y'], 120, 120, $_FORM['src_w'], $_FORM['src_h']);
		imagejpeg($dst_image120, PATH_PROFILES_PICTURES . '0.120x120.jpg', $_FORM['quality']);

		$dst_image75 = ImageCreateTrueColor(75, 75);
		imagecopyresampled($dst_image75, $src_image, 0, 0, $_FORM['src_x'], $_FORM['src_y'], 75, 75, $_FORM['src_w'], $_FORM['src_h']);
		imagejpeg($dst_image75, PATH_PROFILES_PICTURES . '0.75x75.jpg', $_FORM['quality']);

		$dst_image50 = ImageCreateTrueColor(50, 50);
		imagecopyresampled($dst_image50, $src_image, 0, 0, $_FORM['src_x'], $_FORM['src_y'], 50, 50, $_FORM['src_w'], $_FORM['src_h']);
		imagejpeg($dst_image50, PATH_PROFILES_PICTURES . '0.50x50.jpg', $_FORM['quality']);

		// ** Deberia controlar que las operaciones fueron exitosas
		$_FLAG['msj'] = $_LANG['THE_CHANGES_SAVED_SUCCESS'];
		$_FLAG['success'] = true;
	}
}

/*
=======================================================
	HTML
=======================================================
*/

	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error']);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['PROFILE_PICTURE'].'</div>';

	echo '<div class="banner_tip">'.$profile_tip.'</div>';

	echo '<form method="post" enctype="multipart/form-data">';

	echo '
			<input type="hidden" name="token" value="'.$login->get_token().'" />
			<input type="hidden" id="x" name="x" />
			<input type="hidden" id="y" name="y" />
			<input type="hidden" id="w" name="w" />
			<input type="hidden" id="h" name="h" />
			<input type="hidden" id="step" value="'.$_URL['exe'].'" />
	';

	if( ($_URL['exe'] === 'upload') && (!$_FLAG['error']) )
	{
		echo '
				<input type="hidden" id="exe" name="exe" value="crop" />
				
				<img src="'.PATH_TMP.'profile.jpg'.'" id="cropbox" />
			
				<div class="container_buttons_box">
					<input type="button" value="'.$_LANG['CROP_IMAGE'].'"		class="border_round_3px button_default" id="js_button_save" />
				</div>
		';
	}
	else
	{
		echo '
				<input type="hidden" id="exe" name="exe" value="upload" />
		
				<div class="custom_container_center">
					<input name="imagefile" type="file" />
				</div>
				
				<div class="container_buttons_box">
					<input type="button" value="'.$_LANG['UPLOAD_IMAGE'].'"	class="border_round_3px button_default" id="js_button_save" />
					<input type="button" value="'.$_LANG['CANCEL'].'"			class="border_round_3px button_cancel" id="js_button_cancel" />
				</div>
		';
	}
	
	echo '</form>';

	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">

?>

<script type="text/javascript" src="<?php echo FILE_JS_JCROP ?>"></script>
<script type='text/javascript'>

/*
=======================================================
	JAVASCRIPT : FUNCTIONS
=======================================================
*/
	function submit_form()
	{		
		$("form").attr("action","");
		$("form").submit();
		
		return false;
	}

	function updateCoords(c)
	{
		$("#x").val(c.x);
		$("#y").val(c.y);
		$("#w").val(c.w);
		$("#h").val(c.h);
	};

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/

$(document).ready(function() {

	$(function() { $("#cropbox").Jcrop({ aspectRatio: 1, boxWidth: 600, onSelect: updateCoords}); });

	// Event - Click - Button save
	$("#js_button_save").click(
		function()
		{		
			submit_form();
		}
	);
	
	// Event - Click - Button cancel
	$("#js_button_cancel").click(
		function()
		{
			window.location = "./index.php";
		}
	);
		
});

</script>
