<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

/*
=======================================================
	HTML
=======================================================
*/

	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error']);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['MANAGE_POSTS'].'</div>';

	echo '<table>';
		echo '<thead>';
			echo '<tr>';
				echo '<th>'.$_LANG['TITLE'].'</th>';
				echo '<th>'.$_LANG['TYPE'].'</th>';
				echo '<th class="select_category">'.$_LANG['CATEGORY'].'</th>';
			echo '</tr>';
		echo '</thead>';
		
		echo '<tbody>';

		$posts = $dbxml_post->get_list_by_page($_URL['page'], POSTPPAGE);
		foreach($posts as $key=>$post)
		{
			$key % 2 == 0 ? $attr = ' bgcolor' : $attr = '';

			echo '<tr class="border'.$attr.'">';

				echo '<td>
							<div class="table_bold">'.$post['title'].'</div>
							<div class="table_tools">
								<a href="../post.php?idpost='.$post['idpost'].'" class="plist">'.$_LANG['VIEW'].'</a>
								<a href="post.php?view=edit&amp;idpost='.$post['idpost'].'" class="plist">'.$_LANG['EDIT'].'</a>
								<a href="#" class="plist js_delete" idpost="'.$post['idpost'].'" status="0" >'.$_LANG['DELETE'].'</a>
							</div>
						</td>
				';

				echo '<td>'.$post['type'].'</td>';

				echo '<td class="select_category">';
					echo '<select file="'.$post['filename'].'" class="textbox_xsmall js_category">';

					$categories = $dbxml_categories->get_all();
					foreach( $categories as $category )
					{
						$post['idcategory'] == $category['id'] ? $selected = 'selected="selected"' : $selected = '';
						echo '<option value="'.$category['id'].'" '.$selected.'>'.$category['name'].'</option>';
					}

					echo '</select>';
				echo '</td>';

			echo '</tr>';

			ob_flush();
		}

		echo '</tbody>';
	echo '</table>';

	if($dbxml_post->get_count() > POSTPPAGE )
	{
		echo '<div class="container_backnext">';
		
			$next_page = $_URL['page'] + 1;
			$back_page = $_URL['page'] - 1;
			
			if($_URL['page'] > 0)
				echo '<div class="back"><a class="backnext" href="post.php?view=list&amp;page='.$back_page.'">← '.$_LANG['BACK'].'</a></div>';
			
			if( $_URL['page'] < (ceil($dbxml_post->get_count() / POSTPPAGE) -1) )
				echo '<div class="next"><a class="backnext" href="post.php?view=list&amp;page='.$next_page.'">'.$_LANG['NEXT'].' →</a></div>';
				
		echo '</div>';
	}
	
	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">

?>

<script type='text/javascript'>

/*
=======================================================
	JAVASCRIPT : VARS
=======================================================
*/

var token = "<?php echo $login->get_token() ?>";

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/
			
$(document).ready(function(){

	$(".js_delete").click(
		function()
		{
			var cobj = $(this);
			var status = cobj.attr("status");
			var idpost = cobj.attr("idpost");

			if( status == "1")
			{
				$.post("ajax/post_delete.php", {token:token, idpost: idpost},
				function(xml)
				{
					if( $(xml).find("success").text() == "1" )
					{
						cobj.parent().parent().parent().fadeOut();
					}
				});
			}
			else
			{
				cobj.attr("status", "1");
				cobj.css("color", "#DA1818");
				cobj.html("<?php echo $_LANG['ARE_YOU_SURE'] ?>");				
			}
		}
	);

	// Event -
	$(".js_category").change(
		function()
		{
			var cobj = $(this);
			var idcat = cobj.children("option:selected").attr("value");
			var file = cobj.attr("file");
			
			$.post("ajax/post_set_category.php", {token:token, idcat: idcat, file: file},
			function(xml)
			{
				if( $(xml).find("success").text() == "1" )
				{
					cobj.attr("file", $(xml).find("renameto").text() );
				}
			});
		}
	);

});

</script>
