<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{
	/*
	=============================
		FORM VARIABLES
	=============================
	*/	
	$_FORM['content']			= (string) $_POST['js_input_content'];
	$_FORM['title']			= (string) $_POST['title'];
	$_FORM['tags']				= (string) $_POST['tags'];
	$_FORM['category']		= (int) $_POST['category'];
	$_FORM['allow_comments']= (int) $_POST['allow_comments'];
	$_FORM['sticky']			= (int) $_POST['sticky'];
		
	/*
	=============================
		EXECUTE
	=============================
	*/
	$ARGS = array();
	
	$ARGS['type'] = 'simple';
	$ARGS['title'] = $_FORM['title'];
	$ARGS['content'] = $_FORM['content'];

	// IDs
	$ARGS['idcat']		= $_FORM['category'];
	$ARGS['iduser']	= $login->get_iduser();
	
	// Options
	$ARGS['allow_comments'] = $_FORM['allow_comments'];
	$ARGS['sticky'] = $_FORM['sticky'];
	
	$dbxml_post->add( $ARGS );

	if( !$dbxml_post->flag_error() )
	{
		// ADD TAGS
		$dbxml_tags->add( $dbxml_post->get_last_insert_id(), $_FORM['tags'] );
		$dbxml_tags->savetofile();
		
		// Generate RSS
		$nbfunctions->generate_rss($dbxml_config, $dbxml_post, $dbxml_rss);

		$_FLAG['msj'] = $_LANG['POST_PUBLISHED_SUCCESS'] . '<br /> <a href="../post.php?idpost='.$dbxml_post->get_last_insert_id().'" class="banner">'.$_LANG['VIEW_POST'].'</a> | <a href="post.php?view=edit&amp;idpost='.$dbxml_post->get_last_insert_id().'" class="banner">'.$_LANG['EDIT_POST'].'</a> | <a href="./" class="banner">'.$_LANG['BACK_TO_DASHBOARD'].'</a>';
		$_FLAG['success'] = true;
	}
	else
	{
		$_FLAG['msj'] = $_LANG[ $dbxml_post->flag_i18n() ];
		$_FLAG['error'] = true;
	}
}

/*
=======================================================
	HTML
=======================================================
*/
	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error'], true, 7000);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['NEW_SIMPLE_POST'].'</div>';

	echo '<form method="post" action="">';
	
	echo '
			<input type="hidden" id="exe" name="exe" />
			<input type="hidden" name="token" value="'.$login->get_token().'"/>
	';

	echo '			
			<div class="container_form_section">
				<label for="js_input_title">'.$_LANG['TITLE'].'</label>
				<input type="text" name="title" id="js_input_title" class="textbox_max font_1" />
			</div>
				
			<div class="container_form_section">
				<div id="js_input_content"><p>&nbsp;</p></div>
			</div>
			
			<div class="container_form_section">
				<label for="js_input_tags">'.$_LANG['TAGS_AND_KEYWORDS'].'</label>
				<input type="text" name="tags" id="js_input_tags" class="textbox_big" />
				<div class="container_form_help">'.$_LANG['TAGS_SEPARATED_BY_COMMA'].'</div>
			</div>
				
			<div class="container_form_section">
				<label for="js_input_category">'.$_LANG['CATEGORIES'].'</label>
				<select name="category" id="js_input_category" class="textbox_small">
	';

				$categories = $dbxml_categories->get_all();
				foreach( $categories as $category )
				{
					echo '<option value="'.$category['id'].'">'.$category['name'].'</option>';
				}

	echo '
				</select>
			</div>
				
			<div class="container_form_section">
				<label>'.$_LANG['OPTIONS'].'</label>
				<label class="option">
					<input type="checkbox" name="allow_comments" value="1" /> '.$_LANG['ALLOW_COMMENTS'].'
				</label>
				<label class="option">
					<input type="checkbox" name="sticky" value="1" /> '.$_LANG['STICKY_POST'].'
				</label>
			</div>
				
			<div class="container_form_buttons">
				<input type="submit" value="'.$_LANG['PUBLISH_POST'].'"	class="border_round_3px button_default" />
				<input type="button" value="'.$_LANG['CANCEL'].'"			class="border_round_3px button_cancel"		id="js_button_cancel" />
			</div>
	';

	echo '</form>';

	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">
?>

<!-- ELRTE -->
<link rel="stylesheet" href="<?php echo PATH_ADMIN_THEMES . 'default/ui-themes/smoothness/jquery-ui.css'?>" type="text/css" media="screen" charset="utf-8" />
<link rel="stylesheet" href="<?php echo PATH_ADMIN_THEMES . 'default/elrte.min.css'?>" type="text/css" media="screen" charset="utf-8" />
<link rel="stylesheet" href="<?php echo PATH_ADMIN_THEMES . 'default/elfinder.full.css'?>" media="screen" charset="utf-8" />

<script type="text/javascript" src="<?php echo FILE_JS_JQUERYUI ?>" charset="utf-8"></script>
<script type="text/javascript" src="<?php echo FILE_JS_ELRTE ?>" charset="utf-8"></script>
<script type="text/javascript" src="<?php echo FILE_JS_ELFINDER ?>" charset="utf-8"></script>

<script type="text/javascript">

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/

$(document).ready(function(){

	// elRTE
	elRTE.prototype.options.panels.nbpanel = ['horizontalrule', 'blockquote', 'div', 'stopfloat', 'css', 'nbsp', 'pagebreak'];	
	elRTE.prototype.options.toolbars.nbtoolbar = ['copypaste', 'undoredo', 'style', 'colors', 'alignment', 'indent', 'lists', 'nbpanel', 'links', 'media', 'elfinder', 'format', 'fullscreen'];

	var config = {
		doctype	: '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">',
		lang		: 'en',
		height   : 450,
		toolbar  : 'nbtoolbar',
		cssClass : 'el-rte',
		cssfiles : ["<?php echo PATH_ADMIN_THEMES . 'default/elrte-inner.css'?>"],
		fmOpen	: function(callback)
						{
							$('<div id="js_elfinder">').elfinder({
								url : 'ajax/elFinder.php',
								lang : 'en',
								dialog : { width : 900, modal : true, title : "Nibbleblog -" },
								closeOnEditorCallback : true,
								editorCallback : callback
							})
						}
	}

	$("#js_input_content").elrte(config);
	
	// Event - submit
	$("form").submit(
		function()
		{		
			return true;
		}
	);
	
	// Event - Click - Button cancel
	$("#js_button_cancel").click(
		function()
		{
			window.location = "./index.php";
		}
	);

});

</script>
