<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
   
class LINKS_DBXML extends NBFUNCTIONS {

/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error
	
/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function LINKS_DBXML($file)
		{			
			$this->flag_error = false;
			$this->flag_i18n = "";

			$this->file_xml = $file;

			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	METHODS
======================================================================================
*/
		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}

		public function get_autoinc()
		{
			return( (int) $this->obj_xml['autoinc'] );
		}

		private function set_autoinc($value = 0)
		{
			$this->obj_xml['autoinc'] = $value + $this->get_autoinc();
		}

		// return boolean
		// TRUE		- exist
		// FALSE		- not exist
		public function exist($id)
		{		
			return( $this->obj_xml->xpath('//link[@id='.$id.']') != array() );
		}

		public function add($name, $url)
		{		
			$new_node = $this->obj_xml->ADD_Element('link','');
			$new_node->addAttribute('id', $this->get_autoinc());
			$new_node->ADD_Element('name', $this->html2text( $name ));
			$new_node->ADD_Element('url', $this->html2text( $url ));
			$this->set_autoinc(1);
		}
		
		public function get_all()
		{
			$tmp_array = array();
			foreach( $this->obj_xml->children() as $children )
			{
				$row 				= array();
				$row['id']		= $children->attributes()->id;
				$row['name']	= (string) utf8_decode($children->name);
				$row['url']		= (string) utf8_decode($children->url);

				array_push($tmp_array, $row);
			}
			return( $tmp_array );
		}
		
		public function set($id, $name, $url)
		{
			$tmp_node = $this->obj_xml->xpath('//link[@id='.$id.']');
			
			if( $tmp_node != array() )
			{
				$tmp_node[0]->name	= utf8_encode($this->html2text($name));
				$tmp_node[0]->url		= utf8_encode($this->html2text($url));
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'LINK_NOT_FOUND';
			}
		}
		
		function delete($id)
		{
			$tmp_node = $this->obj_xml->xpath('//link[@id='.$id.']');

			if( $tmp_node != array() )
			{
				$dom = dom_import_simplexml($tmp_node[0]);
				$dom->parentNode->removeChild($dom);
			}
			else
			{
				$this->flag_error = true;
					$this->flag_i18n = 'LINK_NOT_FOUND';
			}

		}

} // END Class

?>
