<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
 
class POST_DBXML extends NBFUNCTIONS {
       
/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error

		private $files;
		private $files_count;
		
		private $last_insert_id;

/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function POST_DBXML($file)
		{			
			$this->flag_error = false;
			$this->flag_i18n = "";
			$this->last_insert_id = max($this->get_autoinc() - 1, 0);
			$this->files = array();
			$this->files_count = 0;
			
			$this->file_xml = $file;

			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	VIDEO FUNCTIONS
======================================================================================
*/
	// Return Video's ID
	private function get_video_id($url)
	{
		// Youtube ID
		preg_match('/[\\?\\&]v=([^\\?\\&]+)/', $url, $matches);

		return($matches[1]);
	}
	
	// Return Video's thumbnail
	private function get_video_thumbnail($url)
	{
		// Youtube thumbnail
		$video_id = $this->get_video_id( $url );
		$thumbnail = 'http://img.youtube.com/vi/' . $video_id . '/2.jpg';
		
		return( $thumbnail );
	}
	
	// Return Video's embed
	private function get_video_embed($url)
	{
		// Youtube embed HTML 5
		$video_id = $this->get_video_id( $url );
		$embed = '<iframe class="youtube-player" type="text/html" width="640" height="385" src="http://www.youtube.com/embed/'.$video_id.'" frameborder="0"></iframe>';
		
		return( $embed );
	}

/*
======================================================================================
	METHODS
======================================================================================
*/

		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}
		
		public function get_count()
		{
			return( $this->files_count );
		}

		public function get_autoinc()
		{
			return( (int) $this->obj_xml['autoinc'] );
		}

		private function set_autoinc($value = 0)
		{
			$this->obj_xml['autoinc'] = $value + $this->get_autoinc();
		}

		/*
			* ARGS['type']
			* ARGS['title']
			* ARGS['content']
			* ARGS['video']
			* ARGS['album']
			* ARGS['allow_comments']
			* ARGS['idcat']
			* ARGS['iduser']
		*/
		public function add($ARGS)
		{		
			$time_unix = $this->unixstamp();
			$time = $this->unixstamp_to_date(0, $time_unix);
			
			$xml = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
			$xml .= '<post>';
			$xml .= '</post>';

			$obj = new NBXML($xml, 0, FALSE, '', FALSE);
			
			$obj->ADD_Element('type',				$this->html2text($ARGS['type']) );
			$obj->ADD_Element('title',				$this->html2text($ARGS['title']) );
			$obj->ADD_Element('content',			$ARGS['content']);
			$obj->ADD_Element('pub_date',			$time_unix);
			$obj->ADD_Element('mod_date',			'0');
			$obj->ADD_Element('visits',			'0');
			$obj->ADD_Element('allow_comments',	$this->html2text($ARGS['allow_comments']) );
			
			if( $ARGS['type'] == 'video' )
				$obj->ADD_Element('video', $this->html2text($ARGS['video']) );
			
			// Last insert ID
			$idpost = $this->last_insert_id = $this->get_autoinc();

			// Filename for new post
			$time_tmp = $time['Y'] . '.' . $time['m'] . '.' . $time['d'] . '.' . $time['H'] . '.' . $time['i'] . '.' . $time['s'];
			$filename = $idpost . '.' . $ARGS['idcat'] . '.' . $ARGS['iduser'] . '.NULL.' . $time_tmp . '.xml';

			// Save to file
			if( $obj->asXml( PATH_POSTS . $filename ) )
			{
				// Sticky
				if( $ARGS['sticky'] == 1 )
					$this->add_sticky( $this->last_insert_id );
				
				// Autoinc
				$this->set_autoinc(1);
				
				// Save post.xml
				$this->savetofile();
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}

		}

		public function set($ARGS)
		{		
			$this->set_file( $ARGS['idpost'] );
			
			if($this->files_count > 0)
			{
				$obj_xml = new NBXML(PATH_POSTS . $this->files[0], 0, TRUE, '', FALSE);

				$obj_xml->title				= utf8_encode($this->html2text($ARGS['title']));
				$obj_xml->content 			= utf8_encode($ARGS['content']);
				$obj_xml->mod_date 			= utf8_encode($this->unixstamp());
				$obj_xml->allow_comments	= utf8_encode($this->html2text($ARGS['allow_comments']));

				if( $ARGS['sticky'] == 1 )
					$this->add_sticky( $ARGS['idpost'] );
				else
					$this->remove_sticky( $ARGS['idpost'] );

				// Save to file post.xml
				$this->savetofile();

				// Save to file the post
				if( !$obj_xml->asXml( PATH_POSTS . $this->files[0] ) )
				{
					$this->flag_error = true;
					$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
				}
			}
		}

		public function add_sticky($idpost)
		{
			if( !$this->is_sticky($idpost)  )
				$this->obj_xml->sticky->ADD_Element('id', $idpost);
		}

		public function remove_sticky($idpost)
		{
			if( $this->is_sticky($idpost)  )
			{
				$tmp_node = $this->obj_xml->xpath('/post/sticky/id[.="'.$idpost.'"]');
				$dom = dom_import_simplexml($tmp_node[0]);
				$dom->parentNode->removeChild($dom);
			}
		}

		public function get_last_insert_id()
		{
			return( $this->last_insert_id );
		}

		private function set_file($idpost)
		{
			$this->files = $this->ls(PATH_POSTS, $idpost.'.*.*.*.*.*.*.*.*.*', 'xml', false, false, false);
			$this->files_count = count( $this->files );
		}

		// setea los parametros de la clase
		// obtiene todos los archivos post
		private function set_files()
		{
			$this->files = $this->ls(PATH_POSTS, '*', 'xml', false, false, true);
			$this->files_count = count( $this->files );
		}

		private function set_files_by_category($idcat)
		{	
			$this->files = $this->ls(PATH_POSTS, '*.'.$idcat.'.*.*.*.*.*.*.*.*', 'xml', false, false, true);
			$this->files_count = count( $this->files );
		}

		// Devuelve los items de un post
		// File name: IdPost.IdCategory.Iduser.IdOther.YYYY.MM.DD.HH.mm.ss.xml
		private function get_items($file)
		{
			$obj_xml = simplexml_load_file(PATH_POSTS . $file, NULL, TRUE);
		
			$file_info = explode('.', $file);
		
			$content = (string) utf8_decode($obj_xml->content);
			$tmp_content = explode("<!-- pagebreak -->", $content);
		
			$tmp_array = array();

			$tmp_array['filename']			= (string) $file;
			$tmp_array['idpost']				= (int) $file_info[0];
			$tmp_array['idcategory']		= (int) $file_info[1];
			$tmp_array['iduser']				= (int) $file_info[2];
			$tmp_array['type']				= (string) utf8_decode($obj_xml->type);
			$tmp_array['title']				= (string) utf8_decode($obj_xml->title);
			$tmp_array['pub_date']			= (string) utf8_decode($obj_xml->pub_date);
			$tmp_array['mod_date']			= (string) utf8_decode($obj_xml->mod_date);
			$tmp_array['allow_comments']	= (int) utf8_decode($obj_xml->allow_comments);
			$tmp_array['visits']				= (int) utf8_decode($obj_xml->visits);

			$tmp_array['content']			= (string) $content;
			$tmp_array['content_part1']	= (string) $tmp_content[0];
			$tmp_array['content_part2']	= (string) $tmp_content[1];

			$tmp_array['title_rewurl']		= $this->clean_url($tmp_array['title']);

			if($tmp_array['type'] == 'video')
			{
				$tmp_array['video']			= (string) utf8_decode($obj_xml->video);
				$tmp_array['idvideo']		= (string) $this->get_video_id( $tmp_array['video'] );
				$tmp_array['thumbnail1']	= (string) $this->get_video_thumbnail( $tmp_array['video'] );
				$tmp_array['embed']			= (string) $this->get_video_embed( $tmp_array['video'] );
			}

			return( $tmp_array );
		}

		public function is_sticky($idpost)
		{
			return( $this->obj_xml->xpath('/post/sticky/id[.="'.$idpost.'"]') != array() );
		}

		private function get_list_by($page_number, $post_per_page)
		{
			$init = (int) $post_per_page * $page_number;
			$end  = (int) min( ($init + $post_per_page - 1), $this->files_count - 1 );
			$outrange = $init > $end;
			
			$tmp_array = array();
			
			if( !$outrange )
			{
				for($init; $init <= $end; $init++)
				{
					array_push( $tmp_array, $this->get_items( $this->files[$init] ) );
				}
			}
			
			return( $tmp_array );
		}
		
		public function get_list_by_sticky()
		{
			$tmp_array = array();
			foreach( $this->obj_xml->sticky->id as $idpost )
			{
				$this->set_file((int)$idpost);
				array_push( $tmp_array, $this->get_items( $this->files[0] ) );
			}
			
			return( $tmp_array );
		}
		
		public function get_list_by_tag($dbxml_tags, $page_number, $post_per_page)
		{
			return( array() );
		}

		public function get_list_by_archives($month, $year, $page_number, $post_per_page)
		{
			return( array() );
		}

		public function get_list_by_category($page_number, $post_per_page, $idcat)
		{
			$this->set_files_by_category($idcat);
			
			if($this->files_count > 0)
				return( $this->get_list_by($page_number, $post_per_page) );
			else
				return( array() );
		}

		public function get_list_by_page($page_number, $post_per_page)
		{
			// Set the list of post
			$this->set_files();
			
			if($this->files_count > 0)
				return( $this->get_list_by($page_number, $post_per_page) );
			else
				return( array() );
		}

		public function get($idpost)
		{
			// Set the post
			$this->set_file($idpost);

			if($this->files_count > 0)
				return( $this->get_items( $this->files[0] ) );
			else
				return( array() );
		}

		public function delete($idpost)
		{
			$this->set_file($idpost);
			
			if($this->files_count > 0)
			{
				if( !unlink( PATH_POSTS . $this->files[0] ) )
				{
					$this->flag_error = true;
					$this->flag_i18n = 'FILE_COULDNT_BE_DELETED';
				}
			}
		}


} // END Class

?>
