<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
    
class RSS_DBXML extends NBFUNCTIONS {

/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error
	
/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function RSS_DBXML($file)
		{			
			$this->flag_error = false;
			$this->flag_i18n = "";

			$this->file_xml = $file;

			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	METHODS
======================================================================================
*/
		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}
		
		public function create_body($title, $link, $description, $lastBuildDate)
		{				
			unset($this->obj_xml->channel);
			
			$node = $this->obj_xml->ADD_Element('channel', '');
			$node->ADD_Element('title', utf8_decode($this->text2html($title)));
			$node->ADD_Element('link', $link);
			$node->ADD_Element('description', utf8_decode($this->text2html($description)));
			$node->ADD_Element('lastBuildDate', $lastBuildDate);
			$node->ADD_Element('generator', 'Nibbleblog');
		}
		
		public function add_item($title, $link, $description, $pubDate)
		{	
			$node = $this->obj_xml->channel->ADD_Element('item', '');
			$node->ADD_Element('title', utf8_decode($this->text2html($title)));
			$node->ADD_Element('link', $link);
			$node->ADD_Element('description', utf8_decode($description));
			$node->ADD_Element('pubDate', $pubDate);
			$guid = $node->ADD_Element('guid', $link);
			$guid->addAttribute('isPermaLink','false');
		}

} // END Class

?>
