<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
    
class SYSLOG_DBXML extends NBFUNCTIONS {

/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error
	
/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function SYSLOG_DBXML($file)
		{			
			// Inicializo flags de error
			$this->flag_error = false;
			$this->flag_i18n = "";

			$this->file_xml = $file;

			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	METHODS
======================================================================================
*/
		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}
			
		function add_session()
		{
			if( count( $this->obj_xml->login->session ) > 4)
				unset( $this->obj_xml->login->session[0] );
			
			$node = $this->obj_xml->login->ADD_Element('session','');	
			$node->addAttribute('ip',$this->get_user_ip());
			$node->addAttribute('date',$this->unixstamp());
			
			$this->savetofile();
		}

		function get_all_sessions()
		{
			$tmp_array = array();
			foreach( $this->obj_xml->login->session as $session )
			{
				$row = array();
				$row['ip'] = (string) $session->attributes()->ip;
				$row['date'] = (string) $session->attributes()->date;
				array_push( $tmp_array, $row );
			}
			return( array_reverse($tmp_array) );
		}

} // END Class

?>
