<?php

require('../variables.php');

header("Content-Type: text/xml");

if( $_SERVER['REQUEST_METHOD'] != 'POST' )
	exit( $nb_functions->ajax_header('<error><![CDATA[1]]></error><msj><![CDATA[]]></msj>') );

if( !$nb_functions->valid_int($_POST['idpost']) )
	exit( $nb_functions->ajax_header('<error><![CDATA[2]]></error><msj><![CDATA[]]></msj>') );

$ARGS 					= array();
$ARGS['idpost']		= $_POST['idpost'];
$ARGS['iduser'] 		= 'NULL';
$ARGS['content']		= nl2br($_POST['content']);
$ARGS['author_name']	= $_POST['name'];
$ARGS['author_email']= $_POST['email'];
$ARGS['author_web']	= $_POST['web'];
$ARGS['author_ip']	= $nb_functions->get_user_ip();

if( $login->is_login() )
{
	$ARGS['iduser'] = $login->get_iduser();
}
else
{
	if( $nb_comments->spam_exist( $ARGS['author_ip'] ) )
		exit( $nb_functions->ajax_header('<error><![CDATA[3]]></error><msj><![CDATA[Spam detected]]></msj>') );

	if( !$nb_functions->valid_mail($_POST['email']) )
		exit( $nb_functions->ajax_header('<error><![CDATA[4]]></error><msj><![CDATA[Invalid email]]></msj>') );

	if( strcmp($_POST['captcha'],$_SESSION['nb_captcha']) != 0 )
		exit( $nb_functions->ajax_header('<error><![CDATA[5]]></error><msj><![CDATA[Invalid captcha]]></msj>') );

	if( $nb_blog->get_mail_notification() == 1)
	{
		$mail_html = '
			<p><b>'.$_LANG['AUTHOR'].':</b> '.$ARGS['author_name'].'</p>
			<p><b>'.$_LANG['EMAIL'].':</b> '.$ARGS['author_email'].'</p>
			<p><b>'.$_LANG['COMMENT'].':</b> '.$ARGS['content'].'</p>
			<p><b>'.$_LANG['POSTED_IN'].':</b> '.$nb_blog->get_url().$nb_blog->get_path().'post.php?idpost='.$ARGS['idpost'].'</p>';

		$nb_mail->send('Nibbleblog', $ARGS['author_email'], $nb_profiles->get_email(0), $_LANG['NEW_COMMENT_AT_YOUR_BLOG'], $mail_html);
	}
}

$nb_comments->add($ARGS);

if( $nb_comments->flag_error() )
	exit( $nb_functions->ajax_header('<error><![CDATA[6]]></error><msj><![CDATA['.$_LANG[$nb_comments->flag_i18n()].']]></msj>') );
else
	exit( $nb_functions->ajax_header('<success><![CDATA[1]]></success><msj><![CDATA['.$_LANG[$nb_comments->flag_i18n()].']]></msj>') );

?>
