<?php
	
foreach( $posts_list as $post )
{
	// Category info
	$category = $nb_categories->get( $post['idcategory'] );
	
	// Date
	$date = $nb_functions->unixstamp_to_date($nb_blog->get_timezone(), $post['pub_date']);
	$date = $_LANG['ARRAY_DAYS'][ $date['N'] ].' - '.$_LANG['ARRAY_MONTHS'][ $date['n'] ].' '.$date['d'].', '.$date['Y'];

	// Title link for href
	if( BOOLEAN_REWRITEURL )
		$title_href = HTML_PATH_BASE . 'post/'.$post['idpost'].'/'.$post['title_rewurl'].'.html';
	else
		$title_href = 'post.php?idpost='.$post['idpost'];

	// Content
	if( $post['type'] == 'video' )
	{
		$style = 'bg_video';
		$content = '<div class="post_video_thumbnail"><img src="'.$post['thumbnail1'].'" class="thumbnail" /></div>';
		$content .= '<div class="post_video_description">'.$post['content'].'</div>';
		$content .= '<br class="clearfloat" />';
		$content .= '<script type="text/javascript">$(".post_video_thumbnail").click( function() { $(this).parent().html(\''.$post['embed'].'\'); });</script>';
	}
	else
	{
		$style = 'bg_simple';
		$content = $post['content_part1'];
	}
	
	// HTML
	echo '<div class="post_container">';
		echo '<div class="post_title"><a class="post_title" href="'.$title_href.'">'.$post['title'].'</a></div>';
		echo '<div class="post_date '.$style.'">'.$date.' | '.$category['name'].'</div>';
		echo '<div class="post_content">'.$content.'</div>';
		echo '<div class="post_readmore"><a href="'.$title_href.'">'.$_LANG['READ_MORE'].'...</a></div>';
	echo '</div>';
	
	// Flush the buffer
	ob_flush();
}

?>
