# -*- coding: utf-8 *-*

from __future__ import absolute_import

import logging

from PyQt4.QtGui import QWidget
from PyQt4.QtGui import QTabWidget
from PyQt4.QtGui import QVBoxLayout

from ninja_ide.core import plugin_manager

logger = logging.getLogger('ninja_ide.gui.misc.plugin_preferences')


class PluginPreferences(QWidget):
    """
    Plugins section widget in NINJA-IDE Preferences
    """
    def __init__(self):
        QWidget.__init__(self)
        self.plugin_manager = plugin_manager.PluginManager()
        vbox = QVBoxLayout(self)
        self._tabs = QTabWidget()
        vbox.addWidget(self._tabs)
        #load widgets
        self._load_widgets()

    def _load_widgets(self):
        logger.info("Loading plugins preferences widgets")
        #Collect the preferences widget for each active plugin
        for plugin in self.plugin_manager.get_actives_plugins():
            plugin_name = plugin.metadata.get('name')
            try:
                preferences_widget = plugin.get_preferences_widget()
                if preferences_widget:
                    self._tabs.addTab(preferences_widget, plugin_name)
            except Exception, reason:
                logger.error("Unable to add the preferences widget (%s): %s",
                    plugin_name, reason)
                continue

    def save(self):
        logger.info("Saving plugins preferences")
        for i in xrange(self._tabs.count()):
            try:
                self._tabs.widget(i).save()
            except Exception, reason:
                logger.error("Unable to save preferences (%s): %s",
                    self._tabs.tabText(i), reason)
                continue
